/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.consumer.AckCallback;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeReturnType;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.hook.ConsumeMessageContext;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageService;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.PopProcessQueue;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.stat.ConsumerStatsManager;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.CMResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;

public class ConsumeMessagePopConcurrentlyService
implements ConsumeMessageService {
    private static final Logger log = LoggerFactory.getLogger(ConsumeMessagePopConcurrentlyService.class);
    private final DefaultMQPushConsumerImpl defaultMQPushConsumerImpl;
    private final DefaultMQPushConsumer defaultMQPushConsumer;
    private final MessageListenerConcurrently messageListener;
    private final BlockingQueue<Runnable> consumeRequestQueue;
    private final ThreadPoolExecutor consumeExecutor;
    private final String consumerGroup;
    private final ScheduledExecutorService scheduledExecutorService;

    public ConsumeMessagePopConcurrentlyService(DefaultMQPushConsumerImpl defaultMQPushConsumerImpl, MessageListenerConcurrently messageListener) {
        this.defaultMQPushConsumerImpl = defaultMQPushConsumerImpl;
        this.messageListener = messageListener;
        this.defaultMQPushConsumer = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer();
        this.consumerGroup = this.defaultMQPushConsumer.getConsumerGroup();
        this.consumeRequestQueue = new LinkedBlockingQueue<Runnable>();
        this.consumeExecutor = new ThreadPoolExecutor(this.defaultMQPushConsumer.getConsumeThreadMin(), this.defaultMQPushConsumer.getConsumeThreadMax(), 60000L, TimeUnit.MILLISECONDS, this.consumeRequestQueue, (ThreadFactory)new ThreadFactoryImpl("ConsumeMessageThread_"));
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("ConsumeMessageScheduledThread_"));
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown(long awaitTerminateMillis) {
        this.scheduledExecutorService.shutdown();
        ThreadUtils.shutdownGracefully((ExecutorService)this.consumeExecutor, (long)awaitTerminateMillis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void updateCorePoolSize(int corePoolSize) {
        if (corePoolSize > 0 && corePoolSize <= Short.MAX_VALUE && corePoolSize < this.defaultMQPushConsumer.getConsumeThreadMax()) {
            this.consumeExecutor.setCorePoolSize(corePoolSize);
        }
    }

    @Override
    public void incCorePoolSize() {
    }

    @Override
    public void decCorePoolSize() {
    }

    @Override
    public int getCorePoolSize() {
        return this.consumeExecutor.getCorePoolSize();
    }

    @Override
    public ConsumeMessageDirectlyResult consumeMessageDirectly(MessageExt msg, String brokerName) {
        ConsumeMessageDirectlyResult result = new ConsumeMessageDirectlyResult();
        result.setOrder(false);
        result.setAutoCommit(true);
        ArrayList<MessageExt> msgs = new ArrayList<MessageExt>();
        msgs.add(msg);
        MessageQueue mq = new MessageQueue();
        mq.setBrokerName(brokerName);
        mq.setTopic(msg.getTopic());
        mq.setQueueId(msg.getQueueId());
        ConsumeConcurrentlyContext context = new ConsumeConcurrentlyContext(mq);
        this.defaultMQPushConsumerImpl.resetRetryAndNamespace(msgs, this.consumerGroup);
        long beginTime = System.currentTimeMillis();
        log.info("consumeMessageDirectly receive new message: {}", (Object)msg);
        try {
            ConsumeConcurrentlyStatus status = this.messageListener.consumeMessage(msgs, context);
            if (status != null) {
                switch (status) {
                    case CONSUME_SUCCESS: {
                        result.setConsumeResult(CMResult.CR_SUCCESS);
                        break;
                    }
                    case RECONSUME_LATER: {
                        result.setConsumeResult(CMResult.CR_LATER);
                        break;
                    }
                }
            } else {
                result.setConsumeResult(CMResult.CR_RETURN_NULL);
            }
        }
        catch (Throwable e) {
            result.setConsumeResult(CMResult.CR_THROW_EXCEPTION);
            result.setRemark(UtilAll.exceptionSimpleDesc((Throwable)e));
            log.warn(String.format("consumeMessageDirectly exception: %s Group: %s Msgs: %s MQ: %s", UtilAll.exceptionSimpleDesc((Throwable)e), this.consumerGroup, msgs, mq), e);
        }
        result.setSpentTimeMills(System.currentTimeMillis() - beginTime);
        log.info("consumeMessageDirectly Result: {}", (Object)result);
        return result;
    }

    @Override
    public void submitConsumeRequest(List<MessageExt> msgs, ProcessQueue processQueue, MessageQueue messageQueue, boolean dispathToConsume) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void submitPopConsumeRequest(List<MessageExt> msgs, PopProcessQueue processQueue, MessageQueue messageQueue) {
        int consumeBatchSize = this.defaultMQPushConsumer.getConsumeMessageBatchMaxSize();
        if (msgs.size() <= consumeBatchSize) {
            ConsumeRequest consumeRequest = new ConsumeRequest(msgs, processQueue, messageQueue);
            try {
                this.consumeExecutor.submit(consumeRequest);
            }
            catch (RejectedExecutionException e) {
                this.submitConsumeRequestLater(consumeRequest);
            }
        } else {
            int total = 0;
            while (total < msgs.size()) {
                ArrayList<MessageExt> msgThis = new ArrayList<MessageExt>(consumeBatchSize);
                for (int i = 0; i < consumeBatchSize && total < msgs.size(); ++i, ++total) {
                    msgThis.add(msgs.get(total));
                }
                ConsumeRequest consumeRequest = new ConsumeRequest(msgThis, processQueue, messageQueue);
                try {
                    this.consumeExecutor.submit(consumeRequest);
                }
                catch (RejectedExecutionException e) {
                    while (total < msgs.size()) {
                        msgThis.add(msgs.get(total));
                        ++total;
                    }
                    this.submitConsumeRequestLater(consumeRequest);
                }
            }
        }
    }

    public void processConsumeResult(ConsumeConcurrentlyStatus status, ConsumeConcurrentlyContext context, ConsumeRequest consumeRequest) {
        int i;
        if (consumeRequest.getMsgs().isEmpty()) {
            return;
        }
        int ackIndex = context.getAckIndex();
        String topic = consumeRequest.getMessageQueue().getTopic();
        switch (status) {
            case CONSUME_SUCCESS: {
                if (ackIndex >= consumeRequest.getMsgs().size()) {
                    ackIndex = consumeRequest.getMsgs().size() - 1;
                }
                int ok = ackIndex + 1;
                int failed = consumeRequest.getMsgs().size() - ok;
                this.getConsumerStatsManager().incConsumeOKTPS(this.consumerGroup, topic, ok);
                this.getConsumerStatsManager().incConsumeFailedTPS(this.consumerGroup, topic, failed);
                break;
            }
            case RECONSUME_LATER: {
                ackIndex = -1;
                this.getConsumerStatsManager().incConsumeFailedTPS(this.consumerGroup, topic, consumeRequest.getMsgs().size());
                break;
            }
        }
        for (i = 0; i <= ackIndex; ++i) {
            this.defaultMQPushConsumerImpl.ackAsync(consumeRequest.getMsgs().get(i), this.consumerGroup);
            consumeRequest.getPopProcessQueue().ack();
        }
        for (i = ackIndex + 1; i < consumeRequest.getMsgs().size(); ++i) {
            MessageExt msgExt = consumeRequest.getMsgs().get(i);
            consumeRequest.getPopProcessQueue().ack();
            if (msgExt.getReconsumeTimes() >= this.defaultMQPushConsumerImpl.getMaxReconsumeTimes()) {
                this.checkNeedAckOrDelay(msgExt);
                continue;
            }
            int delayLevel = context.getDelayLevelWhenNextConsume();
            this.changePopInvisibleTime(consumeRequest.getMsgs().get(i), this.consumerGroup, delayLevel);
        }
    }

    private void checkNeedAckOrDelay(MessageExt msgExt) {
        int[] delayLevelTable = this.defaultMQPushConsumerImpl.getPopDelayLevel();
        long msgDelaytime = System.currentTimeMillis() - msgExt.getBornTimestamp();
        if (msgDelaytime > (long)(delayLevelTable[delayLevelTable.length - 1] * 1000 * 2)) {
            log.warn("Consume too many times, ack message async. message {}", (Object)msgExt.toString());
            this.defaultMQPushConsumerImpl.ackAsync(msgExt, this.consumerGroup);
        } else {
            int delayLevel;
            for (delayLevel = delayLevelTable.length - 1; delayLevel >= 0; --delayLevel) {
                if (msgDelaytime < (long)(delayLevelTable[delayLevel] * 1000)) continue;
                ++delayLevel;
                break;
            }
            this.changePopInvisibleTime(msgExt, this.consumerGroup, delayLevel);
            log.warn("Consume too many times, but delay time {} not enough. changePopInvisibleTime to delayLevel {} . message key:{}", new Object[]{msgDelaytime, delayLevel, msgExt.getKeys()});
        }
    }

    private void changePopInvisibleTime(final MessageExt msg, String consumerGroup, int delayLevel) {
        int[] delayLevelTable;
        if (0 == delayLevel) {
            delayLevel = msg.getReconsumeTimes();
        }
        int delaySecond = delayLevel >= (delayLevelTable = this.defaultMQPushConsumerImpl.getPopDelayLevel()).length ? delayLevelTable[delayLevelTable.length - 1] : delayLevelTable[delayLevel];
        String extraInfo = msg.getProperty("POP_CK");
        try {
            this.defaultMQPushConsumerImpl.changePopInvisibleTimeAsync(msg.getTopic(), consumerGroup, extraInfo, (long)delaySecond * 1000L, new AckCallback(){

                @Override
                public void onSuccess(AckResult ackResult) {
                }

                @Override
                public void onException(Throwable e) {
                    log.error("changePopInvisibleTimeAsync fail. msg:{} error info: {}", (Object)msg.toString(), (Object)e.toString());
                }
            });
        }
        catch (Throwable t) {
            log.error("changePopInvisibleTimeAsync fail, group:{} msg:{} errorInfo:{}", new Object[]{consumerGroup, msg.toString(), t.toString()});
        }
    }

    public ConsumerStatsManager getConsumerStatsManager() {
        return this.defaultMQPushConsumerImpl.getConsumerStatsManager();
    }

    private void submitConsumeRequestLater(final List<MessageExt> msgs, final PopProcessQueue processQueue, final MessageQueue messageQueue) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                ConsumeMessagePopConcurrentlyService.this.submitPopConsumeRequest(msgs, processQueue, messageQueue);
            }
        }, 5000L, TimeUnit.MILLISECONDS);
    }

    private void submitConsumeRequestLater(final ConsumeRequest consumeRequest) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                ConsumeMessagePopConcurrentlyService.this.consumeExecutor.submit(consumeRequest);
            }
        }, 5000L, TimeUnit.MILLISECONDS);
    }

    class ConsumeRequest
    implements Runnable {
        private final List<MessageExt> msgs;
        private final PopProcessQueue processQueue;
        private final MessageQueue messageQueue;
        private long popTime = 0L;
        private long invisibleTime = 0L;

        public ConsumeRequest(List<MessageExt> msgs, PopProcessQueue processQueue, MessageQueue messageQueue) {
            this.msgs = msgs;
            this.processQueue = processQueue;
            this.messageQueue = messageQueue;
            try {
                String extraInfo = msgs.get(0).getProperty("POP_CK");
                String[] extraInfoStrs = ExtraInfoUtil.split((String)extraInfo);
                this.popTime = ExtraInfoUtil.getPopTime((String[])extraInfoStrs);
                this.invisibleTime = ExtraInfoUtil.getInvisibleTime((String[])extraInfoStrs);
            }
            catch (Throwable t) {
                log.error("parse extra info error. msg:" + msgs.get(0), t);
            }
        }

        public boolean isPopTimeout() {
            if (this.msgs.size() == 0 || this.popTime <= 0L || this.invisibleTime <= 0L) {
                return true;
            }
            long current = System.currentTimeMillis();
            return current - this.popTime >= this.invisibleTime;
        }

        public List<MessageExt> getMsgs() {
            return this.msgs;
        }

        public PopProcessQueue getPopProcessQueue() {
            return this.processQueue;
        }

        @Override
        public void run() {
            if (this.processQueue.isDropped()) {
                log.info("the message queue not be able to consume, because it's dropped(pop). group={} {}", (Object)ConsumeMessagePopConcurrentlyService.this.consumerGroup, (Object)this.messageQueue);
                return;
            }
            if (this.isPopTimeout()) {
                log.info("the pop message time out so abort consume. popTime={} invisibleTime={}, group={} {}", new Object[]{this.popTime, this.invisibleTime, ConsumeMessagePopConcurrentlyService.this.consumerGroup, this.messageQueue});
                this.processQueue.decFoundMsg(-this.msgs.size());
                return;
            }
            MessageListenerConcurrently listener = ConsumeMessagePopConcurrentlyService.this.messageListener;
            ConsumeConcurrentlyContext context = new ConsumeConcurrentlyContext(this.messageQueue);
            ConsumeConcurrentlyStatus status = null;
            ConsumeMessagePopConcurrentlyService.this.defaultMQPushConsumerImpl.resetRetryAndNamespace(this.msgs, ConsumeMessagePopConcurrentlyService.this.defaultMQPushConsumer.getConsumerGroup());
            ConsumeMessageContext consumeMessageContext = null;
            if (ConsumeMessagePopConcurrentlyService.this.defaultMQPushConsumerImpl.hasHook()) {
                consumeMessageContext = new ConsumeMessageContext();
                consumeMessageContext.setNamespace(ConsumeMessagePopConcurrentlyService.this.defaultMQPushConsumer.getNamespace());
                consumeMessageContext.setConsumerGroup(ConsumeMessagePopConcurrentlyService.this.defaultMQPushConsumer.getConsumerGroup());
                consumeMessageContext.setProps(new HashMap<String, String>());
                consumeMessageContext.setMq(this.messageQueue);
                consumeMessageContext.setMsgList(this.msgs);
                consumeMessageContext.setSuccess(false);
                ConsumeMessagePopConcurrentlyService.this.defaultMQPushConsumerImpl.executeHookBefore(consumeMessageContext);
            }
            long beginTimestamp = System.currentTimeMillis();
            boolean hasException = false;
            ConsumeReturnType returnType = ConsumeReturnType.SUCCESS;
            try {
                if (this.msgs != null && !this.msgs.isEmpty()) {
                    for (MessageExt msg : this.msgs) {
                        MessageAccessor.setConsumeStartTimeStamp((Message)msg, (String)String.valueOf(System.currentTimeMillis()));
                    }
                }
                status = listener.consumeMessage(Collections.unmodifiableList(this.msgs), context);
            }
            catch (Throwable e) {
                log.warn("consumeMessage exception: {} Group: {} Msgs: {} MQ: {}", new Object[]{UtilAll.exceptionSimpleDesc((Throwable)e), ConsumeMessagePopConcurrentlyService.this.consumerGroup, this.msgs, this.messageQueue});
                hasException = true;
            }
            long consumeRT = System.currentTimeMillis() - beginTimestamp;
            if (null == status) {
                returnType = hasException ? ConsumeReturnType.EXCEPTION : ConsumeReturnType.RETURNNULL;
            } else if (consumeRT >= this.invisibleTime * 1000L) {
                returnType = ConsumeReturnType.TIME_OUT;
            } else if (ConsumeConcurrentlyStatus.RECONSUME_LATER == status) {
                returnType = ConsumeReturnType.FAILED;
            } else if (ConsumeConcurrentlyStatus.CONSUME_SUCCESS == status) {
                returnType = ConsumeReturnType.SUCCESS;
            }
            if (null == status) {
                log.warn("consumeMessage return null, Group: {} Msgs: {} MQ: {}", new Object[]{ConsumeMessagePopConcurrentlyService.this.consumerGroup, this.msgs, this.messageQueue});
                status = ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
            if (ConsumeMessagePopConcurrentlyService.this.defaultMQPushConsumerImpl.hasHook()) {
                consumeMessageContext.getProps().put("ConsumeContextType", returnType.name());
                consumeMessageContext.setStatus(status.toString());
                consumeMessageContext.setSuccess(ConsumeConcurrentlyStatus.CONSUME_SUCCESS == status);
                ConsumeMessagePopConcurrentlyService.this.defaultMQPushConsumerImpl.executeHookAfter(consumeMessageContext);
            }
            ConsumeMessagePopConcurrentlyService.this.getConsumerStatsManager().incConsumeRT(ConsumeMessagePopConcurrentlyService.this.consumerGroup, this.messageQueue.getTopic(), consumeRT);
            if (!this.processQueue.isDropped() && !this.isPopTimeout()) {
                ConsumeMessagePopConcurrentlyService.this.processConsumeResult(status, context, this);
            } else {
                if (this.msgs != null) {
                    this.processQueue.decFoundMsg(-this.msgs.size());
                }
                log.warn("processQueue invalid. isDropped={}, isPopTimeout={}, messageQueue={}, msgs={}", new Object[]{this.processQueue.isDropped(), this.isPopTimeout(), this.messageQueue, this.msgs});
            }
        }

        public MessageQueue getMessageQueue() {
            return this.messageQueue;
        }
    }
}

