/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft;

import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.core.CliServiceImpl;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.option.NodeOptions;

public final class RaftServiceFactory {
    public static Node createRaftNode(String groupId, PeerId serverId) {
        return new NodeImpl(groupId, serverId);
    }

    public static Node createAndInitRaftNode(String groupId, PeerId serverId, NodeOptions opts) {
        Node ret = RaftServiceFactory.createRaftNode(groupId, serverId);
        if (!ret.init(opts)) {
            throw new IllegalStateException("Fail to init node, please see the logs to find the reason.");
        }
        return ret;
    }

    public static CliService createCliService() {
        return new CliServiceImpl();
    }

    public static CliService createAndInitCliService(CliOptions cliOptions) {
        CliService ret = RaftServiceFactory.createCliService();
        if (!ret.init(cliOptions)) {
            throw new IllegalStateException("Fail to init CliService");
        }
        return ret;
    }
}

