/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueOffsetTable;
import org.apache.rocketmq.store.rocksdb.ConsumeQueueRocksDBStorage;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;

public class RocksDBConsumeQueueTable {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger ROCKSDB_LOG = LoggerFactory.getLogger((String)"RocketmqRocksDB");
    private static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final int PHY_OFFSET_OFFSET = 0;
    private static final int PHY_MSG_LEN_OFFSET = 8;
    private static final int MSG_TAG_HASHCODE_OFFSET = 12;
    private static final int MSG_STORE_TIME_SIZE_OFFSET = 20;
    public static final int CQ_UNIT_SIZE = 28;
    private static final int CQ_KEY_LENGTH_WITHOUT_TOPIC_BYTES = 19;
    private static final int DELETE_CQ_KEY_LENGTH_WITHOUT_TOPIC_BYTES = 11;
    private final ConsumeQueueRocksDBStorage rocksDBStorage;
    private final DefaultMessageStore messageStore;
    private ColumnFamilyHandle defaultCFH;

    public RocksDBConsumeQueueTable(ConsumeQueueRocksDBStorage rocksDBStorage, DefaultMessageStore messageStore) {
        this.rocksDBStorage = rocksDBStorage;
        this.messageStore = messageStore;
    }

    public void load() {
        this.defaultCFH = this.rocksDBStorage.getDefaultCFHandle();
    }

    public void buildAndPutCQByteBuffer(Pair<ByteBuffer, ByteBuffer> cqBBPair, byte[] topicBytes, DispatchRequest request, WriteBatch writeBatch) throws RocksDBException {
        ByteBuffer cqKey = (ByteBuffer)cqBBPair.getObject1();
        this.buildCQKeyByteBuffer(cqKey, topicBytes, request.getQueueId(), request.getConsumeQueueOffset());
        ByteBuffer cqValue = (ByteBuffer)cqBBPair.getObject2();
        this.buildCQValueByteBuffer(cqValue, request.getCommitLogOffset(), request.getMsgSize(), request.getTagsCode(), request.getStoreTimestamp());
        writeBatch.put(this.defaultCFH, cqKey, cqValue);
    }

    public ByteBuffer getCQInKV(String topic, int queueId, long cqOffset) throws RocksDBException {
        byte[] topicBytes = topic.getBytes(DataConverter.CHARSET_UTF8);
        ByteBuffer keyBB = this.buildCQKeyByteBuffer(topicBytes, queueId, cqOffset);
        byte[] value = this.rocksDBStorage.getCQ(keyBB.array());
        return value != null ? ByteBuffer.wrap(value) : null;
    }

    public List<ByteBuffer> rangeQuery(String topic, int queueId, long startIndex, int num) throws RocksDBException {
        ByteBuffer byteBuffer;
        int i;
        byte[] topicBytes = topic.getBytes(DataConverter.CHARSET_UTF8);
        ArrayList<ColumnFamilyHandle> defaultCFHList = new ArrayList<ColumnFamilyHandle>(num);
        ByteBuffer[] resultList = new ByteBuffer[num];
        ArrayList<Integer> kvIndexList = new ArrayList<Integer>(num);
        ArrayList<byte[]> kvKeyList = new ArrayList<byte[]>(num);
        for (int i2 = 0; i2 < num; ++i2) {
            ByteBuffer keyBB = this.buildCQKeyByteBuffer(topicBytes, queueId, startIndex + (long)i2);
            kvIndexList.add(i2);
            kvKeyList.add(keyBB.array());
            defaultCFHList.add(this.defaultCFH);
        }
        int keyNum = kvIndexList.size();
        if (keyNum > 0) {
            List<byte[]> kvValueList = this.rocksDBStorage.multiGet(defaultCFHList, kvKeyList);
            int valueNum = kvValueList.size();
            if (keyNum != valueNum) {
                throw new RocksDBException("rocksdb bug, multiGet");
            }
            for (i = 0; i < valueNum; ++i) {
                ByteBuffer byteBuffer2;
                byte[] value = kvValueList.get(i);
                if (value == null) continue;
                resultList[((Integer)kvIndexList.get((int)i)).intValue()] = byteBuffer2 = ByteBuffer.wrap(value);
            }
        }
        int resultSize = resultList.length;
        ArrayList<ByteBuffer> bbValueList = new ArrayList<ByteBuffer>(resultSize);
        for (i = 0; i < resultSize && (byteBuffer = resultList[i]) != null; ++i) {
            bbValueList.add(byteBuffer);
        }
        return bbValueList;
    }

    public void destroyCQ(String topic, int queueId, WriteBatch writeBatch) throws RocksDBException {
        byte[] topicBytes = topic.getBytes(DataConverter.CHARSET_UTF8);
        ByteBuffer cqStartKey = this.buildDeleteCQKey(true, topicBytes, queueId);
        ByteBuffer cqEndKey = this.buildDeleteCQKey(false, topicBytes, queueId);
        writeBatch.deleteRange(this.defaultCFH, cqStartKey.array(), cqEndKey.array());
        log.info("Rocksdb consumeQueue table delete topic. {}, {}", (Object)topic, (Object)queueId);
    }

    public long binarySearchInCQByTime(String topic, int queueId, long high, long low, long timestamp, long minPhysicOffset, BoundaryType boundaryType) throws RocksDBException {
        ByteBuffer byteBuffer;
        long result = -1L;
        long targetOffset = -1L;
        long leftOffset = -1L;
        long rightOffset = -1L;
        long ceiling = high;
        long floor = low;
        while (high >= low) {
            long midOffset = low + (high - low >>> 1);
            byteBuffer = this.getCQInKV(topic, queueId, midOffset);
            if (byteBuffer == null) {
                ERROR_LOG.warn("binarySearchInCQByTimeStamp Failed. topic: {}, queueId: {}, timestamp: {}, result: null", new Object[]{topic, queueId, timestamp});
                low = midOffset + 1L;
                continue;
            }
            long phyOffset = byteBuffer.getLong(0);
            if (phyOffset < minPhysicOffset) {
                low = midOffset + 1L;
                leftOffset = midOffset;
                continue;
            }
            long storeTime = byteBuffer.getLong(20);
            if (storeTime < 0L) {
                return 0L;
            }
            if (storeTime == timestamp) {
                targetOffset = midOffset;
                break;
            }
            if (storeTime > timestamp) {
                high = midOffset - 1L;
                rightOffset = midOffset;
                continue;
            }
            low = midOffset + 1L;
            leftOffset = midOffset;
        }
        if (targetOffset != -1L) {
            switch (boundaryType) {
                case LOWER: {
                    long storeTime;
                    long nextOffset;
                    while ((nextOffset = targetOffset - 1L) >= floor && (storeTime = (byteBuffer = this.getCQInKV(topic, queueId, nextOffset)).getLong(20)) == timestamp) {
                        targetOffset = nextOffset;
                    }
                    break;
                }
                case UPPER: {
                    long storeTime;
                    long nextOffset;
                    while ((nextOffset = targetOffset + 1L) <= ceiling && (storeTime = (byteBuffer = this.getCQInKV(topic, queueId, nextOffset)).getLong(20)) == timestamp) {
                        targetOffset = nextOffset;
                    }
                    break;
                }
                default: {
                    log.warn("Unknown boundary type");
                }
            }
            result = targetOffset;
        } else {
            switch (boundaryType) {
                case LOWER: {
                    result = rightOffset;
                    break;
                }
                case UPPER: {
                    result = leftOffset;
                    break;
                }
                default: {
                    log.warn("Unknown boundary type");
                }
            }
        }
        return result;
    }

    public RocksDBConsumeQueueOffsetTable.PhyAndCQOffset binarySearchInCQ(String topic, int queueId, long high, long low, long targetPhyOffset, boolean min) throws RocksDBException {
        long resultCQOffset = -1L;
        long resultPhyOffset = -1L;
        while (high >= low) {
            long midCQOffset = low + (high - low >>> 1);
            ByteBuffer byteBuffer = this.getCQInKV(topic, queueId, midCQOffset);
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("binarySearchInCQ. {}, {}, {}, {}, {}", new Object[]{topic, queueId, midCQOffset, low, high});
            }
            if (byteBuffer == null) {
                low = midCQOffset + 1L;
                continue;
            }
            long phyOffset = byteBuffer.getLong(0);
            if (phyOffset == targetPhyOffset) {
                if (!min) break;
                resultCQOffset = midCQOffset;
                resultPhyOffset = phyOffset;
                break;
            }
            if (phyOffset > targetPhyOffset) {
                high = midCQOffset - 1L;
                if (!min) continue;
                resultCQOffset = midCQOffset;
                resultPhyOffset = phyOffset;
                continue;
            }
            low = midCQOffset + 1L;
            if (min) continue;
            resultCQOffset = midCQOffset;
            resultPhyOffset = phyOffset;
        }
        return new RocksDBConsumeQueueOffsetTable.PhyAndCQOffset(resultPhyOffset, resultCQOffset);
    }

    public static Pair<ByteBuffer, ByteBuffer> getCQByteBufferPair() {
        ByteBuffer cqKey = ByteBuffer.allocateDirect(300);
        ByteBuffer cqValue = ByteBuffer.allocateDirect(28);
        return new Pair((Object)cqKey, (Object)cqValue);
    }

    private ByteBuffer buildCQKeyByteBuffer(byte[] topicBytes, int queueId, long cqOffset) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(19 + topicBytes.length);
        this.buildCQKeyByteBuffer0(byteBuffer, topicBytes, queueId, cqOffset);
        return byteBuffer;
    }

    private void buildCQKeyByteBuffer(ByteBuffer byteBuffer, byte[] topicBytes, int queueId, long cqOffset) {
        byteBuffer.position(0).limit(19 + topicBytes.length);
        this.buildCQKeyByteBuffer0(byteBuffer, topicBytes, queueId, cqOffset);
    }

    private void buildCQKeyByteBuffer0(ByteBuffer byteBuffer, byte[] topicBytes, int queueId, long cqOffset) {
        byteBuffer.putInt(topicBytes.length).put((byte)1).put(topicBytes).put((byte)1).putInt(queueId).put((byte)1).putLong(cqOffset);
        byteBuffer.flip();
    }

    private void buildCQValueByteBuffer(ByteBuffer byteBuffer, long phyOffset, int msgSize, long tagsCode, long storeTimestamp) {
        byteBuffer.position(0).limit(28);
        this.buildCQValueByteBuffer0(byteBuffer, phyOffset, msgSize, tagsCode, storeTimestamp);
    }

    private void buildCQValueByteBuffer0(ByteBuffer byteBuffer, long phyOffset, int msgSize, long tagsCode, long storeTimestamp) {
        byteBuffer.putLong(phyOffset).putInt(msgSize).putLong(tagsCode).putLong(storeTimestamp);
        byteBuffer.flip();
    }

    private ByteBuffer buildDeleteCQKey(boolean start, byte[] topicBytes, int queueId) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(11 + topicBytes.length);
        byteBuffer.putInt(topicBytes.length).put((byte)1).put(topicBytes).put((byte)1).putInt(queueId).put(start ? (byte)0 : 2);
        byteBuffer.flip();
        return byteBuffer;
    }
}

