/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.message;

import io.netty.channel.ChannelHandlerContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.AckStatus;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.consumer.PopStatus;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.service.channel.ChannelManager;
import org.apache.rocketmq.proxy.service.channel.InvocationContext;
import org.apache.rocketmq.proxy.service.channel.SimpleChannel;
import org.apache.rocketmq.proxy.service.message.LocalRemotingCommand;
import org.apache.rocketmq.proxy.service.message.MessageService;
import org.apache.rocketmq.proxy.service.message.ReceiptHandleMessage;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.BatchAck;
import org.apache.rocketmq.remoting.protocol.body.BatchAckMessageRequestBody;
import org.apache.rocketmq.remoting.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.header.AckMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ChangeInvisibleTimeRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ChangeInvisibleTimeResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.ConsumerSendMsgBackRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.EndTransactionRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PopMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PopMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;

public class LocalMessageService
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final BrokerController brokerController;
    private final ChannelManager channelManager;

    public LocalMessageService(BrokerController brokerController, ChannelManager channelManager, RPCHook rpcHook) {
        this.brokerController = brokerController;
        this.channelManager = channelManager;
    }

    @Override
    public CompletableFuture<List<SendResult>> sendMessage(ProxyContext ctx, AddressableMessageQueue messageQueue, List<Message> msgList, SendMessageRequestHeader requestHeader, long timeoutMillis) {
        String messageId;
        byte[] body;
        if (msgList.size() > 1) {
            requestHeader.setBatch(Boolean.valueOf(true));
            MessageBatch msgBatch = MessageBatch.generateFromList(msgList);
            MessageClientIDSetter.setUniqID((Message)msgBatch);
            body = msgBatch.encode();
            msgBatch.setBody(body);
            messageId = MessageClientIDSetter.getUniqID((Message)msgBatch);
        } else {
            Message message = msgList.get(0);
            body = message.getBody();
            messageId = MessageClientIDSetter.getUniqID((Message)message);
        }
        LocalRemotingCommand request = LocalRemotingCommand.createRequestCommand(10, (CommandCustomHeader)requestHeader, ctx.getLanguage());
        request.setBody(body);
        CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        SimpleChannel channel = this.channelManager.createInvocationChannel(ctx);
        InvocationContext invocationContext = new InvocationContext(future);
        channel.registerInvocationContext(request.getOpaque(), invocationContext);
        ChannelHandlerContext simpleChannelHandlerContext = channel.getChannelHandlerContext();
        try {
            RemotingCommand response = this.brokerController.getSendMessageProcessor().processRequest(simpleChannelHandlerContext, (RemotingCommand)request);
            if (response != null) {
                invocationContext.handle(response);
                channel.eraseInvocationContext(request.getOpaque());
            }
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            channel.eraseInvocationContext(request.getOpaque());
            log.error("Failed to process sendMessage command", (Throwable)e);
        }
        return future.thenApply(r -> {
            SendStatus sendStatus;
            SendResult sendResult = new SendResult();
            SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)r.readCustomHeader();
            switch (r.getCode()) {
                case 10: {
                    sendStatus = SendStatus.FLUSH_DISK_TIMEOUT;
                    break;
                }
                case 12: {
                    sendStatus = SendStatus.FLUSH_SLAVE_TIMEOUT;
                    break;
                }
                case 11: {
                    sendStatus = SendStatus.SLAVE_NOT_AVAILABLE;
                    break;
                }
                case 0: {
                    sendStatus = SendStatus.SEND_OK;
                    break;
                }
                default: {
                    throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, r.getRemark());
                }
            }
            sendResult.setSendStatus(sendStatus);
            sendResult.setMsgId(messageId);
            sendResult.setMessageQueue(new MessageQueue(requestHeader.getTopic(), this.brokerController.getBrokerConfig().getBrokerName(), requestHeader.getQueueId().intValue()));
            sendResult.setQueueOffset(responseHeader.getQueueOffset().longValue());
            sendResult.setTransactionId(responseHeader.getTransactionId());
            sendResult.setOffsetMsgId(responseHeader.getMsgId());
            return Collections.singletonList(sendResult);
        });
    }

    @Override
    public CompletableFuture<RemotingCommand> sendMessageBack(ProxyContext ctx, ReceiptHandle handle, String messageId, ConsumerSendMsgBackRequestHeader requestHeader, long timeoutMillis) {
        SimpleChannel channel = this.channelManager.createChannel(ctx);
        ChannelHandlerContext channelHandlerContext = channel.getChannelHandlerContext();
        LocalRemotingCommand command = LocalRemotingCommand.createRequestCommand(36, (CommandCustomHeader)requestHeader, ctx.getLanguage());
        CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        try {
            RemotingCommand response = this.brokerController.getSendMessageProcessor().processRequest(channelHandlerContext, (RemotingCommand)command);
            future.complete(response);
        }
        catch (Exception e) {
            log.error("Fail to process sendMessageBack command", (Throwable)e);
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> endTransactionOneway(ProxyContext ctx, String brokerName, EndTransactionRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        SimpleChannel channel = this.channelManager.createChannel(ctx);
        ChannelHandlerContext channelHandlerContext = channel.getChannelHandlerContext();
        LocalRemotingCommand command = LocalRemotingCommand.createRequestCommand(37, (CommandCustomHeader)requestHeader, ctx.getLanguage());
        try {
            this.brokerController.getEndTransactionProcessor().processRequest(channelHandlerContext, (RemotingCommand)command);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<PopResult> popMessage(ProxyContext ctx, AddressableMessageQueue messageQueue, PopMessageRequestHeader requestHeader, long timeoutMillis) {
        requestHeader.setBornTime(System.currentTimeMillis());
        LocalRemotingCommand request = LocalRemotingCommand.createRequestCommand(200050, (CommandCustomHeader)requestHeader, ctx.getLanguage());
        CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        SimpleChannel channel = this.channelManager.createInvocationChannel(ctx);
        InvocationContext invocationContext = new InvocationContext(future);
        channel.registerInvocationContext(request.getOpaque(), invocationContext);
        ChannelHandlerContext simpleChannelHandlerContext = channel.getChannelHandlerContext();
        try {
            RemotingCommand response = this.brokerController.getPopMessageProcessor().processRequest(simpleChannelHandlerContext, (RemotingCommand)request);
            if (response != null) {
                invocationContext.handle(response);
                channel.eraseInvocationContext(request.getOpaque());
            }
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            channel.eraseInvocationContext(request.getOpaque());
            log.error("Failed to process popMessage command", (Throwable)e);
        }
        return future.thenApply(r -> {
            PopStatus popStatus;
            List messageExtList = new ArrayList();
            switch (r.getCode()) {
                case 0: {
                    popStatus = PopStatus.FOUND;
                    ByteBuffer byteBuffer = ByteBuffer.wrap(r.getBody());
                    messageExtList = MessageDecoder.decodesBatch((ByteBuffer)byteBuffer, (boolean)true, (boolean)false, (boolean)true);
                    break;
                }
                case 209: {
                    popStatus = PopStatus.POLLING_FULL;
                    break;
                }
                case 19: 
                case 210: {
                    popStatus = PopStatus.POLLING_NOT_FOUND;
                    break;
                }
                default: {
                    throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, r.getRemark());
                }
            }
            PopResult popResult = new PopResult(popStatus, messageExtList);
            PopMessageResponseHeader responseHeader = (PopMessageResponseHeader)r.readCustomHeader();
            if (popStatus == PopStatus.FOUND) {
                popResult.setInvisibleTime(responseHeader.getInvisibleTime());
                popResult.setPopTime(responseHeader.getPopTime());
                Map startOffsetInfo = ExtraInfoUtil.parseStartOffsetInfo((String)responseHeader.getStartOffsetInfo());
                Map msgOffsetInfo = ExtraInfoUtil.parseMsgOffsetInfo((String)responseHeader.getMsgOffsetInfo());
                Map orderCountInfo = ExtraInfoUtil.parseOrderCountInfo((String)responseHeader.getOrderCountInfo());
                HashMap sortMap = new HashMap(16);
                for (MessageExt messageExt : messageExtList) {
                    String key = ExtraInfoUtil.getStartOffsetInfoMapKey((String)messageExt.getTopic(), (String)messageExt.getProperty("POP_CK"), (long)messageExt.getQueueId());
                    if (!sortMap.containsKey(key)) {
                        sortMap.put(key, new ArrayList(4));
                    }
                    ((List)sortMap.get(key)).add(messageExt.getQueueOffset());
                }
                HashMap<String, String> map = new HashMap<String, String>(5);
                for (MessageExt messageExt : messageExtList) {
                    String key;
                    if (startOffsetInfo == null) {
                        key = messageExt.getTopic() + messageExt.getQueueId();
                        if (!map.containsKey(messageExt.getTopic() + messageExt.getQueueId())) {
                            map.put(key, ExtraInfoUtil.buildExtraInfo((long)messageExt.getQueueOffset(), (long)responseHeader.getPopTime(), (long)responseHeader.getInvisibleTime(), (int)responseHeader.getReviveQid(), (String)messageExt.getTopic(), (String)messageQueue.getBrokerName(), (int)messageExt.getQueueId()));
                        }
                        messageExt.getProperties().put("POP_CK", (String)map.get(key) + " " + messageExt.getQueueOffset());
                    } else if (messageExt.getProperty("POP_CK") == null) {
                        Integer count;
                        key = ExtraInfoUtil.getStartOffsetInfoMapKey((String)messageExt.getTopic(), (long)messageExt.getQueueId());
                        int index = ((List)sortMap.get(key)).indexOf(messageExt.getQueueOffset());
                        Long msgQueueOffset = (Long)((List)msgOffsetInfo.get(key)).get(index);
                        if (msgQueueOffset.longValue() != messageExt.getQueueOffset()) {
                            log.warn("Queue offset [{}] of msg is strange, not equal to the stored in msg, {}", (Object)msgQueueOffset, (Object)messageExt);
                        }
                        messageExt.getProperties().put("POP_CK", ExtraInfoUtil.buildExtraInfo((long)((Long)startOffsetInfo.get(key)), (long)responseHeader.getPopTime(), (long)responseHeader.getInvisibleTime(), (int)responseHeader.getReviveQid(), (String)messageExt.getTopic(), (String)messageQueue.getBrokerName(), (int)messageExt.getQueueId(), (long)msgQueueOffset));
                        if (requestHeader.isOrder() && orderCountInfo != null && (count = (Integer)orderCountInfo.get(key)) != null && count > 0) {
                            messageExt.setReconsumeTimes(count.intValue());
                        }
                    }
                    messageExt.getProperties().computeIfAbsent("1ST_POP_TIME", k -> String.valueOf(responseHeader.getPopTime()));
                    messageExt.setBrokerName(messageExt.getBrokerName());
                    messageExt.setTopic(messageQueue.getTopic());
                }
            }
            return popResult;
        });
    }

    @Override
    public CompletableFuture<AckResult> changeInvisibleTime(ProxyContext ctx, ReceiptHandle handle, String messageId, ChangeInvisibleTimeRequestHeader requestHeader, long timeoutMillis) {
        SimpleChannel channel = this.channelManager.createChannel(ctx);
        ChannelHandlerContext channelHandlerContext = channel.getChannelHandlerContext();
        LocalRemotingCommand command = LocalRemotingCommand.createRequestCommand(200053, (CommandCustomHeader)requestHeader, ctx.getLanguage());
        CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        try {
            RemotingCommand response = this.brokerController.getChangeInvisibleTimeProcessor().processRequest(channelHandlerContext, (RemotingCommand)command);
            future.complete(response);
        }
        catch (Exception e) {
            log.error("Fail to process changeInvisibleTime command", (Throwable)e);
            future.completeExceptionally(e);
        }
        return future.thenApply(r -> {
            ChangeInvisibleTimeResponseHeader responseHeader = (ChangeInvisibleTimeResponseHeader)r.readCustomHeader();
            AckResult ackResult = new AckResult();
            if (0 == r.getCode()) {
                ackResult.setStatus(AckStatus.OK);
            } else {
                ackResult.setStatus(AckStatus.NO_EXIST);
            }
            ackResult.setPopTime(responseHeader.getPopTime());
            ackResult.setExtraInfo(ReceiptHandle.builder().startOffset(handle.getStartOffset()).retrieveTime(responseHeader.getPopTime()).invisibleTime(responseHeader.getInvisibleTime()).reviveQueueId(responseHeader.getReviveQid()).topicType(handle.getTopicType()).brokerName(handle.getBrokerName()).queueId(handle.getQueueId()).offset(handle.getOffset()).build().encode());
            return ackResult;
        });
    }

    @Override
    public CompletableFuture<AckResult> ackMessage(ProxyContext ctx, ReceiptHandle handle, String messageId, AckMessageRequestHeader requestHeader, long timeoutMillis) {
        SimpleChannel channel = this.channelManager.createChannel(ctx);
        ChannelHandlerContext channelHandlerContext = channel.getChannelHandlerContext();
        LocalRemotingCommand command = LocalRemotingCommand.createRequestCommand(200051, (CommandCustomHeader)requestHeader, ctx.getLanguage());
        CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        try {
            RemotingCommand response = this.brokerController.getAckMessageProcessor().processRequest(channelHandlerContext, (RemotingCommand)command);
            future.complete(response);
        }
        catch (Exception e) {
            log.error("Fail to process ackMessage command", (Throwable)e);
            future.completeExceptionally(e);
        }
        return future.thenApply(r -> {
            AckResult ackResult = new AckResult();
            if (0 == r.getCode()) {
                ackResult.setStatus(AckStatus.OK);
            } else {
                ackResult.setStatus(AckStatus.NO_EXIST);
            }
            return ackResult;
        });
    }

    @Override
    public CompletableFuture<AckResult> batchAckMessage(ProxyContext ctx, List<ReceiptHandleMessage> handleList, String consumerGroup, String topic, long timeoutMillis) {
        SimpleChannel channel = this.channelManager.createChannel(ctx);
        ChannelHandlerContext channelHandlerContext = channel.getChannelHandlerContext();
        RemotingCommand command = LocalRemotingCommand.createRequestCommand((int)200151, null);
        HashMap<String, BatchAck> batchAckMap = new HashMap<String, BatchAck>();
        for (ReceiptHandleMessage receiptHandleMessage : handleList) {
            String extraInfo = receiptHandleMessage.getReceiptHandle().getReceiptHandle();
            String[] extraInfoData = ExtraInfoUtil.split((String)extraInfo);
            String mergeKey = ExtraInfoUtil.getRetry((String[])extraInfoData) + "@" + ExtraInfoUtil.getQueueId((String[])extraInfoData) + "@" + ExtraInfoUtil.getCkQueueOffset((String[])extraInfoData) + "@" + ExtraInfoUtil.getPopTime((String[])extraInfoData);
            BatchAck bAck = batchAckMap.computeIfAbsent(mergeKey, k -> {
                BatchAck newBatchAck = new BatchAck();
                newBatchAck.setConsumerGroup(consumerGroup);
                newBatchAck.setTopic(topic);
                newBatchAck.setRetry(ExtraInfoUtil.getRetry((String[])extraInfoData));
                newBatchAck.setStartOffset(ExtraInfoUtil.getCkQueueOffset((String[])extraInfoData).longValue());
                newBatchAck.setQueueId(ExtraInfoUtil.getQueueId((String[])extraInfoData));
                newBatchAck.setReviveQueueId(ExtraInfoUtil.getReviveQid((String[])extraInfoData));
                newBatchAck.setPopTime(ExtraInfoUtil.getPopTime((String[])extraInfoData).longValue());
                newBatchAck.setInvisibleTime(ExtraInfoUtil.getInvisibleTime((String[])extraInfoData).longValue());
                newBatchAck.setBitSet(new BitSet());
                return newBatchAck;
            });
            bAck.getBitSet().set((int)(ExtraInfoUtil.getQueueOffset((String[])extraInfoData) - ExtraInfoUtil.getCkQueueOffset((String[])extraInfoData)));
        }
        BatchAckMessageRequestBody requestBody = new BatchAckMessageRequestBody();
        requestBody.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
        requestBody.setAcks(new ArrayList(batchAckMap.values()));
        command.setBody(requestBody.encode());
        CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        try {
            RemotingCommand response = this.brokerController.getAckMessageProcessor().processRequest(channelHandlerContext, command);
            future.complete(response);
        }
        catch (Exception e) {
            log.error("Fail to process batchAckMessage command", (Throwable)e);
            future.completeExceptionally(e);
        }
        return future.thenApply(r -> {
            AckResult ackResult = new AckResult();
            if (0 == r.getCode()) {
                ackResult.setStatus(AckStatus.OK);
            } else {
                ackResult.setStatus(AckStatus.NO_EXIST);
            }
            return ackResult;
        });
    }

    @Override
    public CompletableFuture<PullResult> pullMessage(ProxyContext ctx, AddressableMessageQueue messageQueue, PullMessageRequestHeader requestHeader, long timeoutMillis) {
        throw new NotImplementedException("pullMessage is not implemented in LocalMessageService");
    }

    @Override
    public CompletableFuture<Long> queryConsumerOffset(ProxyContext ctx, AddressableMessageQueue messageQueue, QueryConsumerOffsetRequestHeader requestHeader, long timeoutMillis) {
        throw new NotImplementedException("queryConsumerOffset is not implemented in LocalMessageService");
    }

    @Override
    public CompletableFuture<Void> updateConsumerOffset(ProxyContext ctx, AddressableMessageQueue messageQueue, UpdateConsumerOffsetRequestHeader requestHeader, long timeoutMillis) {
        throw new NotImplementedException("updateConsumerOffset is not implemented in LocalMessageService");
    }

    @Override
    public CompletableFuture<Set<MessageQueue>> lockBatchMQ(ProxyContext ctx, AddressableMessageQueue messageQueue, LockBatchRequestBody requestBody, long timeoutMillis) {
        throw new NotImplementedException("lockBatchMQ is not implemented in LocalMessageService");
    }

    @Override
    public CompletableFuture<Void> unlockBatchMQ(ProxyContext ctx, AddressableMessageQueue messageQueue, UnlockBatchRequestBody requestBody, long timeoutMillis) {
        throw new NotImplementedException("unlockBatchMQ is not implemented in LocalMessageService");
    }

    @Override
    public CompletableFuture<Long> getMaxOffset(ProxyContext ctx, AddressableMessageQueue messageQueue, GetMaxOffsetRequestHeader requestHeader, long timeoutMillis) {
        throw new NotImplementedException("getMaxOffset is not implemented in LocalMessageService");
    }

    @Override
    public CompletableFuture<Long> getMinOffset(ProxyContext ctx, AddressableMessageQueue messageQueue, GetMinOffsetRequestHeader requestHeader, long timeoutMillis) {
        throw new NotImplementedException("getMinOffset is not implemented in LocalMessageService");
    }

    @Override
    public CompletableFuture<RemotingCommand> request(ProxyContext ctx, String brokerName, RemotingCommand request, long timeoutMillis) {
        throw new NotImplementedException("request is not implemented in LocalMessageService");
    }

    @Override
    public CompletableFuture<Void> requestOneway(ProxyContext ctx, String brokerName, RemotingCommand request, long timeoutMillis) {
        throw new NotImplementedException("requestOneway is not implemented in LocalMessageService");
    }
}

