/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.pop;

import com.alibaba.fastjson.JSON;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.pop.PopConsumerCache;
import org.apache.rocketmq.broker.pop.PopConsumerContext;
import org.apache.rocketmq.broker.pop.PopConsumerKVStore;
import org.apache.rocketmq.broker.pop.PopConsumerLockService;
import org.apache.rocketmq.broker.pop.PopConsumerRecord;
import org.apache.rocketmq.broker.pop.PopConsumerRocksdbStore;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.pop.PopCheckPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopConsumerService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqPop");
    private static final long OFFSET_NOT_EXIST = -1L;
    private static final String ROCKSDB_DIRECTORY = "kvStore";
    private static final int[] REWRITE_INTERVALS_IN_SECONDS = new int[]{10, 30, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 1200, 1800, 3600, 7200};
    private final AtomicBoolean consumerRunning;
    private final BrokerConfig brokerConfig;
    private final BrokerController brokerController;
    private final AtomicLong currentTime;
    private final AtomicLong lastCleanupLockTime;
    private final PopConsumerCache popConsumerCache;
    private final PopConsumerKVStore popConsumerStore;
    private final PopConsumerLockService consumerLockService;
    private final ConcurrentMap<String, AtomicLong> requestCountTable;

    public PopConsumerService(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.brokerConfig = brokerController.getBrokerConfig();
        this.consumerRunning = new AtomicBoolean(false);
        this.requestCountTable = new ConcurrentHashMap<String, AtomicLong>();
        this.currentTime = new AtomicLong(TimeUnit.SECONDS.toMillis(3L));
        this.lastCleanupLockTime = new AtomicLong(System.currentTimeMillis());
        this.consumerLockService = new PopConsumerLockService(TimeUnit.MINUTES.toMillis(2L));
        this.popConsumerStore = new PopConsumerRocksdbStore(Paths.get(brokerController.getMessageStoreConfig().getStorePathRootDir(), ROCKSDB_DIRECTORY).toString());
        this.popConsumerCache = this.brokerConfig.isEnablePopBufferMerge() ? new PopConsumerCache(brokerController, this.popConsumerStore, this.consumerLockService, this::revive) : null;
        log.info("PopConsumerService init, buffer={}, rocksdb filePath={}", (Object)this.brokerConfig.isEnablePopBufferMerge(), (Object)this.popConsumerStore.getFilePath());
    }

    public boolean isPopShouldStop(String group, String topic, int queueId) {
        return this.brokerConfig.isEnablePopMessageThreshold() && this.popConsumerCache != null && this.popConsumerCache.getPopInFlightMessageCount(group, topic, queueId) >= this.brokerConfig.getPopInflightMessageThreshold();
    }

    public long getPendingFilterCount(String groupId, String topicId, int queueId) {
        try {
            long maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topicId, queueId);
            long consumeOffset = this.brokerController.getConsumerOffsetManager().queryOffset(groupId, topicId, queueId);
            return maxOffset - consumeOffset;
        }
        catch (ConsumeQueueException e) {
            throw new RuntimeException(e);
        }
    }

    public GetMessageResult recodeRetryMessage(GetMessageResult getMessageResult, String topicId, long offset, long popTime, long invisibleTime) {
        if (getMessageResult.getMessageCount() == 0 || getMessageResult.getMessageMapedList().isEmpty()) {
            return getMessageResult;
        }
        GetMessageResult result = new GetMessageResult(getMessageResult.getMessageCount());
        result.setStatus(GetMessageStatus.FOUND);
        String brokerName = this.brokerConfig.getBrokerName();
        for (SelectMappedBufferResult bufferResult : getMessageResult.getMessageMapedList()) {
            List messageExtList = MessageDecoder.decodesBatch((ByteBuffer)bufferResult.getByteBuffer(), (boolean)true, (boolean)false, (boolean)true);
            bufferResult.release();
            for (MessageExt messageExt : messageExtList) {
                try {
                    String ckInfo = ExtraInfoUtil.buildExtraInfo((long)offset, (long)popTime, (long)invisibleTime, (int)0, (String)messageExt.getTopic(), (String)brokerName, (int)messageExt.getQueueId(), (long)messageExt.getQueueOffset());
                    messageExt.getProperties().putIfAbsent("POP_CK", ckInfo);
                    messageExt.setTopic(topicId);
                    messageExt.setStoreSize(0);
                    byte[] encode = MessageDecoder.encode((MessageExt)messageExt, (boolean)false);
                    ByteBuffer buffer = ByteBuffer.wrap(encode);
                    SelectMappedBufferResult tmpResult = new SelectMappedBufferResult(bufferResult.getStartOffset(), buffer, encode.length, null);
                    result.addMessage(tmpResult);
                }
                catch (Exception e) {
                    log.error("PopConsumerService exception in recode retry message, topic={}", (Object)topicId, (Object)e);
                }
            }
        }
        return result;
    }

    public PopConsumerContext addGetMessageResult(PopConsumerContext context, GetMessageResult result, String topicId, int queueId, PopConsumerRecord.RetryType retryType, long offset) {
        if (result.getStatus() == GetMessageStatus.FOUND && !result.getMessageQueueOffset().isEmpty()) {
            if (context.isFifo()) {
                this.setFifoBlocked(context, context.getGroupId(), topicId, queueId, result.getMessageQueueOffset());
            }
            context.addGetMessageResult(result, topicId, queueId, retryType, offset);
            if (this.brokerConfig.isPopConsumerKVServiceLog()) {
                log.info("PopConsumerService pop, time={}, invisible={}, groupId={}, topic={}, queueId={}, offset={}, attemptId={}", new Object[]{context.getPopTime(), context.getInvisibleTime(), context.getGroupId(), topicId, queueId, result.getMessageQueueOffset(), context.getAttemptId()});
            }
        }
        if (!context.isFifo() && result.getNextBeginOffset() > -1L) {
            long minOffset;
            long commitOffset;
            this.brokerController.getConsumerOffsetManager().commitPullOffset(context.getClientHost(), context.getGroupId(), topicId, queueId, result.getNextBeginOffset());
            long l = commitOffset = result.getStatus() == GetMessageStatus.FOUND ? offset : result.getNextBeginOffset();
            if (this.brokerConfig.isEnablePopBufferMerge() && this.popConsumerCache != null && (minOffset = this.popConsumerCache.getMinOffsetInCache(context.getGroupId(), topicId, queueId)) != -1L) {
                commitOffset = minOffset;
            }
            this.brokerController.getConsumerOffsetManager().commitOffset(context.getClientHost(), context.getGroupId(), topicId, queueId, commitOffset);
        }
        return context;
    }

    public Long getPopOffset(String groupId, String topicId, int queueId) {
        Long resetOffset = this.brokerController.getConsumerOffsetManager().queryThenEraseResetOffset(topicId, groupId, queueId);
        if (resetOffset != null) {
            this.clearCache(groupId, topicId, queueId);
            this.brokerController.getConsumerOrderInfoManager().clearBlock(topicId, groupId, queueId);
            this.brokerController.getConsumerOffsetManager().commitOffset("ResetPopOffset", groupId, topicId, queueId, resetOffset);
        }
        return resetOffset;
    }

    public CompletableFuture<GetMessageResult> getMessageAsync(String clientHost, String groupId, String topicId, int queueId, long offset, int batchSize, MessageFilter filter) {
        log.debug("PopConsumerService getMessageAsync, groupId={}, topicId={}, queueId={}, offset={}, batchSize={}, filter={}", new Object[]{groupId, topicId, offset, queueId, batchSize, filter != null});
        Long resetOffset = this.getPopOffset(groupId, topicId, queueId);
        long currentOffset = resetOffset != null ? resetOffset : offset;
        CompletableFuture getMessageFuture = this.brokerController.getMessageStore().getMessageAsync(groupId, topicId, queueId, offset, batchSize, filter);
        return ((CompletableFuture)getMessageFuture.thenCompose(result -> {
            if (result == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (GetMessageStatus.OFFSET_TOO_SMALL.equals((Object)result.getStatus()) || GetMessageStatus.OFFSET_OVERFLOW_BADLY.equals((Object)result.getStatus()) || GetMessageStatus.OFFSET_FOUND_NULL.equals((Object)result.getStatus())) {
                this.brokerController.getConsumerOffsetManager().commitOffset(clientHost, groupId, topicId, queueId, result.getNextBeginOffset());
                log.warn("PopConsumerService getMessageAsync, initial offset because store is no correct, groupId={}, topicId={}, queueId={}, batchSize={}, offset={}->{}", new Object[]{groupId, topicId, queueId, batchSize, currentOffset, result.getNextBeginOffset()});
                return this.brokerController.getMessageStore().getMessageAsync(groupId, topicId, queueId, result.getNextBeginOffset(), batchSize, filter);
            }
            return CompletableFuture.completedFuture(result);
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                log.error("Pop getMessageAsync error", throwable);
            }
        });
    }

    public void setFifoBlocked(PopConsumerContext context, String groupId, String topicId, int queueId, List<Long> queueOffsetList) {
        this.brokerController.getConsumerOrderInfoManager().update(context.getAttemptId(), false, topicId, groupId, queueId, context.getPopTime(), context.getInvisibleTime(), queueOffsetList, context.getOrderCountInfoBuilder());
    }

    public boolean isFifoBlocked(PopConsumerContext context, String groupId, String topicId, int queueId) {
        return this.brokerController.getConsumerOrderInfoManager().checkBlock(context.getAttemptId(), topicId, groupId, queueId, context.getInvisibleTime());
    }

    protected CompletableFuture<PopConsumerContext> getMessageAsync(CompletableFuture<PopConsumerContext> future, String clientHost, String groupId, String topicId, int queueId, int batchSize, MessageFilter filter, PopConsumerRecord.RetryType retryType) {
        return future.thenCompose(result -> {
            if (this.isPopShouldStop(groupId, topicId, queueId)) {
                return CompletableFuture.completedFuture(result);
            }
            if (result.isFifo() && this.isFifoBlocked((PopConsumerContext)result, groupId, topicId, queueId)) {
                return CompletableFuture.completedFuture(result);
            }
            int remain = batchSize - result.getMessageCount();
            if (remain <= 0) {
                result.addRestCount(this.getPendingFilterCount(groupId, topicId, queueId));
                return CompletableFuture.completedFuture(result);
            }
            long consumeOffset = this.brokerController.getConsumerOffsetManager().queryPullOffset(groupId, topicId, queueId);
            return this.getMessageAsync(clientHost, groupId, topicId, queueId, consumeOffset, remain, filter).thenApply(getMessageResult -> this.addGetMessageResult((PopConsumerContext)result, (GetMessageResult)getMessageResult, topicId, queueId, retryType, consumeOffset));
        });
    }

    public CompletableFuture<PopConsumerContext> popAsync(String clientHost, long popTime, long invisibleTime, String groupId, String topicId, int queueId, int batchSize, boolean fifo, String attemptId, MessageFilter filter) {
        PopConsumerContext popConsumerContext = new PopConsumerContext(clientHost, popTime, invisibleTime, groupId, fifo, attemptId);
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topicId);
        if (topicConfig == null || !this.consumerLockService.tryLock(groupId, topicId)) {
            return CompletableFuture.completedFuture(popConsumerContext);
        }
        log.debug("PopConsumerService popAsync, groupId={}, topicId={}, queueId={}, batchSize={}, invisibleTime={}, fifo={}, attemptId={}, filter={}", new Object[]{groupId, topicId, queueId, batchSize, invisibleTime, fifo, attemptId, filter});
        String requestKey = groupId + "@" + topicId;
        String retryTopicV1 = KeyBuilder.buildPopRetryTopicV1((String)topicId, (String)groupId);
        String retryTopicV2 = KeyBuilder.buildPopRetryTopicV2((String)topicId, (String)groupId);
        long requestCount = ((AtomicLong)Objects.requireNonNull(ConcurrentHashMapUtils.computeIfAbsent(this.requestCountTable, (Object)requestKey, k -> new AtomicLong(0L)))).getAndIncrement();
        boolean preferRetry = requestCount % 5L == 0L;
        CompletableFuture<PopConsumerContext> getMessageFuture = CompletableFuture.completedFuture(popConsumerContext);
        try {
            if (!fifo && preferRetry) {
                if (this.brokerConfig.isRetrieveMessageFromPopRetryTopicV1()) {
                    getMessageFuture = this.getMessageAsync(getMessageFuture, clientHost, groupId, retryTopicV1, 0, batchSize, filter, PopConsumerRecord.RetryType.RETRY_TOPIC_V1);
                }
                if (this.brokerConfig.isEnableRetryTopicV2()) {
                    getMessageFuture = this.getMessageAsync(getMessageFuture, clientHost, groupId, retryTopicV2, 0, batchSize, filter, PopConsumerRecord.RetryType.RETRY_TOPIC_V2);
                }
            }
            if (queueId != -1) {
                getMessageFuture = this.getMessageAsync(getMessageFuture, clientHost, groupId, topicId, queueId, batchSize, filter, PopConsumerRecord.RetryType.NORMAL_TOPIC);
            } else {
                for (int i = 0; i < topicConfig.getReadQueueNums(); ++i) {
                    int current = (int)((requestCount + (long)i) % (long)topicConfig.getReadQueueNums());
                    getMessageFuture = this.getMessageAsync(getMessageFuture, clientHost, groupId, topicId, current, batchSize, filter, PopConsumerRecord.RetryType.NORMAL_TOPIC);
                }
                if (!fifo && !preferRetry) {
                    if (this.brokerConfig.isRetrieveMessageFromPopRetryTopicV1()) {
                        getMessageFuture = this.getMessageAsync(getMessageFuture, clientHost, groupId, retryTopicV1, 0, batchSize, filter, PopConsumerRecord.RetryType.RETRY_TOPIC_V1);
                    }
                    if (this.brokerConfig.isEnableRetryTopicV2()) {
                        getMessageFuture = this.getMessageAsync(getMessageFuture, clientHost, groupId, retryTopicV2, 0, batchSize, filter, PopConsumerRecord.RetryType.RETRY_TOPIC_V2);
                    }
                }
            }
            return ((CompletableFuture)getMessageFuture.thenCompose(result -> {
                if (result.isFound() && !result.isFifo()) {
                    if (this.brokerConfig.isEnablePopBufferMerge() && this.popConsumerCache != null && !this.popConsumerCache.isCacheFull()) {
                        this.popConsumerCache.writeRecords(result.getPopConsumerRecordList());
                    } else {
                        this.popConsumerStore.writeRecords(result.getPopConsumerRecordList());
                    }
                    for (int i = 0; i < result.getGetMessageResultList().size(); ++i) {
                        GetMessageResult getMessageResult = result.getGetMessageResultList().get(i);
                        PopConsumerRecord popConsumerRecord = result.getPopConsumerRecordList().get(i);
                        boolean recode = this.brokerConfig.isPopResponseReturnActualRetryTopic();
                        if (!recode || !popConsumerRecord.isRetry()) continue;
                        result.getGetMessageResultList().set(i, this.recodeRetryMessage(getMessageResult, popConsumerRecord.getTopicId(), popConsumerRecord.getQueueId(), result.getPopTime(), invisibleTime));
                    }
                }
                return CompletableFuture.completedFuture(result);
            })).whenComplete((result, throwable) -> {
                try {
                    if (throwable != null) {
                        log.error("PopConsumerService popAsync get message error", throwable instanceof CompletionException ? throwable.getCause() : throwable);
                    }
                    if (result.getMessageCount() > 0) {
                        log.debug("PopConsumerService popAsync result, found={}, groupId={}, topicId={}, queueId={}, batchSize={}, invisibleTime={}, fifo={}, attemptId={}, filter={}", new Object[]{result.getMessageCount(), groupId, topicId, queueId, batchSize, invisibleTime, fifo, attemptId, filter});
                    }
                }
                finally {
                    this.consumerLockService.unlock(groupId, topicId);
                }
            });
        }
        catch (Throwable t) {
            log.error("PopConsumerService popAsync error", t);
            return getMessageFuture;
        }
    }

    public CompletableFuture<Boolean> ackAsync(long popTime, long invisibleTime, String groupId, String topicId, int queueId, long offset) {
        if (this.brokerConfig.isPopConsumerKVServiceLog()) {
            log.info("PopConsumerService ack, time={}, invisible={}, groupId={}, topic={}, queueId={}, offset={}", new Object[]{popTime, invisibleTime, groupId, topicId, queueId, offset});
        }
        PopConsumerRecord record = new PopConsumerRecord(popTime, groupId, topicId, queueId, 0, invisibleTime, offset, null);
        if (this.brokerConfig.isEnablePopBufferMerge() && this.popConsumerCache != null && this.popConsumerCache.deleteRecords(Collections.singletonList(record)).isEmpty()) {
            return CompletableFuture.completedFuture(true);
        }
        this.popConsumerStore.deleteRecords(Collections.singletonList(record));
        return CompletableFuture.completedFuture(true);
    }

    public void changeInvisibilityDuration(long popTime, long invisibleTime, long changedPopTime, long changedInvisibleTime, String groupId, String topicId, int queueId, long offset) {
        if (this.brokerConfig.isPopConsumerKVServiceLog()) {
            log.info("PopConsumerService change, time={}, invisible={}, groupId={}, topic={}, queueId={}, offset={}, new time={}, new invisible={}", new Object[]{popTime, invisibleTime, groupId, topicId, queueId, offset, changedPopTime, changedInvisibleTime});
        }
        PopConsumerRecord ckRecord = new PopConsumerRecord(changedPopTime, groupId, topicId, queueId, 0, changedInvisibleTime, offset, null);
        PopConsumerRecord ackRecord = new PopConsumerRecord(popTime, groupId, topicId, queueId, 0, invisibleTime, offset, null);
        this.popConsumerStore.writeRecords(Collections.singletonList(ckRecord));
        if (this.brokerConfig.isEnablePopBufferMerge() && this.popConsumerCache != null && this.popConsumerCache.deleteRecords(Collections.singletonList(ackRecord)).isEmpty()) {
            return;
        }
        this.popConsumerStore.deleteRecords(Collections.singletonList(ackRecord));
    }

    public CompletableFuture<Triple<MessageExt, String, Boolean>> getMessageAsync(PopConsumerRecord consumerRecord) {
        return this.brokerController.getEscapeBridge().getMessageAsync(consumerRecord.getTopicId(), consumerRecord.getOffset(), consumerRecord.getQueueId(), this.brokerConfig.getBrokerName(), false);
    }

    public CompletableFuture<Boolean> revive(PopConsumerRecord record) {
        return this.getMessageAsync(record).thenCompose(result -> {
            if (result == null) {
                log.error("PopConsumerService revive error, message may be lost, record={}", (Object)record);
                return CompletableFuture.completedFuture(false);
            }
            if (result.getLeft() == null) {
                log.info("PopConsumerService revive no need retry, record={}", (Object)record);
                return CompletableFuture.completedFuture((Boolean)result.getRight() == false);
            }
            return CompletableFuture.completedFuture(this.reviveRetry(record, (MessageExt)result.getLeft()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String groupId, String topicId, int queueId) {
        while (this.consumerLockService.tryLock(groupId, topicId)) {
        }
        try {
            if (this.popConsumerCache != null) {
                this.popConsumerCache.removeRecords(groupId, topicId, queueId);
            }
        }
        finally {
            this.consumerLockService.unlock(groupId, topicId);
        }
    }

    public long revive(AtomicLong currentTime, int maxCount) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long upperTime = System.currentTimeMillis() - 50L;
        List<PopConsumerRecord> consumerRecords = this.popConsumerStore.scanExpiredRecords(currentTime.get() - TimeUnit.SECONDS.toMillis(3L), upperTime, maxCount);
        long scanCostTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        LinkedBlockingQueue failureList = new LinkedBlockingQueue();
        ArrayList<CompletionStage> futureList = new ArrayList<CompletionStage>(consumerRecords.size());
        for (PopConsumerRecord record : consumerRecords) {
            futureList.add(this.revive(record).thenAccept(result -> {
                if (!result.booleanValue()) {
                    if (record.getAttemptTimes() < this.brokerConfig.getPopReviveMaxAttemptTimes()) {
                        long backoffInterval = 1000L * (long)REWRITE_INTERVALS_IN_SECONDS[Math.min(REWRITE_INTERVALS_IN_SECONDS.length, record.getAttemptTimes())];
                        long nextInvisibleTime = record.getInvisibleTime() + backoffInterval;
                        PopConsumerRecord retryRecord = new PopConsumerRecord(System.currentTimeMillis(), record.getGroupId(), record.getTopicId(), record.getQueueId(), record.getRetryFlag(), nextInvisibleTime, record.getOffset(), record.getAttemptId());
                        retryRecord.setAttemptTimes(record.getAttemptTimes() + 1);
                        failureList.add(retryRecord);
                        log.warn("PopConsumerService revive backoff retry, record={}", (Object)retryRecord);
                    } else {
                        log.error("PopConsumerService drop record, message may be lost, record={}", (Object)record);
                    }
                }
            }));
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
        this.popConsumerStore.writeRecords(new ArrayList<PopConsumerRecord>(failureList));
        this.popConsumerStore.deleteRecords(consumerRecords);
        currentTime.set(consumerRecords.isEmpty() ? upperTime : consumerRecords.get(consumerRecords.size() - 1).getVisibilityTimeout());
        if (this.brokerConfig.isEnablePopBufferMerge()) {
            log.info("PopConsumerService, key size={}, cache size={}, revive count={}, failure count={}, behindInMillis={}, scanInMillis={}, costInMillis={}", new Object[]{this.popConsumerCache.getCacheKeySize(), this.popConsumerCache.getCacheSize(), consumerRecords.size(), failureList.size(), upperTime - currentTime.get(), scanCostTime, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        } else {
            log.info("PopConsumerService, revive count={}, failure count={}, behindInMillis={}, scanInMillis={}, costInMillis={}", new Object[]{consumerRecords.size(), failureList.size(), upperTime - currentTime.get(), scanCostTime, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        }
        return consumerRecords.size();
    }

    public void createRetryTopicIfNeeded(String groupId, String topicId) {
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topicId);
        if (topicConfig != null) {
            return;
        }
        topicConfig = new TopicConfig(topicId, 1, 1, 6, 0);
        topicConfig.setTopicFilterType(TopicFilterType.SINGLE_TAG);
        this.brokerController.getTopicConfigManager().updateTopicConfig(topicConfig);
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(groupId, topicId, 0);
        if (offset < 0L) {
            this.brokerController.getConsumerOffsetManager().commitOffset("InitPopOffset", groupId, topicId, 0, 0L);
        }
    }

    public boolean reviveRetry(PopConsumerRecord record, MessageExt messageExt) {
        boolean retry;
        if (this.brokerConfig.isPopConsumerKVServiceLog()) {
            log.info("PopConsumerService revive, time={}, invisible={}, groupId={}, topic={}, queueId={}, offset={}", new Object[]{record.getPopTime(), record.getInvisibleTime(), record.getGroupId(), record.getTopicId(), record.getQueueId(), record.getOffset()});
        }
        String retryTopic = (retry = StringUtils.startsWith((CharSequence)record.getTopicId(), (CharSequence)"%RETRY%")) ? record.getTopicId() : KeyBuilder.buildPopRetryTopic((String)record.getTopicId(), (String)record.getGroupId(), (boolean)this.brokerConfig.isEnableRetryTopicV2());
        this.createRetryTopicIfNeeded(record.getGroupId(), retryTopic);
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(retryTopic);
        msgInner.setBody(messageExt.getBody() != null ? messageExt.getBody() : new byte[]{});
        msgInner.setQueueId(0);
        if (messageExt.getTags() != null) {
            msgInner.setTags(messageExt.getTags());
        } else {
            MessageAccessor.setProperties((Message)msgInner, new HashMap());
        }
        msgInner.setBornTimestamp(messageExt.getBornTimestamp());
        msgInner.setFlag(messageExt.getFlag());
        msgInner.setSysFlag(messageExt.getSysFlag());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setReconsumeTimes(messageExt.getReconsumeTimes() + 1);
        msgInner.getProperties().putAll(messageExt.getProperties());
        if (messageExt.getReconsumeTimes() == 0 || msgInner.getProperties().get("1ST_POP_TIME") == null) {
            msgInner.getProperties().put("1ST_POP_TIME", String.valueOf(record.getPopTime()));
        }
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        PutMessageResult putMessageResult = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
        if (putMessageResult.getAppendMessageResult() == null || putMessageResult.getAppendMessageResult().getStatus() != AppendMessageStatus.PUT_OK) {
            log.error("PopConsumerService revive retry msg error, put status={}, ck={}, delay={}ms", new Object[]{putMessageResult, JSON.toJSONString((Object)record), System.currentTimeMillis() - record.getVisibilityTimeout()});
            return false;
        }
        if (this.brokerController.getBrokerStatsManager() != null) {
            this.brokerController.getBrokerStatsManager().incBrokerPutNums(msgInner.getTopic(), 1);
            this.brokerController.getBrokerStatsManager().incTopicPutNums(msgInner.getTopic());
            this.brokerController.getBrokerStatsManager().incTopicPutSize(msgInner.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
        }
        return true;
    }

    public synchronized void transferToFsStore() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (true) {
            try {
                List<PopConsumerRecord> consumerRecords;
                while ((consumerRecords = this.popConsumerStore.scanExpiredRecords(0L, Long.MAX_VALUE, this.brokerConfig.getPopReviveMaxReturnSizePerRead())) != null && !consumerRecords.isEmpty()) {
                    for (PopConsumerRecord record : consumerRecords) {
                        PopCheckPoint ck = new PopCheckPoint();
                        ck.setBitMap(0);
                        ck.setNum((byte)1);
                        ck.setPopTime(record.getPopTime());
                        ck.setInvisibleTime(record.getInvisibleTime());
                        ck.setStartOffset(record.getOffset());
                        ck.setCId(record.getGroupId());
                        ck.setTopic(record.getTopicId());
                        ck.setQueueId(record.getQueueId());
                        ck.setBrokerName(this.brokerConfig.getBrokerName());
                        ck.addDiff(0);
                        ck.setRePutTimes(ck.getRePutTimes());
                        int reviveQueueId = (int)record.getOffset() % this.brokerConfig.getReviveQueueNum();
                        MessageExtBrokerInner ckMsg = this.brokerController.getPopMessageProcessor().buildCkMsg(ck, reviveQueueId);
                        this.brokerController.getMessageStore().asyncPutMessage(ckMsg).join();
                    }
                    log.info("PopConsumerStore transfer from kvStore to fsStore, count={}", (Object)consumerRecords.size());
                    this.popConsumerStore.deleteRecords(consumerRecords);
                    this.waitForRunning(1L);
                }
            }
            catch (Throwable t) {
                log.error("PopConsumerStore transfer from kvStore to fsStore failure", t);
                continue;
            }
            break;
        }
        log.info("PopConsumerStore transfer to fsStore finish, cost={}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public String getServiceName() {
        return PopConsumerService.class.getSimpleName();
    }

    @VisibleForTesting
    protected PopConsumerKVStore getPopConsumerStore() {
        return this.popConsumerStore;
    }

    public PopConsumerLockService getConsumerLockService() {
        return this.consumerLockService;
    }

    public void start() {
        if (!this.popConsumerStore.start()) {
            throw new RuntimeException("PopConsumerStore init error");
        }
        if (this.popConsumerCache != null) {
            this.popConsumerCache.start();
        }
        super.start();
    }

    public void shutdown() {
        super.shutdown();
        do {
            this.waitForRunning(10L);
        } while (this.consumerRunning.get());
        if (this.popConsumerCache != null) {
            this.popConsumerCache.shutdown();
        }
        if (this.popConsumerStore != null) {
            this.popConsumerStore.shutdown();
        }
    }

    public void run() {
        this.consumerRunning.set(true);
        while (!this.isStopped()) {
            try {
                long reviveCount = this.revive(this.currentTime, this.brokerConfig.getPopReviveMaxReturnSizePerRead());
                long current = System.currentTimeMillis();
                if (this.lastCleanupLockTime.get() + TimeUnit.MINUTES.toMillis(1L) < current) {
                    this.consumerLockService.removeTimeout();
                    this.lastCleanupLockTime.set(current);
                }
                if (reviveCount >= (long)this.brokerConfig.getPopReviveMaxReturnSizePerRead()) continue;
                this.waitForRunning(500L);
            }
            catch (Exception e) {
                log.error("PopConsumerService revive error", (Throwable)e);
                this.waitForRunning(500L);
            }
        }
        this.consumerRunning.set(false);
    }
}

