/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.errors.StorageException;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.options.RocksDBOptions;
import com.alipay.sofa.jraft.rhea.rocks.support.RocksStatisticsCollector;
import com.alipay.sofa.jraft.rhea.serialization.Serializer;
import com.alipay.sofa.jraft.rhea.serialization.Serializers;
import com.alipay.sofa.jraft.rhea.storage.BatchRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.CASEntry;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.storage.KVIterator;
import com.alipay.sofa.jraft.rhea.storage.KVOperation;
import com.alipay.sofa.jraft.rhea.storage.KVState;
import com.alipay.sofa.jraft.rhea.storage.KVStateOutputList;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.alipay.sofa.jraft.rhea.storage.RocksDBBackupInfo;
import com.alipay.sofa.jraft.rhea.storage.RocksKVIterator;
import com.alipay.sofa.jraft.rhea.storage.Sequence;
import com.alipay.sofa.jraft.rhea.storage.SstColumnFamily;
import com.alipay.sofa.jraft.rhea.util.ByteArray;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.rhea.util.Partitions;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;
import com.alipay.sofa.jraft.util.Bits;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.DebugStatistics;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.StorageOptionsFactory;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.Utils;
import com.alipay.sofa.jraft.util.concurrent.AdjustableSemaphore;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.rocksdb.BackupEngine;
import org.rocksdb.BackupableDBOptions;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.EnvOptions;
import org.rocksdb.Holder;
import org.rocksdb.IngestExternalFileOptions;
import org.rocksdb.MergeOperator;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RestoreOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Snapshot;
import org.rocksdb.SstFileWriter;
import org.rocksdb.Statistics;
import org.rocksdb.StatisticsCollectorCallback;
import org.rocksdb.StatsCollectorInput;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksRawKVStore
extends BatchRawKVStore<RocksDBOptions>
implements Describer {
    private static final Logger LOG = LoggerFactory.getLogger(RocksRawKVStore.class);
    public static final int MAX_BATCH_WRITE_SIZE;
    private final AdjustableSemaphore shutdownLock = new AdjustableSemaphore();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AtomicLong databaseVersion = new AtomicLong(0L);
    private final Serializer serializer = Serializers.getDefault();
    private final List<ColumnFamilyOptions> cfOptionsList = Lists.newArrayList();
    private final List<ColumnFamilyDescriptor> cfDescriptors = Lists.newArrayList();
    private ColumnFamilyHandle defaultHandle;
    private ColumnFamilyHandle sequenceHandle;
    private ColumnFamilyHandle lockingHandle;
    private ColumnFamilyHandle fencingHandle;
    private RocksDB db;
    private RocksDBOptions opts;
    private DBOptions options;
    private WriteOptions writeOptions;
    private DebugStatistics statistics;
    private RocksStatisticsCollector statisticsCollector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(RocksDBOptions opts) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.db != null) {
                LOG.info("[RocksRawKVStore] already started.");
                boolean bl = true;
                return bl;
            }
            this.opts = opts;
            this.options = RocksRawKVStore.createDBOptions();
            if (opts.isOpenStatisticsCollector()) {
                this.statistics = new DebugStatistics();
                this.options.setStatistics((Statistics)this.statistics);
                long intervalSeconds = opts.getStatisticsCallbackIntervalSeconds();
                if (intervalSeconds > 0L) {
                    this.statisticsCollector = new RocksStatisticsCollector(TimeUnit.SECONDS.toMillis(intervalSeconds));
                    this.statisticsCollector.start();
                }
            }
            ColumnFamilyOptions cfOptions = RocksRawKVStore.createColumnFamilyOptions();
            this.cfOptionsList.add(cfOptions);
            this.cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cfOptions));
            this.cfDescriptors.add(new ColumnFamilyDescriptor(BytesUtil.writeUtf8((String)"RHEA_SEQUENCE"), cfOptions));
            this.cfDescriptors.add(new ColumnFamilyDescriptor(BytesUtil.writeUtf8((String)"RHEA_LOCKING"), cfOptions));
            this.cfDescriptors.add(new ColumnFamilyDescriptor(BytesUtil.writeUtf8((String)"RHEA_FENCING"), cfOptions));
            this.writeOptions = new WriteOptions();
            this.writeOptions.setSync(opts.isSync());
            this.writeOptions.setDisableWAL(!opts.isSync() && opts.isDisableWAL());
            this.destroyRocksDB(opts);
            this.openRocksDB(opts);
            this.shutdownLock.setMaxPermits(1);
            LOG.info("[RocksRawKVStore] start successfully, options: {}.", (Object)opts);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Fail to open rocksDB at path {}, {}.", (Object)opts.getDbPath(), (Object)StackTraceUtil.stackTrace(e));
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.db == null) {
                return;
            }
            this.shutdownLock.setMaxPermits(0);
            this.closeRocksDB();
            if (this.defaultHandle != null) {
                this.defaultHandle.close();
                this.defaultHandle = null;
            }
            if (this.sequenceHandle != null) {
                this.sequenceHandle.close();
                this.sequenceHandle = null;
            }
            if (this.lockingHandle != null) {
                this.lockingHandle.close();
                this.lockingHandle = null;
            }
            if (this.fencingHandle != null) {
                this.fencingHandle.close();
                this.fencingHandle = null;
            }
            for (ColumnFamilyOptions cfOptions : this.cfOptionsList) {
                cfOptions.close();
            }
            this.cfOptionsList.clear();
            this.cfDescriptors.clear();
            if (this.options != null) {
                this.options.close();
                this.options = null;
            }
            if (this.statisticsCollector != null) {
                try {
                    this.statisticsCollector.shutdown(3000);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.statistics != null) {
                this.statistics.close();
                this.statistics = null;
            }
            if (this.writeOptions != null) {
                this.writeOptions.close();
                this.writeOptions = null;
            }
        }
        finally {
            writeLock.unlock();
            LOG.info("[RocksRawKVStore] shutdown successfully.");
        }
    }

    @Override
    public KVIterator localIterator() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            RocksKVIterator rocksKVIterator = new RocksKVIterator(this, this.db.newIterator(), readLock, this.getDatabaseVersion());
            return rocksKVIterator;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(byte[] key, boolean readOnlySafe, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("GET");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            byte[] value = this.db.get(key);
            RocksRawKVStore.setSuccess(closure, value);
        }
        catch (Exception e) {
            LOG.error("Fail to [GET], key: [{}], {}.", (Object)BytesUtil.toHex((byte[])key), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setFailure(closure, "Fail to [GET]");
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void multiGet(List<byte[]> keys, boolean readOnlySafe, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("MULTI_GET");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Map rawMap = this.db.multiGet(keys);
            HashMap resultMap = Maps.newHashMapWithExpectedSize(rawMap.size());
            for (Map.Entry entry : rawMap.entrySet()) {
                resultMap.put(ByteArray.wrap((byte[])entry.getKey()), entry.getValue());
            }
            RocksRawKVStore.setSuccess(closure, resultMap);
        }
        catch (Exception e) {
            LOG.error("Fail to [MULTI_GET], key size: [{}], {}.", (Object)keys.size(), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setFailure(closure, "Fail to [MULTI_GET]");
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void containsKey(byte[] key, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("CONTAINS_KEY");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            boolean exists = false;
            Holder valueHolder = new Holder();
            if (this.db.keyMayExist(key, valueHolder)) {
                exists = valueHolder.getValue() != null;
            }
            RocksRawKVStore.setSuccess(closure, exists);
        }
        catch (Exception e) {
            LOG.error("Fail to [CONTAINS_KEY], key: [{}], {}.", (Object)BytesUtil.toHex((byte[])key), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setFailure(closure, "Fail to [CONTAINS_KEY]");
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("SCAN");
        ArrayList<KVEntry> entries = Lists.newArrayList();
        int maxCount = this.normalizeLimit(limit);
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try (RocksIterator it = this.db.newIterator();){
            if (startKey == null) {
                it.seekToFirst();
            } else {
                it.seek(startKey);
            }
            int count = 0;
            while (it.isValid() && count++ < maxCount) {
                byte[] key = it.key();
                if (endKey != null && BytesUtil.compare((byte[])key, (byte[])endKey) >= 0) break;
                entries.add(new KVEntry(key, returnValue ? it.value() : null));
                it.next();
            }
            RocksRawKVStore.setSuccess(closure, entries);
        }
        catch (Exception e) {
            LOG.error("Fail to [SCAN], range: ['[{}, {})'], {}.", new Object[]{BytesUtil.toHex((byte[])startKey), BytesUtil.toHex((byte[])endKey), StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setFailure(closure, "Fail to [SCAN]");
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("REVERSE_SCAN");
        ArrayList<KVEntry> entries = Lists.newArrayList();
        int maxCount = this.normalizeLimit(limit);
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try (RocksIterator it = this.db.newIterator();){
            if (startKey == null) {
                it.seekToLast();
            } else {
                it.seekForPrev(startKey);
            }
            int count = 0;
            while (it.isValid() && count++ < maxCount) {
                byte[] key = it.key();
                if (endKey != null && BytesUtil.compare((byte[])key, (byte[])endKey) <= 0) break;
                entries.add(new KVEntry(key, returnValue ? it.value() : null));
                it.prev();
            }
            RocksRawKVStore.setSuccess(closure, entries);
        }
        catch (Exception e) {
            LOG.error("Fail to [REVERSE_SCAN], range: ['[{}, {})'], {}.", new Object[]{BytesUtil.toHex((byte[])startKey), BytesUtil.toHex((byte[])endKey), StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setFailure(closure, "Fail to [REVERSE_SCAN]");
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSequence(byte[] seqKey, int step, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("GET_SEQUENCE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            byte[] prevBytesVal = this.db.get(this.sequenceHandle, seqKey);
            long startVal = prevBytesVal == null ? 0L : Bits.getLong((byte[])prevBytesVal, (int)0);
            if (step < 0) {
                RocksRawKVStore.setFailure(closure, "Fail to [GET_SEQUENCE], step must >= 0");
                return;
            }
            if (step == 0) {
                RocksRawKVStore.setSuccess(closure, new Sequence(startVal, startVal));
                return;
            }
            long endVal = this.getSafeEndValueForSequence(startVal, step);
            if (startVal != endVal) {
                byte[] newBytesVal = new byte[8];
                Bits.putLong((byte[])newBytesVal, (int)0, (long)endVal);
                this.db.put(this.sequenceHandle, this.writeOptions, seqKey, newBytesVal);
            }
            RocksRawKVStore.setSuccess(closure, new Sequence(startVal, endVal));
        }
        catch (Exception e) {
            LOG.error("Fail to [GET_SEQUENCE], [key = {}, step = {}], {}.", new Object[]{BytesUtil.toHex((byte[])seqKey), step, StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setCriticalError(closure, "Fail to [GET_SEQUENCE]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSequence(byte[] seqKey, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("RESET_SEQUENCE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            this.db.delete(this.sequenceHandle, seqKey);
            RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [RESET_SEQUENCE], [key = {}], {}.", (Object)BytesUtil.toHex((byte[])seqKey), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setCriticalError(closure, "Fail to [RESET_SEQUENCE]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchResetSequence(KVStateOutputList kvStates) {
        if (kvStates.isSingletonList()) {
            KVState kvState = kvStates.getSingletonElement();
            this.resetSequence(kvState.getOp().getKey(), kvState.getDone());
            return;
        }
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("BATCH_RESET_SEQUENCE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Partitions.manyToOne(kvStates, MAX_BATCH_WRITE_SIZE, segment -> {
                try (WriteBatch batch = new WriteBatch();){
                    for (KVState kvState : segment) {
                        batch.delete(this.sequenceHandle, kvState.getOp().getKey());
                    }
                    this.db.write(this.writeOptions, batch);
                    for (KVState kvState : segment) {
                        RocksRawKVStore.setSuccess(kvState.getDone(), Boolean.TRUE);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to [BATCH_RESET_SEQUENCE], [size = {}], {}.", (Object)segment.size(), (Object)StackTraceUtil.stackTrace(e));
                    RocksRawKVStore.setCriticalError(Lists.transform(kvStates, KVState::getDone), "Fail to [BATCH_RESET_SEQUENCE]", (Throwable)e);
                }
                return null;
            });
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(byte[] key, byte[] value, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("PUT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            this.db.put(this.writeOptions, key, value);
            RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [PUT], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])value), StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setCriticalError(closure, "Fail to [PUT]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchPut(KVStateOutputList kvStates) {
        if (kvStates.isSingletonList()) {
            KVState kvState = kvStates.getSingletonElement();
            KVOperation op = kvState.getOp();
            this.put(op.getKey(), op.getValue(), kvState.getDone());
            return;
        }
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("BATCH_PUT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Partitions.manyToOne(kvStates, MAX_BATCH_WRITE_SIZE, segment -> {
                try (WriteBatch batch = new WriteBatch();){
                    for (KVState kvState : segment) {
                        KVOperation op = kvState.getOp();
                        batch.put(op.getKey(), op.getValue());
                    }
                    this.db.write(this.writeOptions, batch);
                    for (KVState kvState : segment) {
                        RocksRawKVStore.setSuccess(kvState.getDone(), Boolean.TRUE);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to [BATCH_PUT], [size = {}] {}.", (Object)segment.size(), (Object)StackTraceUtil.stackTrace(e));
                    RocksRawKVStore.setCriticalError(Lists.transform(kvStates, KVState::getDone), "Fail to [BATCH_PUT]", (Throwable)e);
                }
                return null;
            });
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAndPut(byte[] key, byte[] value, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("GET_PUT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            byte[] prevVal = this.db.get(key);
            this.db.put(this.writeOptions, key, value);
            RocksRawKVStore.setSuccess(closure, prevVal);
        }
        catch (Exception e) {
            LOG.error("Fail to [GET_PUT], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])value), StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setCriticalError(closure, "Fail to [GET_PUT]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchGetAndPut(KVStateOutputList kvStates) {
        if (kvStates.isSingletonList()) {
            KVState kvState = kvStates.getSingletonElement();
            KVOperation op = kvState.getOp();
            this.getAndPut(op.getKey(), op.getValue(), kvState.getDone());
            return;
        }
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("BATCH_GET_PUT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Partitions.manyToOne(kvStates, MAX_BATCH_WRITE_SIZE, segment -> {
                try (WriteBatch batch = new WriteBatch();){
                    ArrayList<byte[]> keys = Lists.newArrayListWithCapacity(segment.size());
                    for (KVState kvState : segment) {
                        KVOperation op = kvState.getOp();
                        byte[] key = op.getKey();
                        keys.add(key);
                        batch.put(key, op.getValue());
                    }
                    Map prevValMap = this.db.multiGet(keys);
                    this.db.write(this.writeOptions, batch);
                    for (KVState kvState : segment) {
                        RocksRawKVStore.setSuccess(kvState.getDone(), prevValMap.get(kvState.getOp().getKey()));
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to [BATCH_GET_PUT], [size = {}] {}.", (Object)segment.size(), (Object)StackTraceUtil.stackTrace(e));
                    RocksRawKVStore.setCriticalError(Lists.transform(kvStates, KVState::getDone), "Fail to [BATCH_GET_PUT]", (Throwable)e);
                }
                return null;
            });
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compareAndPut(byte[] key, byte[] expect, byte[] update, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("COMPARE_PUT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            byte[] actual = this.db.get(key);
            if (Arrays.equals(expect, actual)) {
                this.db.put(this.writeOptions, key, update);
                RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
            } else {
                RocksRawKVStore.setSuccess(closure, Boolean.FALSE);
            }
        }
        catch (Exception e) {
            LOG.error("Fail to [COMPARE_PUT], [{}, {}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])expect), BytesUtil.toHex((byte[])update), StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setCriticalError(closure, "Fail to [COMPARE_PUT]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchCompareAndPut(KVStateOutputList kvStates) {
        if (kvStates.isSingletonList()) {
            KVState kvState = kvStates.getSingletonElement();
            KVOperation op = kvState.getOp();
            this.compareAndPut(op.getKey(), op.getExpect(), op.getValue(), kvState.getDone());
            return;
        }
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("BATCH_COMPARE_PUT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Partitions.manyToOne(kvStates, MAX_BATCH_WRITE_SIZE, segment -> {
                try (WriteBatch batch = new WriteBatch();){
                    byte[] key;
                    HashMap<byte[], byte[]> expects = Maps.newHashMapWithExpectedSize(segment.size());
                    HashMap<byte[], byte[]> updates = Maps.newHashMapWithExpectedSize(segment.size());
                    for (KVState kvState : segment) {
                        KVOperation op = kvState.getOp();
                        key = op.getKey();
                        byte[] expect = op.getExpect();
                        byte[] update = op.getValue();
                        expects.put(key, expect);
                        updates.put(key, update);
                    }
                    Map prevValMap = this.db.multiGet(Lists.newArrayList(expects.keySet()));
                    for (KVState kvState : segment) {
                        key = kvState.getOp().getKey();
                        if (Arrays.equals((byte[])expects.get(key), (byte[])prevValMap.get(key))) {
                            batch.put(key, (byte[])updates.get(key));
                            RocksRawKVStore.setData(kvState.getDone(), Boolean.TRUE);
                            continue;
                        }
                        RocksRawKVStore.setData(kvState.getDone(), Boolean.FALSE);
                    }
                    if (batch.count() > 0) {
                        this.db.write(this.writeOptions, batch);
                    }
                    for (KVState kvState : segment) {
                        RocksRawKVStore.setSuccess(kvState.getDone(), RocksRawKVStore.getData(kvState.getDone()));
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to [BATCH_COMPARE_PUT], [size = {}] {}.", (Object)segment.size(), (Object)StackTraceUtil.stackTrace(e));
                    RocksRawKVStore.setCriticalError(Lists.transform(kvStates, KVState::getDone), "Fail to [BATCH_COMPARE_PUT]", (Throwable)e);
                }
                return null;
            });
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(byte[] key, byte[] value, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("MERGE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            this.db.merge(this.writeOptions, key, value);
            RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [MERGE], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])value), StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setCriticalError(closure, "Fail to [MERGE]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchMerge(KVStateOutputList kvStates) {
        if (kvStates.isSingletonList()) {
            KVState kvState = kvStates.getSingletonElement();
            KVOperation op = kvState.getOp();
            this.merge(op.getKey(), op.getValue(), kvState.getDone());
            return;
        }
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("BATCH_MERGE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Partitions.manyToOne(kvStates, MAX_BATCH_WRITE_SIZE, segment -> {
                try (WriteBatch batch = new WriteBatch();){
                    for (KVState kvState : segment) {
                        KVOperation op = kvState.getOp();
                        batch.merge(op.getKey(), op.getValue());
                    }
                    this.db.write(this.writeOptions, batch);
                    for (KVState kvState : segment) {
                        RocksRawKVStore.setSuccess(kvState.getDone(), Boolean.TRUE);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to [BATCH_MERGE], [size = {}] {}.", (Object)segment.size(), (Object)StackTraceUtil.stackTrace(e));
                    RocksRawKVStore.setCriticalError(Lists.transform(kvStates, KVState::getDone), "Fail to [BATCH_MERGE]", (Throwable)e);
                }
                return null;
            });
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(List<KVEntry> entries, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("PUT_LIST");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try (WriteBatch batch = new WriteBatch();){
            for (KVEntry entry : entries) {
                batch.put(entry.getKey(), entry.getValue());
            }
            this.db.write(this.writeOptions, batch);
            RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Failed to [PUT_LIST], [size = {}], {}.", (Object)entries.size(), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setCriticalError(closure, "Fail to [PUT_LIST]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compareAndPutAll(List<CASEntry> entries, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("COMPARE_PUT_ALL");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try (WriteBatch batch = new WriteBatch();){
            ArrayList<byte[]> keys = Lists.newArrayList();
            for (CASEntry entry : entries) {
                keys.add(entry.getKey());
            }
            Map prevValMap = this.db.multiGet(keys);
            for (CASEntry entry : entries) {
                if (Arrays.equals(entry.getExpect(), (byte[])prevValMap.get(entry.getKey()))) continue;
                RocksRawKVStore.setSuccess(closure, Boolean.FALSE);
                return;
            }
            for (CASEntry entry : entries) {
                batch.put(entry.getKey(), entry.getUpdate());
            }
            if (batch.count() > 0) {
                this.db.write(this.writeOptions, batch);
            }
            RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Failed to [COMPARE_PUT_ALL], [size = {}] {}.", (Object)entries.size(), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setCriticalError(closure, "Fail to [COMPARE_PUT_ALL]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putIfAbsent(byte[] key, byte[] value, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("PUT_IF_ABSENT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            byte[] prevVal = this.db.get(key);
            if (prevVal == null) {
                this.db.put(this.writeOptions, key, value);
            }
            RocksRawKVStore.setSuccess(closure, prevVal);
        }
        catch (Exception e) {
            LOG.error("Fail to [PUT_IF_ABSENT], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), BytesUtil.toHex((byte[])value), StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setCriticalError(closure, "Fail to [PUT_IF_ABSENT]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchPutIfAbsent(KVStateOutputList kvStates) {
        if (kvStates.isSingletonList()) {
            KVState kvState = kvStates.getSingletonElement();
            KVOperation op = kvState.getOp();
            this.putIfAbsent(op.getKey(), op.getValue(), kvState.getDone());
            return;
        }
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("BATCH_PUT_IF_ABSENT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Partitions.manyToOne(kvStates, MAX_BATCH_WRITE_SIZE, segment -> {
                try (WriteBatch batch = new WriteBatch();){
                    byte[] key;
                    ArrayList<byte[]> keys = Lists.newArrayListWithCapacity(segment.size());
                    HashMap<byte[], byte[]> values = Maps.newHashMapWithExpectedSize(segment.size());
                    for (KVState kvState : segment) {
                        KVOperation op = kvState.getOp();
                        key = op.getKey();
                        byte[] value = op.getValue();
                        keys.add(key);
                        values.put(key, value);
                    }
                    Map prevValMap = this.db.multiGet(keys);
                    for (KVState kvState : segment) {
                        key = kvState.getOp().getKey();
                        byte[] prevVal = (byte[])prevValMap.get(key);
                        if (prevVal == null) {
                            batch.put(key, (byte[])values.get(key));
                        }
                        RocksRawKVStore.setData(kvState.getDone(), prevVal);
                    }
                    if (batch.count() > 0) {
                        this.db.write(this.writeOptions, batch);
                    }
                    for (KVState kvState : segment) {
                        RocksRawKVStore.setSuccess(kvState.getDone(), RocksRawKVStore.getData(kvState.getDone()));
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to [BATCH_PUT_IF_ABSENT], [size = {}] {}.", (Object)segment.size(), (Object)StackTraceUtil.stackTrace(e));
                    RocksRawKVStore.setCriticalError(Lists.transform(kvStates, KVState::getDone), "Fail to [BATCH_PUT_IF_ABSENT]", (Throwable)e);
                }
                return null;
            });
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryLockWith(byte[] key, byte[] fencingKey, boolean keepLease, DistributedLock.Acquirer acquirer, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("TRY_LOCK");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            DistributedLock.Owner owner;
            long now = acquirer.getLockingTimestamp();
            long timeoutMillis = acquirer.getLeaseMillis();
            byte[] prevBytesVal = this.db.get(this.lockingHandle, key);
            DistributedLock.OwnerBuilder builder = DistributedLock.newOwnerBuilder();
            if (prevBytesVal == null) {
                if (keepLease) {
                    owner = builder.id(acquirer.getId()).remainingMillis(DistributedLock.OwnerBuilder.KEEP_LEASE_FAIL).success(false).build();
                } else {
                    owner = builder.id(acquirer.getId()).deadlineMillis(now + timeoutMillis).remainingMillis(DistributedLock.OwnerBuilder.FIRST_TIME_SUCCESS).fencingToken(this.getNextFencingToken(fencingKey)).acquires(1L).context(acquirer.getContext()).success(true).build();
                    this.db.put(this.lockingHandle, this.writeOptions, key, this.serializer.writeObject(owner));
                }
            } else {
                DistributedLock.Owner prevOwner = this.serializer.readObject(prevBytesVal, DistributedLock.Owner.class);
                long remainingMillis = prevOwner.getDeadlineMillis() - now;
                if (remainingMillis < 0L) {
                    if (keepLease) {
                        owner = builder.id(prevOwner.getId()).deadlineMillis(prevOwner.getDeadlineMillis()).remainingMillis(DistributedLock.OwnerBuilder.KEEP_LEASE_FAIL).context(prevOwner.getContext()).success(false).build();
                    } else {
                        owner = builder.id(acquirer.getId()).deadlineMillis(now + timeoutMillis).remainingMillis(DistributedLock.OwnerBuilder.NEW_ACQUIRE_SUCCESS).fencingToken(this.getNextFencingToken(fencingKey)).acquires(1L).context(acquirer.getContext()).success(true).build();
                        this.db.put(this.lockingHandle, this.writeOptions, key, this.serializer.writeObject(owner));
                    }
                } else {
                    boolean isReentrant = prevOwner.isSameAcquirer(acquirer);
                    if (isReentrant) {
                        if (keepLease) {
                            owner = builder.id(prevOwner.getId()).deadlineMillis(now + timeoutMillis).remainingMillis(DistributedLock.OwnerBuilder.KEEP_LEASE_SUCCESS).fencingToken(prevOwner.getFencingToken()).acquires(prevOwner.getAcquires()).context(prevOwner.getContext()).success(true).build();
                            this.db.put(this.lockingHandle, this.writeOptions, key, this.serializer.writeObject(owner));
                        } else {
                            owner = builder.id(prevOwner.getId()).deadlineMillis(now + timeoutMillis).remainingMillis(DistributedLock.OwnerBuilder.REENTRANT_SUCCESS).fencingToken(prevOwner.getFencingToken()).acquires(prevOwner.getAcquires() + 1L).context(acquirer.getContext()).success(true).build();
                            this.db.put(this.lockingHandle, this.writeOptions, key, this.serializer.writeObject(owner));
                        }
                    } else {
                        owner = builder.id(prevOwner.getId()).remainingMillis(remainingMillis).context(prevOwner.getContext()).success(false).build();
                        LOG.debug("Another locker [{}] is trying the existed lock [{}].", (Object)acquirer, (Object)prevOwner);
                    }
                }
            }
            RocksRawKVStore.setSuccess(closure, owner);
        }
        catch (Exception e) {
            LOG.error("Fail to [TRY_LOCK], [{}, {}], {}.", new Object[]{BytesUtil.toHex((byte[])key), acquirer, StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setCriticalError(closure, "Fail to [TRY_LOCK]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLockWith(byte[] key, DistributedLock.Acquirer acquirer, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("RELEASE_LOCK");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            DistributedLock.Owner owner;
            byte[] prevBytesVal = this.db.get(this.lockingHandle, key);
            DistributedLock.OwnerBuilder builder = DistributedLock.newOwnerBuilder();
            if (prevBytesVal == null) {
                LOG.warn("Lock not exist: {}.", (Object)acquirer);
                owner = builder.id(acquirer.getId()).fencingToken(acquirer.getFencingToken()).acquires(0L).success(true).build();
            } else {
                DistributedLock.Owner prevOwner = this.serializer.readObject(prevBytesVal, DistributedLock.Owner.class);
                if (prevOwner.isSameAcquirer(acquirer)) {
                    long acquires = prevOwner.getAcquires() - 1L;
                    owner = builder.id(prevOwner.getId()).deadlineMillis(prevOwner.getDeadlineMillis()).fencingToken(prevOwner.getFencingToken()).acquires(acquires).context(prevOwner.getContext()).success(true).build();
                    if (acquires <= 0L) {
                        this.db.delete(this.lockingHandle, this.writeOptions, key);
                    } else {
                        this.db.put(this.lockingHandle, this.writeOptions, key, this.serializer.writeObject(owner));
                    }
                } else {
                    owner = builder.id(prevOwner.getId()).fencingToken(prevOwner.getFencingToken()).acquires(prevOwner.getAcquires()).context(prevOwner.getContext()).success(false).build();
                    LOG.warn("The lock owner is: [{}], [{}] could't release it.", (Object)prevOwner, (Object)acquirer);
                }
            }
            RocksRawKVStore.setSuccess(closure, owner);
        }
        catch (Exception e) {
            LOG.error("Fail to [RELEASE_LOCK], [{}], {}.", (Object)BytesUtil.toHex((byte[])key), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setCriticalError(closure, "Fail to [RELEASE_LOCK]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextFencingToken(byte[] fencingKey) throws RocksDBException {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("FENCING_TOKEN");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            byte[] realKey = BytesUtil.nullToEmpty((byte[])fencingKey);
            byte[] prevBytesVal = this.db.get(this.fencingHandle, realKey);
            long prevVal = prevBytesVal == null ? 0L : Bits.getLong((byte[])prevBytesVal, (int)0);
            long newVal = prevVal + 1L;
            byte[] newBytesVal = new byte[8];
            Bits.putLong((byte[])newBytesVal, (int)0, (long)newVal);
            this.db.put(this.fencingHandle, this.writeOptions, realKey, newBytesVal);
            long l = newVal;
            return l;
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(byte[] key, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("DELETE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            this.db.delete(this.writeOptions, key);
            RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [DELETE], [{}], {}.", (Object)BytesUtil.toHex((byte[])key), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setCriticalError(closure, "Fail to [DELETE]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchDelete(KVStateOutputList kvStates) {
        if (kvStates.isSingletonList()) {
            KVState kvState = kvStates.getSingletonElement();
            this.delete(kvState.getOp().getKey(), kvState.getDone());
            return;
        }
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("BATCH_DELETE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Partitions.manyToOne(kvStates, MAX_BATCH_WRITE_SIZE, segment -> {
                try (WriteBatch batch = new WriteBatch();){
                    for (KVState kvState : segment) {
                        batch.delete(kvState.getOp().getKey());
                    }
                    this.db.write(this.writeOptions, batch);
                    for (KVState kvState : segment) {
                        RocksRawKVStore.setSuccess(kvState.getDone(), Boolean.TRUE);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to [BATCH_DELETE], [size = {}], {}.", (Object)segment.size(), (Object)StackTraceUtil.stackTrace(e));
                    RocksRawKVStore.setCriticalError(Lists.transform(kvStates, KVState::getDone), "Fail to [BATCH_DELETE]", (Throwable)e);
                }
                return null;
            });
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRange(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("DELETE_RANGE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            this.db.deleteRange(this.writeOptions, startKey, endKey);
            RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Fail to [DELETE_RANGE], ['[{}, {})'], {}.", new Object[]{BytesUtil.toHex((byte[])startKey), BytesUtil.toHex((byte[])endKey), StackTraceUtil.stackTrace(e)});
            RocksRawKVStore.setCriticalError(closure, "Fail to [DELETE_RANGE]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(List<byte[]> keys, KVStoreClosure closure) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("DELETE_LIST");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try (WriteBatch batch = new WriteBatch();){
            for (byte[] key : keys) {
                batch.delete(key);
            }
            this.db.write(this.writeOptions, batch);
            RocksRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("Failed to [DELETE_LIST], [size = {}], {}.", (Object)keys.size(), (Object)StackTraceUtil.stackTrace(e));
            RocksRawKVStore.setCriticalError(closure, "Fail to [DELETE_LIST]", (Throwable)e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getApproximateKeysInRange(byte[] startKey, byte[] endKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] jumpOver(byte[] startKey, long distance) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 31[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void initFencingToken(byte[] parentKey, byte[] childKey) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("INIT_FENCING_TOKEN");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            byte[] realKey = BytesUtil.nullToEmpty((byte[])parentKey);
            byte[] parentBytesVal = this.db.get(this.fencingHandle, realKey);
            if (parentBytesVal == null) {
                return;
            }
            this.db.put(this.fencingHandle, this.writeOptions, childKey, parentBytesVal);
        }
        catch (RocksDBException e) {
            throw new StorageException("Fail to init fencing token.", e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    public long getDatabaseVersion() {
        return this.databaseVersion.get();
    }

    public void addStatisticsCollectorCallback(StatisticsCollectorCallback callback) {
        RocksStatisticsCollector collector = (RocksStatisticsCollector)Requires.requireNonNull((Object)this.statisticsCollector, (String)"statisticsCollector");
        Statistics statistics = (Statistics)Requires.requireNonNull((Object)this.statistics, (String)"statistics");
        collector.addStatsCollectorInput(new StatsCollectorInput(statistics, callback));
    }

    boolean isFastSnapshot() {
        return ((RocksDBOptions)Requires.requireNonNull((Object)this.opts, (String)"opts")).isFastSnapshot();
    }

    boolean isAsyncSnapshot() {
        return ((RocksDBOptions)Requires.requireNonNull((Object)this.opts, (String)"opts")).isAsyncSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> createSstFiles(EnumMap<SstColumnFamily, File> sstFileTable, byte[] startKey, byte[] endKey, ExecutorService executor) {
        Snapshot snapshot;
        CompletableFuture<Void> sstFuture = new CompletableFuture<Void>();
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            snapshot = this.db.getSnapshot();
            if (!this.isAsyncSnapshot()) {
                this.doCreateSstFiles(snapshot, sstFileTable, startKey, endKey, sstFuture);
                CompletableFuture<Void> completableFuture = sstFuture;
                return completableFuture;
            }
        }
        finally {
            readLock.unlock();
        }
        executor.execute(() -> this.doCreateSstFiles(snapshot, sstFileTable, startKey, endKey, sstFuture));
        return sstFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCreateSstFiles(Snapshot snapshot, EnumMap<SstColumnFamily, File> sstFileTable, byte[] startKey, byte[] endKey, CompletableFuture<Void> future) {
        block75: {
            Timer.Context timeCtx = RocksRawKVStore.getTimeContext("CREATE_SST_FILE");
            Lock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                if (!this.shutdownLock.isAvailable()) {
                    future.completeExceptionally(new StorageException("KV store has shutdown."));
                    return;
                }
                try (ReadOptions readOptions = new ReadOptions();
                     EnvOptions envOptions = new EnvOptions();
                     Options options = new Options().setMergeOperator((MergeOperator)new StringAppendOperator());){
                    readOptions.setSnapshot(snapshot);
                    for (Map.Entry<SstColumnFamily, File> entry : sstFileTable.entrySet()) {
                        SstColumnFamily sstColumnFamily = entry.getKey();
                        File sstFile = entry.getValue();
                        ColumnFamilyHandle columnFamilyHandle = this.findColumnFamilyHandle(sstColumnFamily);
                        try {
                            RocksIterator it = this.db.newIterator(columnFamilyHandle, readOptions);
                            Throwable throwable = null;
                            try {
                                SstFileWriter sstFileWriter = new SstFileWriter(envOptions, options);
                                Throwable throwable2 = null;
                                try {
                                    if (startKey == null) {
                                        it.seekToFirst();
                                    } else {
                                        it.seek(startKey);
                                    }
                                    sstFileWriter.open(sstFile.getAbsolutePath());
                                    long count = 0L;
                                    while (it.isValid()) {
                                        byte[] key = it.key();
                                        if (endKey != null && BytesUtil.compare((byte[])key, (byte[])endKey) >= 0) break;
                                        sstFileWriter.put(key, it.value());
                                        ++count;
                                        it.next();
                                    }
                                    if (count == 0L) {
                                        sstFileWriter.close();
                                    } else {
                                        sstFileWriter.finish();
                                    }
                                    LOG.info("Finish sst file {} with {} keys.", (Object)sstFile, (Object)count);
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (sstFileWriter == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            sstFileWriter.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    sstFileWriter.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (it == null) continue;
                                if (throwable != null) {
                                    try {
                                        it.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                it.close();
                            }
                        }
                        catch (RocksDBException e) {
                            throw new StorageException("Fail to create sst file at path: " + sstFile, e);
                        }
                    }
                    future.complete(null);
                }
                catch (Throwable t) {
                    try {
                        future.completeExceptionally(t);
                        break block75;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        snapshot.close();
                        this.db.releaseSnapshot(snapshot);
                    }
                }
                snapshot.close();
                this.db.releaseSnapshot(snapshot);
            }
            finally {
                readLock.unlock();
                timeCtx.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void ingestSstFiles(EnumMap<SstColumnFamily, File> sstFileTable) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("INGEST_SST_FILE");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            File sstFile;
            Iterator<Map.Entry<SstColumnFamily, File>> iterator = sstFileTable.entrySet().iterator();
            while (iterator.hasNext()) {
                Throwable throwable;
                IngestExternalFileOptions ingestOptions;
                ColumnFamilyHandle columnFamilyHandle;
                block21: {
                    block22: {
                        Map.Entry<SstColumnFamily, File> entry = iterator.next();
                        SstColumnFamily sstColumnFamily = entry.getKey();
                        sstFile = entry.getValue();
                        columnFamilyHandle = this.findColumnFamilyHandle(sstColumnFamily);
                        ingestOptions = new IngestExternalFileOptions();
                        throwable = null;
                        if (FileUtils.sizeOf((File)sstFile) != 0L) break block21;
                        if (ingestOptions == null) return;
                        if (throwable == null) break block22;
                        try {
                            ingestOptions.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return;
                        }
                    }
                    ingestOptions.close();
                    return;
                }
                try {
                    String filePath = sstFile.getAbsolutePath();
                    LOG.info("Start ingest sst file {}.", (Object)filePath);
                    this.db.ingestExternalFile(columnFamilyHandle, Collections.singletonList(filePath), ingestOptions);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (ingestOptions == null) continue;
                    if (throwable != null) {
                        try {
                            ingestOptions.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ingestOptions.close();
                }
            }
            return;
            {
                catch (RocksDBException e) {
                    throw new StorageException("Fail to ingest sst file at path: " + sstFile, e);
                }
            }
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    /*
     * Exception decompiling
     */
    RocksDBBackupInfo backupDB(String backupDBPath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void restoreBackup(String backupDBPath, RocksDBBackupInfo rocksBackupInfo) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("RESTORE_BACKUP");
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        this.closeRocksDB();
        try (BackupableDBOptions backupOpts = RocksRawKVStore.createBackupDBOptions(backupDBPath);
             BackupEngine backupEngine = BackupEngine.open((Env)this.options.getEnv(), (BackupableDBOptions)backupOpts);
             RestoreOptions restoreOpts = new RestoreOptions(false);){
            String dbPath = this.opts.getDbPath();
            backupEngine.restoreDbFromBackup(rocksBackupInfo.getBackupId(), dbPath, dbPath, restoreOpts);
            LOG.info("Restored rocksDB from {} with {}.", (Object)backupDBPath, (Object)rocksBackupInfo);
            this.openRocksDB(this.opts);
        }
        catch (RocksDBException e) {
            throw new StorageException("Fail to restore from path: " + backupDBPath, e);
        }
        finally {
            writeLock.unlock();
            timeCtx.stop();
        }
    }

    void writeSnapshot(String snapshotPath) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("WRITE_SNAPSHOT");
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try (Checkpoint checkpoint = Checkpoint.create((RocksDB)this.db);){
            String tempPath = snapshotPath + "_temp";
            File tempFile = new File(tempPath);
            FileUtils.deleteDirectory((File)tempFile);
            checkpoint.createCheckpoint(tempPath);
            File snapshotFile = new File(snapshotPath);
            FileUtils.deleteDirectory((File)snapshotFile);
            if (!Utils.atomicMoveFile((File)tempFile, (File)snapshotFile, (boolean)true)) {
                throw new StorageException("Fail to rename [" + tempPath + "] to [" + snapshotPath + "].");
            }
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("Fail to write snapshot at path: " + snapshotPath, e);
        }
        finally {
            writeLock.unlock();
            timeCtx.stop();
        }
    }

    void readSnapshot(String snapshotPath) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("READ_SNAPSHOT");
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            File snapshotFile = new File(snapshotPath);
            if (!snapshotFile.exists()) {
                LOG.error("Snapshot file [{}] not exists.", (Object)snapshotPath);
                return;
            }
            this.closeRocksDB();
            String dbPath = this.opts.getDbPath();
            File dbFile = new File(dbPath);
            FileUtils.deleteDirectory((File)dbFile);
            if (!Utils.atomicMoveFile((File)snapshotFile, (File)dbFile, (boolean)true)) {
                throw new StorageException("Fail to rename [" + snapshotPath + "] to [" + dbPath + "].");
            }
            this.openRocksDB(this.opts);
        }
        catch (Exception e) {
            throw new StorageException("Fail to read snapshot from path: " + snapshotPath, e);
        }
        finally {
            writeLock.unlock();
            timeCtx.stop();
        }
    }

    CompletableFuture<Void> writeSstSnapshot(String snapshotPath, Region region, ExecutorService executor) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("WRITE_SST_SNAPSHOT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            String tempPath = snapshotPath + "_temp";
            File tempFile = new File(tempPath);
            FileUtils.deleteDirectory((File)tempFile);
            FileUtils.forceMkdir((File)tempFile);
            EnumMap<SstColumnFamily, File> sstFileTable = this.getSstFileTable(tempPath);
            CompletableFuture<Void> snapshotFuture = new CompletableFuture<Void>();
            CompletableFuture<Void> sstFuture = this.createSstFiles(sstFileTable, region.getStartKey(), region.getEndKey(), executor);
            sstFuture.whenComplete((aVoid, throwable) -> {
                if (throwable == null) {
                    try {
                        File snapshotFile = new File(snapshotPath);
                        FileUtils.deleteDirectory((File)snapshotFile);
                        if (!Utils.atomicMoveFile((File)tempFile, (File)snapshotFile, (boolean)true)) {
                            throw new StorageException("Fail to rename [" + tempPath + "] to [" + snapshotPath + "].");
                        }
                        snapshotFuture.complete(null);
                    }
                    catch (Throwable t) {
                        snapshotFuture.completeExceptionally(t);
                    }
                } else {
                    snapshotFuture.completeExceptionally((Throwable)throwable);
                }
            });
            CompletableFuture<Void> completableFuture = snapshotFuture;
            return completableFuture;
        }
        catch (Exception e) {
            throw new StorageException("Fail to do read sst snapshot at path: " + snapshotPath, e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    void readSstSnapshot(String snapshotPath) {
        Timer.Context timeCtx = RocksRawKVStore.getTimeContext("READ_SST_SNAPSHOT");
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            EnumMap<SstColumnFamily, File> sstFileTable = this.getSstFileTable(snapshotPath);
            this.ingestSstFiles(sstFileTable);
        }
        catch (Exception e) {
            throw new StorageException("Fail to write sst snapshot at path: " + snapshotPath, e);
        }
        finally {
            readLock.unlock();
            timeCtx.stop();
        }
    }

    private EnumMap<SstColumnFamily, File> getSstFileTable(String path) {
        EnumMap<SstColumnFamily, File> sstFileTable = new EnumMap<SstColumnFamily, File>(SstColumnFamily.class);
        sstFileTable.put(SstColumnFamily.DEFAULT, Paths.get(path, "default.sst").toFile());
        sstFileTable.put(SstColumnFamily.SEQUENCE, Paths.get(path, "sequence.sst").toFile());
        sstFileTable.put(SstColumnFamily.LOCKING, Paths.get(path, "locking.sst").toFile());
        sstFileTable.put(SstColumnFamily.FENCING, Paths.get(path, "fencing.sst").toFile());
        return sstFileTable;
    }

    private ColumnFamilyHandle findColumnFamilyHandle(SstColumnFamily sstColumnFamily) {
        switch (sstColumnFamily) {
            case DEFAULT: {
                return this.defaultHandle;
            }
            case SEQUENCE: {
                return this.sequenceHandle;
            }
            case LOCKING: {
                return this.lockingHandle;
            }
            case FENCING: {
                return this.fencingHandle;
            }
        }
        throw new IllegalArgumentException("illegal sstColumnFamily: " + sstColumnFamily.name());
    }

    private void openRocksDB(RocksDBOptions opts) throws RocksDBException {
        ArrayList cfHandles = Lists.newArrayList();
        this.databaseVersion.incrementAndGet();
        this.db = RocksDB.open((DBOptions)this.options, (String)opts.getDbPath(), this.cfDescriptors, cfHandles);
        this.defaultHandle = (ColumnFamilyHandle)cfHandles.get(0);
        this.sequenceHandle = (ColumnFamilyHandle)cfHandles.get(1);
        this.lockingHandle = (ColumnFamilyHandle)cfHandles.get(2);
        this.fencingHandle = (ColumnFamilyHandle)cfHandles.get(3);
    }

    private void closeRocksDB() {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    private void destroyRocksDB(RocksDBOptions opts) throws RocksDBException {
        try (Options opt = new Options();){
            RocksDB.destroyDB((String)opts.getDbPath(), (Options)opt);
        }
    }

    private static DBOptions createDBOptions() {
        return StorageOptionsFactory.getRocksDBOptions(RocksRawKVStore.class).setEnv(Env.getDefault());
    }

    private static ColumnFamilyOptions createColumnFamilyOptions() {
        BlockBasedTableConfig tConfig = StorageOptionsFactory.getRocksDBTableFormatConfig(RocksRawKVStore.class);
        return StorageOptionsFactory.getRocksDBColumnFamilyOptions(RocksRawKVStore.class).setTableFormatConfig((TableFormatConfig)tConfig).setMergeOperator((MergeOperator)new StringAppendOperator());
    }

    private static BackupableDBOptions createBackupDBOptions(String backupDBPath) {
        return new BackupableDBOptions(backupDBPath).setSync(true).setShareTableFiles(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describe(Describer.Printer out) {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            if (this.db != null) {
                out.println((Object)this.db.getProperty("rocksdb.stats"));
            }
            out.println((Object)"");
            if (this.statistics != null) {
                out.println((Object)this.statistics.getString());
            }
        }
        catch (RocksDBException e) {
            out.println((Object)e);
        }
        finally {
            readLock.unlock();
        }
    }

    static {
        RocksDB.loadLibrary();
        MAX_BATCH_WRITE_SIZE = SystemPropertyUtil.getInt((String)"rhea.rocksdb.user.max_batch_write_size", (int)128);
    }
}

