/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util;

import com.alipay.sofa.jraft.rhea.cmd.store.BaseRequest;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.InvalidParameterException;
import com.alipay.sofa.jraft.rhea.metadata.RegionEpoch;
import java.util.List;

public final class KVParameterRequires {
    public static void requireSameEpoch(BaseRequest request, RegionEpoch current) {
        RegionEpoch requestEpoch = request.getRegionEpoch();
        if (current.equals(requestEpoch)) {
            return;
        }
        if (current.getConfVer() != requestEpoch.getConfVer()) {
            throw Errors.INVALID_REGION_MEMBERSHIP.exception();
        }
        if (current.getVersion() != requestEpoch.getVersion()) {
            throw Errors.INVALID_REGION_VERSION.exception();
        }
        throw Errors.INVALID_REGION_EPOCH.exception();
    }

    public static <T> T requireNonNull(T target, String message) {
        if (target == null) {
            throw new InvalidParameterException(message);
        }
        return target;
    }

    public static <T> List<T> requireNonEmpty(List<T> target, String message) {
        KVParameterRequires.requireNonNull(target, message);
        if (target.isEmpty()) {
            throw new InvalidParameterException(message);
        }
        return target;
    }

    public static int requireNonNegative(int value, String message) {
        if (value < 0) {
            throw new InvalidParameterException(message);
        }
        return value;
    }

    public static long requireNonNegative(long value, String message) {
        if (value < 0L) {
            throw new InvalidParameterException(message);
        }
        return value;
    }

    public static int requirePositive(int value, String message) {
        if (value <= 0) {
            throw new InvalidParameterException(message);
        }
        return value;
    }

    public static long requirePositive(long value, String message) {
        if (value <= 0L) {
            throw new InvalidParameterException(message);
        }
        return value;
    }

    private KVParameterRequires() {
    }
}

