/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent;

import com.alipay.sofa.jraft.rhea.util.JvmTools;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRejectedExecutionHandler
implements RejectedExecutionHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractRejectedExecutionHandler.class);
    protected final String threadPoolName;
    private final AtomicBoolean dumpNeeded;
    private final String dumpPrefixName;

    public AbstractRejectedExecutionHandler(String threadPoolName, boolean dumpNeeded, String dumpPrefixName) {
        this.threadPoolName = threadPoolName;
        this.dumpNeeded = new AtomicBoolean(dumpNeeded);
        this.dumpPrefixName = dumpPrefixName;
    }

    public void dumpJvmInfoIfNeeded() {
        if (this.dumpNeeded.getAndSet(false)) {
            String now = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
            String name = this.threadPoolName + "_" + now;
            try (FileOutputStream fileOutput = new FileOutputStream(new File(this.dumpPrefixName + "_dump_" + name + ".log"));){
                List<String> stacks = JvmTools.jStack();
                for (String s : stacks) {
                    fileOutput.write(Utils.getBytes((String)s));
                }
                List<String> memoryUsages = JvmTools.memoryUsage();
                for (String m : memoryUsages) {
                    fileOutput.write(Utils.getBytes((String)m));
                }
                if (JvmTools.memoryUsed() > 0.9) {
                    JvmTools.jMap(this.dumpPrefixName + "_dump_" + name + ".bin", false);
                }
            }
            catch (Throwable t) {
                LOG.error("Dump jvm info error: {}.", (Object)StackTraceUtil.stackTrace(t));
            }
        }
    }
}

