/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.pipeline;

import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerContext;
import com.alipay.sofa.jraft.rhea.util.pipeline.InboundHandler;
import com.alipay.sofa.jraft.rhea.util.pipeline.OutboundHandler;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.InboundMessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.MessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.OutboundMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HandlerInvokerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerInvokerUtil.class);

    public static void invokeInboundNow(HandlerContext ctx, InboundMessageEvent<?> event) {
        try {
            ((InboundHandler)ctx.handler()).handleInbound(ctx, event);
        }
        catch (Throwable t) {
            HandlerInvokerUtil.notifyHandlerException(ctx, event, t);
        }
    }

    public static void invokeOutboundNow(HandlerContext ctx, OutboundMessageEvent<?> event) {
        try {
            ((OutboundHandler)ctx.handler()).handleOutbound(ctx, event);
        }
        catch (Throwable t) {
            HandlerInvokerUtil.notifyHandlerException(ctx, event, t);
        }
    }

    public static void invokeExceptionCaughtNow(HandlerContext ctx, MessageEvent<?> event, Throwable cause) {
        block2: {
            try {
                ctx.handler().exceptionCaught(ctx, event, cause);
            }
            catch (Throwable t) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("An exception was thrown by a user handler's exceptionCaught() method: {}.", (Object)StackTraceUtil.stackTrace(t));
                LOG.warn(".. and the cause of the exceptionCaught() was: {}.", (Object)StackTraceUtil.stackTrace(cause));
            }
        }
    }

    private static void notifyHandlerException(HandlerContext ctx, MessageEvent<?> event, Throwable cause) {
        if (HandlerInvokerUtil.inExceptionCaught(cause)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("An exception was thrown by a user handler while handling an exceptionCaught event: {}.", (Object)StackTraceUtil.stackTrace(cause));
            }
            return;
        }
        HandlerInvokerUtil.invokeExceptionCaughtNow(ctx, event, cause);
    }

    private static boolean inExceptionCaught(Throwable cause) {
        do {
            StackTraceElement[] trace;
            if ((trace = cause.getStackTrace()) == null) continue;
            for (StackTraceElement t : trace) {
                if (t == null) break;
                if (!"exceptionCaught".equals(t.getMethodName())) continue;
                return true;
            }
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    private HandlerInvokerUtil() {
    }
}

