/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class ThreadTrackingGroup
extends ThreadGroup {
    private final ThreadLifecycleListener listener;

    public ThreadTrackingGroup(ThreadGroup parent, ThreadLifecycleListener listener) {
        super(parent, ThreadTrackingGroup.class.getSimpleName().toLowerCase() + System.identityHashCode(listener));
        this.listener = listener;
    }

    void add(Thread t) {
        super.add(t);
        this.listener.started(t);
    }

    void threadStartFailed(Thread t) {
        super.threadStartFailed(t);
        this.listener.startFailed(t);
    }

    void threadTerminated(Thread t) {
        super.threadTerminated(t);
        this.listener.terminated(t);
    }
}

