/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum LockCheck {

    private static final Logger LOGGER = LoggerFactory.getLogger(LockCheck.class);
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final int EMPTY_PID = Integer.MIN_VALUE;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z");
    static final boolean IS_LINUX = OS.startsWith("linux");

    static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public static boolean isCpuFree(int cpu) {
        if (!IS_LINUX) {
            return true;
        }
        File file = LockCheck.toFile(cpu);
        boolean exists = file.exists();
        if (!exists) {
            return true;
        }
        int currentProcess = 0;
        try {
            currentProcess = LockCheck.getProcessForCpu(file);
        }
        catch (IOException | RuntimeException e) {
            LOGGER.warn("Failed to determine process on cpu " + cpu, (Throwable)e);
            e.printStackTrace();
            return true;
        }
        if (currentProcess == Integer.MIN_VALUE) {
            file.delete();
            return true;
        }
        if (!LockCheck.isProcessRunning(currentProcess)) {
            file.delete();
            return true;
        }
        return false;
    }

    @NotNull
    static File toFile(int core) {
        return new File(LockCheck.tmpDir(), "cpu-" + core + ".lock");
    }

    static void replacePid(int core, long processID) throws IOException {
        LockCheck.replacePid(LockCheck.toFile(core), processID);
    }

    private static void replacePid(File file, long processID) throws IOException {
        file.delete();
        LockCheck.storePid(processID, file);
    }

    static boolean isProcessRunning(long pid) {
        if (IS_LINUX) {
            return new File("/proc/" + pid).exists();
        }
        throw new UnsupportedOperationException("this is only supported on LINUX");
    }

    private static synchronized void storePid(long processID, File coreFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(coreFile, false), "utf-8"));){
            String processIDStr = Long.toString(processID);
            writer.write(processIDStr + "\n" + df.format(new Date()));
        }
    }

    static int getProcessForCpu(int core) throws IOException {
        return LockCheck.getProcessForCpu(LockCheck.toFile(core));
    }

    /*
     * Loose catch block
     */
    private static int getProcessForCpu(@NotNull File coreFile) throws IOException {
        Throwable throwable = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(coreFile), "utf-8"));){
            String firstLine = reader.readLine();
            if (firstLine == null) {
                LOGGER.warn("Empty lock file {}", (Object)coreFile.getAbsolutePath());
                int n = Integer.MIN_VALUE;
                return n;
            }
            String s = firstLine.trim();
            try {
                int n = Integer.parseInt(s);
                return n;
            }
            catch (RuntimeException e) {
                int n;
                block21: {
                    block22: {
                        LOGGER.warn("Corrupt lock file {}: first line = '{}'", (Object)coreFile.getAbsolutePath(), (Object)firstLine);
                        e.printStackTrace();
                        n = Integer.MIN_VALUE;
                        if (reader == null) break block21;
                        if (throwable == null) break block22;
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block21;
                    }
                    reader.close();
                }
                return n;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private static File tmpDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        return tempDir;
    }

    static void updateCpu(int cpu) {
        if (!IS_LINUX) {
            return;
        }
        try {
            LockCheck.replacePid(LockCheck.toFile(cpu), LockCheck.getPID());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to update lock file for cpu " + cpu, (Throwable)e);
            e.printStackTrace();
        }
    }
}

