/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian;

import com.alipay.hessian.ClassNameFilter;
import com.alipay.hessian.clhm.ConcurrentLinkedHashMap;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public class NameBlackListFilter
implements ClassNameFilter {
    protected List<String> blackPrefixList;
    protected ConcurrentMap<String, Boolean> resultOfInBlackList;

    public NameBlackListFilter(List<String> blackPrefixList) {
        this(blackPrefixList, 8192);
    }

    public NameBlackListFilter(List<String> blackPrefixList, int maxCacheSize) {
        this.blackPrefixList = blackPrefixList;
        this.buildCache(maxCacheSize);
    }

    protected void buildCache(int maxCacheSize) {
        if (this.blackPrefixList != null && !this.blackPrefixList.isEmpty()) {
            int min = Math.min(256, maxCacheSize);
            int max = Math.min(10240, maxCacheSize);
            ConcurrentLinkedHashMap.Builder builder = new ConcurrentLinkedHashMap.Builder().initialCapacity(min).maximumWeightedCapacity(max);
            this.resultOfInBlackList = builder.build();
        } else {
            this.resultOfInBlackList = null;
        }
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public String resolve(String className) throws IOException {
        if (this.blackPrefixList == null || this.resultOfInBlackList == null) {
            return className;
        }
        Boolean result = (Boolean)this.resultOfInBlackList.get(className);
        if (result == null) {
            result = this.inBlackList(className);
            this.resultOfInBlackList.putIfAbsent(className, result);
        }
        if (result.booleanValue()) {
            throw new IOException("Class " + className + " is in blacklist. ");
        }
        return className;
    }

    private boolean inBlackList(String className) {
        for (String prefix : this.blackPrefixList) {
            if (!className.startsWith(prefix)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

