/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.rocketmq.streams.common.serializa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.streams.common.configurable.BasedConfigurable;

/**
 * Created by yuanxiaodong on 6/27/19.
 */
public class Person extends BasedConfigurable {
    protected String name;
    protected int age;
    private Boolean isMale;
    private List<String> addresses;
    private Map<String, Integer> childName2Age;
    protected Map<String, CountAccum> accums;

    public static Person createPerson(String namespace) {
        Person person = new Person();
//        person.setNameSpace(namespace);
//        person.setType("person");
//        person.setConfigureName("Chris");
        person.name = ("Chris");
        List<String> addresses = new ArrayList<>();
        addresses.add("huilongguan");
        addresses.add("shangdi");
        person.setAddresses(addresses);
        Map<String, Integer> childName2Age = new HashMap<>();
        childName2Age.put("yuanyahan", 8);
        childName2Age.put("yuanruoxi", 4);
        person.setChildName2Age(childName2Age);
        person.setMale(true);
        person.age = (18);
        person.accums = new HashMap<>();
        CountAccum count = new CountAccum();
        count.count = 1;
        person.setId(1222L);
        person.accums.put("count", count);
        return person;
    }

    @Override
    public String toString() {
        return "Person{" + "name='" + name + '\'' + ", age=" + age + ", isMale=" + isMale + ", addresses=" + addresses
            + ", childName2Age=" + childName2Age + '}';
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Map<String, CountAccum> getAccums() {
        return accums;
    }

    public void setAccums(Map<String, CountAccum> accums) {
        this.accums = accums;
    }

    public Boolean getMale() {
        return isMale;
    }

    public void setMale(Boolean male) {
        isMale = male;
    }

    public List<String> getAddresses() {
        return addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public Map<String, Integer> getChildName2Age() {
        return childName2Age;
    }

    public void setChildName2Age(Map<String, Integer> childName2Age) {
        this.childName2Age = childName2Age;
    }
}
