/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.xbean.blueprint.generator.ElementMapping;
import org.apache.xbean.blueprint.generator.Type;
import org.apache.xbean.blueprint.generator.Utils;

public class NamespaceMapping
implements Comparable {
    private final String namespace;
    private final Set elements;
    private final Map elementsByName;
    private final ElementMapping rootElement;
    private final HashMap checkedTypes = new HashMap();

    public NamespaceMapping(String namespace, Set elements, ElementMapping rootElement) {
        this.namespace = namespace;
        this.elements = Collections.unmodifiableSet(new TreeSet(elements));
        this.rootElement = rootElement;
        HashMap<String, ElementMapping> elementsByName = new HashMap<String, ElementMapping>();
        for (ElementMapping elementMapping : elements) {
            elementsByName.put(elementMapping.getElementName(), elementMapping);
        }
        this.elementsByName = Collections.unmodifiableMap(elementsByName);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Set getElements() {
        return this.elements;
    }

    public ElementMapping getElement(String elementName) {
        return (ElementMapping)this.elementsByName.get(elementName);
    }

    public ElementMapping getRootElement() {
        return this.rootElement;
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceMapping) {
            return this.namespace.equals(((NamespaceMapping)obj).namespace);
        }
        return false;
    }

    public int compareTo(Object obj) {
        return this.namespace.compareTo(((NamespaceMapping)obj).namespace);
    }

    public boolean isSimpleType(Type type) {
        Boolean b = (Boolean)this.checkedTypes.get(type);
        if (b == null) {
            b = Utils.isSimpleType(type) ? Boolean.TRUE : Boolean.FALSE;
            this.checkedTypes.put(type, b);
        }
        return b;
    }
}

