/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.leveldb.record;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.MessageBuffer;
import org.fusesource.hawtbuf.proto.MessageBufferSupport;
import org.fusesource.hawtbuf.proto.PBMessage;
import org.fusesource.hawtbuf.proto.PBMessageFactory;
import org.fusesource.hawtbuf.proto.PBMessageFramedCodec;
import org.fusesource.hawtbuf.proto.PBMessageUnframedCodec;

public class SubscriptionRecord
implements PBMessageFactory<Bean, Buffer> {
    public static final SubscriptionRecord FACTORY = new SubscriptionRecord();
    public static final PBMessageFramedCodec<Buffer> FRAMED_CODEC = new PBMessageFramedCodec<Buffer>(FACTORY);
    public static final PBMessageUnframedCodec<Buffer> UNFRAMED_CODEC = new PBMessageUnframedCodec<Buffer>(FACTORY);

    @Override
    public Bean create() {
        return new Bean();
    }

    @Override
    public Bean parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return new Bean().mergeUnframed(data);
    }

    @Override
    public Bean parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(new CodedInputStream(data));
    }

    @Override
    public Buffer parseUnframed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        return new Buffer(data);
    }

    @Override
    public Buffer parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseUnframed(new org.fusesource.hawtbuf.Buffer(data));
    }

    @Override
    public Buffer parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        int length = data.readRawVarint32();
        int oldLimit = data.pushLimit(length);
        Buffer rc = this.parseUnframed(data.readRawBytes(length));
        data.popLimit(oldLimit);
        return rc;
    }

    @Override
    public Buffer parseFramed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            Buffer rc = this.parseFramed(input);
            input.checkLastTagWas(0);
            return rc;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    @Override
    public Buffer parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseFramed(new org.fusesource.hawtbuf.Buffer(data));
    }

    @Override
    public Buffer parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(MessageBufferSupport.readFrame(data));
    }

    public static final class Buffer
    implements MessageBuffer<Bean, Buffer>,
    Getter {
        private Bean bean;
        private org.fusesource.hawtbuf.Buffer buffer;
        private int size = -1;
        private int hashCode;

        private Buffer(org.fusesource.hawtbuf.Buffer buffer) {
            this.buffer = buffer;
        }

        private Buffer(Bean bean) {
            this.bean = bean;
        }

        @Override
        public Bean copy() {
            return this.bean().copy();
        }

        @Override
        public Buffer freeze() {
            return this;
        }

        private Bean bean() {
            if (this.bean == null) {
                try {
                    this.bean = new Bean().mergeUnframed(new CodedInputStream(this.buffer));
                    this.bean.frozen = this;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
                }
            }
            return this.bean;
        }

        public String toString() {
            return this.bean().toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            return this.bean().toString(sb, prefix);
        }

        @Override
        public boolean hasTopicKey() {
            return this.bean().hasTopicKey();
        }

        @Override
        public long getTopicKey() {
            return this.bean().getTopicKey();
        }

        @Override
        public boolean hasClientId() {
            return this.bean().hasClientId();
        }

        @Override
        public String getClientId() {
            return this.bean().getClientId();
        }

        @Override
        public boolean hasSubscriptionName() {
            return this.bean().hasSubscriptionName();
        }

        @Override
        public String getSubscriptionName() {
            return this.bean().getSubscriptionName();
        }

        @Override
        public boolean hasSelector() {
            return this.bean().hasSelector();
        }

        @Override
        public String getSelector() {
            return this.bean().getSelector();
        }

        @Override
        public boolean hasDestinationName() {
            return this.bean().hasDestinationName();
        }

        @Override
        public String getDestinationName() {
            return this.bean().getDestinationName();
        }

        @Override
        public boolean hasSubscribedDestinationName() {
            return this.bean().hasSubscribedDestinationName();
        }

        @Override
        public String getSubscribedDestinationName() {
            return this.bean().getSubscribedDestinationName();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer toUnframedBuffer() {
            if (this.buffer != null) {
                return this.buffer;
            }
            return MessageBufferSupport.toUnframedBuffer(this);
        }

        @Override
        public org.fusesource.hawtbuf.Buffer toFramedBuffer() {
            return MessageBufferSupport.toFramedBuffer(this);
        }

        @Override
        public byte[] toUnframedByteArray() {
            return this.toUnframedBuffer().toByteArray();
        }

        @Override
        public byte[] toFramedByteArray() {
            return this.toFramedBuffer().toByteArray();
        }

        @Override
        public void writeFramed(CodedOutputStream output) throws IOException {
            output.writeRawVarint32(this.serializedSizeUnframed());
            this.writeUnframed(output);
        }

        @Override
        public void writeFramed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeFramed(codedOutput);
            codedOutput.flush();
        }

        @Override
        public void writeUnframed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeUnframed(codedOutput);
            codedOutput.flush();
        }

        @Override
        public void writeUnframed(CodedOutputStream output) throws IOException {
            if (this.buffer == null) {
                int size2 = this.serializedSizeUnframed();
                this.buffer = output.getNextBuffer(size2);
                CodedOutputStream original = null;
                if (this.buffer == null) {
                    this.buffer = new org.fusesource.hawtbuf.Buffer(new byte[size2]);
                    original = output;
                    output = new CodedOutputStream(this.buffer);
                }
                if (this.bean.hasTopicKey()) {
                    output.writeInt64(1, this.bean.getTopicKey());
                }
                if (this.bean.hasClientId()) {
                    output.writeString(2, this.bean.getClientId());
                }
                if (this.bean.hasSubscriptionName()) {
                    output.writeString(3, this.bean.getSubscriptionName());
                }
                if (this.bean.hasSelector()) {
                    output.writeString(4, this.bean.getSelector());
                }
                if (this.bean.hasDestinationName()) {
                    output.writeString(5, this.bean.getDestinationName());
                }
                if (this.bean.hasSubscribedDestinationName()) {
                    output.writeString(6, this.bean.getSubscribedDestinationName());
                }
                if (original != null) {
                    output.checkNoSpaceLeft();
                    output = original;
                    output.writeRawBytes(this.buffer);
                }
            } else {
                output.writeRawBytes(this.buffer);
            }
        }

        @Override
        public int serializedSizeFramed() {
            int t = this.serializedSizeUnframed();
            return CodedOutputStream.computeRawVarint32Size(t) + t;
        }

        @Override
        public int serializedSizeUnframed() {
            if (this.buffer != null) {
                return this.buffer.length;
            }
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            if (this.hasTopicKey()) {
                this.size += CodedOutputStream.computeInt64Size(1, this.getTopicKey());
            }
            if (this.hasClientId()) {
                this.size += CodedOutputStream.computeStringSize(2, this.getClientId());
            }
            if (this.hasSubscriptionName()) {
                this.size += CodedOutputStream.computeStringSize(3, this.getSubscriptionName());
            }
            if (this.hasSelector()) {
                this.size += CodedOutputStream.computeStringSize(4, this.getSelector());
            }
            if (this.hasDestinationName()) {
                this.size += CodedOutputStream.computeStringSize(5, this.getDestinationName());
            }
            if (this.hasSubscribedDestinationName()) {
                this.size += CodedOutputStream.computeStringSize(6, this.getSubscribedDestinationName());
            }
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Buffer.class) {
                return false;
            }
            return this.equals((Buffer)obj);
        }

        public boolean equals(Buffer obj) {
            return this.toUnframedBuffer().equals(obj.toUnframedBuffer());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 0x77408060 ^ this.toUnframedBuffer().hashCode();
            }
            return this.hashCode;
        }

        @Override
        public boolean frozen() {
            return true;
        }
    }

    public static final class Bean
    implements Getter {
        Buffer frozen;
        Bean bean;
        private long f_topicKey = 0L;
        private boolean b_topicKey;
        private String f_clientId = null;
        private String f_subscriptionName = null;
        private String f_selector = null;
        private String f_destinationName = null;
        private String f_subscribedDestinationName = null;

        public Bean() {
            this.bean = this;
        }

        public Bean(Bean copy) {
            this.bean = copy;
        }

        @Override
        public Bean copy() {
            return new Bean(this.bean);
        }

        @Override
        public boolean frozen() {
            return this.frozen != null;
        }

        @Override
        public Buffer freeze() {
            if (this.frozen == null) {
                this.frozen = new Buffer(this.bean);
                assert (this.deepFreeze());
            }
            return this.frozen;
        }

        private boolean deepFreeze() {
            this.frozen.serializedSizeUnframed();
            return true;
        }

        private void copyCheck() {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            if (this.bean != this) {
                this.copy(this.bean);
            }
        }

        private void copy(Bean other) {
            this.bean = this;
            this.f_topicKey = other.f_topicKey;
            this.b_topicKey = other.b_topicKey;
            this.f_clientId = other.f_clientId;
            this.f_subscriptionName = other.f_subscriptionName;
            this.f_selector = other.f_selector;
            this.f_destinationName = other.f_destinationName;
            this.f_subscribedDestinationName = other.f_subscribedDestinationName;
        }

        @Override
        public boolean hasTopicKey() {
            return this.bean.b_topicKey;
        }

        @Override
        public long getTopicKey() {
            return this.bean.f_topicKey;
        }

        public Bean setTopicKey(long topicKey) {
            this.copyCheck();
            this.b_topicKey = true;
            this.f_topicKey = topicKey;
            return this;
        }

        public void clearTopicKey() {
            this.copyCheck();
            this.b_topicKey = false;
            this.f_topicKey = 0L;
        }

        @Override
        public boolean hasClientId() {
            return this.bean.f_clientId != null;
        }

        @Override
        public String getClientId() {
            return this.bean.f_clientId;
        }

        public Bean setClientId(String clientId) {
            this.copyCheck();
            this.f_clientId = clientId;
            return this;
        }

        public void clearClientId() {
            this.copyCheck();
            this.f_clientId = null;
        }

        @Override
        public boolean hasSubscriptionName() {
            return this.bean.f_subscriptionName != null;
        }

        @Override
        public String getSubscriptionName() {
            return this.bean.f_subscriptionName;
        }

        public Bean setSubscriptionName(String subscriptionName) {
            this.copyCheck();
            this.f_subscriptionName = subscriptionName;
            return this;
        }

        public void clearSubscriptionName() {
            this.copyCheck();
            this.f_subscriptionName = null;
        }

        @Override
        public boolean hasSelector() {
            return this.bean.f_selector != null;
        }

        @Override
        public String getSelector() {
            return this.bean.f_selector;
        }

        public Bean setSelector(String selector) {
            this.copyCheck();
            this.f_selector = selector;
            return this;
        }

        public void clearSelector() {
            this.copyCheck();
            this.f_selector = null;
        }

        @Override
        public boolean hasDestinationName() {
            return this.bean.f_destinationName != null;
        }

        @Override
        public String getDestinationName() {
            return this.bean.f_destinationName;
        }

        public Bean setDestinationName(String destinationName) {
            this.copyCheck();
            this.f_destinationName = destinationName;
            return this;
        }

        public void clearDestinationName() {
            this.copyCheck();
            this.f_destinationName = null;
        }

        @Override
        public boolean hasSubscribedDestinationName() {
            return this.bean.f_subscribedDestinationName != null;
        }

        @Override
        public String getSubscribedDestinationName() {
            return this.bean.f_subscribedDestinationName;
        }

        public Bean setSubscribedDestinationName(String subscribedDestinationName) {
            this.copyCheck();
            this.f_subscribedDestinationName = subscribedDestinationName;
            return this;
        }

        public void clearSubscribedDestinationName() {
            this.copyCheck();
            this.f_subscribedDestinationName = null;
        }

        public String toString() {
            return this.toString(new StringBuilder(), "").toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            if (this.hasTopicKey()) {
                sb.append(prefix + "topic_key: ");
                sb.append(this.getTopicKey());
                sb.append("\n");
            }
            if (this.hasClientId()) {
                sb.append(prefix + "client_id: ");
                sb.append(this.getClientId());
                sb.append("\n");
            }
            if (this.hasSubscriptionName()) {
                sb.append(prefix + "subscription_name: ");
                sb.append(this.getSubscriptionName());
                sb.append("\n");
            }
            if (this.hasSelector()) {
                sb.append(prefix + "selector: ");
                sb.append(this.getSelector());
                sb.append("\n");
            }
            if (this.hasDestinationName()) {
                sb.append(prefix + "destination_name: ");
                sb.append(this.getDestinationName());
                sb.append("\n");
            }
            if (this.hasSubscribedDestinationName()) {
                sb.append(prefix + "subscribed_destination_name: ");
                sb.append(this.getSubscribedDestinationName());
                sb.append("\n");
            }
            return sb;
        }

        public Bean mergeUnframed(InputStream input) throws IOException {
            return this.mergeUnframed(new CodedInputStream(input));
        }

        public Bean mergeUnframed(CodedInputStream input) throws IOException {
            this.copyCheck();
            int tag;
            block9: while (((tag = input.readTag()) & 7) != 4) {
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        input.skipField(tag);
                        continue block9;
                    }
                    case 8: {
                        this.setTopicKey(input.readInt64());
                        continue block9;
                    }
                    case 18: {
                        this.setClientId(input.readString());
                        continue block9;
                    }
                    case 26: {
                        this.setSubscriptionName(input.readString());
                        continue block9;
                    }
                    case 34: {
                        this.setSelector(input.readString());
                        continue block9;
                    }
                    case 42: {
                        this.setDestinationName(input.readString());
                        continue block9;
                    }
                    case 50: 
                }
                this.setSubscribedDestinationName(input.readString());
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Bean.class) {
                return false;
            }
            return this.equals((Bean)obj);
        }

        public boolean equals(Bean obj) {
            if (this.hasTopicKey() ^ obj.hasTopicKey()) {
                return false;
            }
            if (this.hasTopicKey() && this.getTopicKey() != obj.getTopicKey()) {
                return false;
            }
            if (this.hasClientId() ^ obj.hasClientId()) {
                return false;
            }
            if (this.hasClientId() && !this.getClientId().equals(obj.getClientId())) {
                return false;
            }
            if (this.hasSubscriptionName() ^ obj.hasSubscriptionName()) {
                return false;
            }
            if (this.hasSubscriptionName() && !this.getSubscriptionName().equals(obj.getSubscriptionName())) {
                return false;
            }
            if (this.hasSelector() ^ obj.hasSelector()) {
                return false;
            }
            if (this.hasSelector() && !this.getSelector().equals(obj.getSelector())) {
                return false;
            }
            if (this.hasDestinationName() ^ obj.hasDestinationName()) {
                return false;
            }
            if (this.hasDestinationName() && !this.getDestinationName().equals(obj.getDestinationName())) {
                return false;
            }
            if (this.hasSubscribedDestinationName() ^ obj.hasSubscribedDestinationName()) {
                return false;
            }
            return !this.hasSubscribedDestinationName() || this.getSubscribedDestinationName().equals(obj.getSubscribedDestinationName());
        }

        public int hashCode() {
            int rc = 2066384;
            if (this.hasTopicKey()) {
                rc ^= 0xCACAFAD0 ^ new Long(this.getTopicKey()).hashCode();
            }
            if (this.hasClientId()) {
                rc ^= 0x39FF9A66 ^ this.getClientId().hashCode();
            }
            if (this.hasSubscriptionName()) {
                rc ^= 0xAF03B568 ^ this.getSubscriptionName().hashCode();
            }
            if (this.hasSelector()) {
                rc ^= 0x4AE057FF ^ this.getSelector().hashCode();
            }
            if (this.hasDestinationName()) {
                rc ^= 0x5B813399 ^ this.getDestinationName().hashCode();
            }
            if (this.hasSubscribedDestinationName()) {
                rc ^= 0xC8E247DF ^ this.getSubscribedDestinationName().hashCode();
            }
            return rc;
        }

        public Bean mergeFrom(Getter other) {
            this.copyCheck();
            if (other.hasTopicKey()) {
                this.setTopicKey(other.getTopicKey());
            }
            if (other.hasClientId()) {
                this.setClientId(other.getClientId());
            }
            if (other.hasSubscriptionName()) {
                this.setSubscriptionName(other.getSubscriptionName());
            }
            if (other.hasSelector()) {
                this.setSelector(other.getSelector());
            }
            if (other.hasDestinationName()) {
                this.setDestinationName(other.getDestinationName());
            }
            if (other.hasSubscribedDestinationName()) {
                this.setSubscribedDestinationName(other.getSubscribedDestinationName());
            }
            return this;
        }

        public void clear() {
            this.clearTopicKey();
            this.clearClientId();
            this.clearSubscriptionName();
            this.clearSelector();
            this.clearDestinationName();
            this.clearSubscribedDestinationName();
        }

        public void readExternal(DataInput in) throws IOException {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            this.bean = this;
            this.frozen = null;
            this.f_topicKey = in.readLong();
            this.b_topicKey = true;
            this.f_clientId = in.readBoolean() ? in.readUTF() : null;
            this.f_subscriptionName = in.readBoolean() ? in.readUTF() : null;
            this.f_selector = in.readBoolean() ? in.readUTF() : null;
            this.f_destinationName = in.readBoolean() ? in.readUTF() : null;
            this.f_subscribedDestinationName = in.readBoolean() ? in.readUTF() : null;
        }

        public void writeExternal(DataOutput out) throws IOException {
            out.writeLong(this.bean.f_topicKey);
            if (this.bean.f_clientId != null) {
                out.writeBoolean(true);
                out.writeUTF(this.bean.f_clientId);
            } else {
                out.writeBoolean(false);
            }
            if (this.bean.f_subscriptionName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.bean.f_subscriptionName);
            } else {
                out.writeBoolean(false);
            }
            if (this.bean.f_selector != null) {
                out.writeBoolean(true);
                out.writeUTF(this.bean.f_selector);
            } else {
                out.writeBoolean(false);
            }
            if (this.bean.f_destinationName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.bean.f_destinationName);
            } else {
                out.writeBoolean(false);
            }
            if (this.bean.f_subscribedDestinationName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.bean.f_subscribedDestinationName);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public static interface Getter
    extends PBMessage<Bean, Buffer> {
        public boolean hasTopicKey();

        public long getTopicKey();

        public boolean hasClientId();

        public String getClientId();

        public boolean hasSubscriptionName();

        public String getSubscriptionName();

        public boolean hasSelector();

        public String getSelector();

        public boolean hasDestinationName();

        public String getDestinationName();

        public boolean hasSubscribedDestinationName();

        public String getSubscribedDestinationName();

        @Override
        public Bean copy();

        @Override
        public Buffer freeze();

        public StringBuilder toString(StringBuilder var1, String var2);
    }
}

