/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class SymbolType
extends AbstractPrimitiveType<Symbol> {
    private static final Charset ASCII_CHARSET = Charset.forName("US-ASCII");
    private final SymbolEncoding _symbolEncoding;
    private final SymbolEncoding _shortSymbolEncoding;
    private final Map<ByteBuffer, Symbol> _symbolCache = new HashMap<ByteBuffer, Symbol>();
    private DecoderImpl.TypeDecoder<Symbol> _symbolCreator = new DecoderImpl.TypeDecoder<Symbol>(){

        @Override
        public Symbol decode(ByteBuffer buf) {
            Symbol symbol = (Symbol)SymbolType.this._symbolCache.get(buf);
            if (symbol == null) {
                byte[] bytes = new byte[buf.limit()];
                buf.get(bytes);
                String str = new String(bytes, ASCII_CHARSET);
                symbol = Symbol.getSymbol(str);
                SymbolType.this._symbolCache.put(ByteBuffer.wrap(bytes), symbol);
            }
            return symbol;
        }
    };

    SymbolType(EncoderImpl encoder, DecoderImpl decoder) {
        this._symbolEncoding = new LongSymbolEncoding(encoder, decoder);
        this._shortSymbolEncoding = new ShortSymbolEncoding(encoder, decoder);
        encoder.register(Symbol.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Symbol> getTypeClass() {
        return Symbol.class;
    }

    public SymbolEncoding getEncoding(Symbol val) {
        return val.length() <= 255 ? this._shortSymbolEncoding : this._symbolEncoding;
    }

    public SymbolEncoding getCanonicalEncoding() {
        return this._symbolEncoding;
    }

    @Override
    public Collection<SymbolEncoding> getAllEncodings() {
        return Arrays.asList(this._shortSymbolEncoding, this._symbolEncoding);
    }

    private class ShortSymbolEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<Symbol>
    implements SymbolEncoding {
        public ShortSymbolEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Symbol val) {
            int length = val.length();
            EncoderImpl encoder = this.getEncoder();
            for (int i = 0; i < length; ++i) {
                encoder.writeRaw((byte)val.charAt(i));
            }
        }

        @Override
        protected int getEncodedValueSize(Symbol val) {
            return val.length();
        }

        @Override
        public byte getEncodingCode() {
            return -93;
        }

        public SymbolType getType() {
            return SymbolType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Symbol> encoder) {
            return encoder == this;
        }

        @Override
        public Symbol readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size2 = decoder.readRawByte() & 0xFF;
            return (Symbol)decoder.readRaw(SymbolType.this._symbolCreator, size2);
        }
    }

    private class LongSymbolEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<Symbol>
    implements SymbolEncoding {
        public LongSymbolEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Symbol val) {
            int length = val.length();
            EncoderImpl encoder = this.getEncoder();
            for (int i = 0; i < length; ++i) {
                encoder.writeRaw((byte)val.charAt(i));
            }
        }

        @Override
        protected int getEncodedValueSize(Symbol val) {
            return val.length();
        }

        @Override
        public byte getEncodingCode() {
            return -77;
        }

        public SymbolType getType() {
            return SymbolType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Symbol> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Symbol readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size2 = decoder.readRawInt();
            return (Symbol)decoder.readRaw(SymbolType.this._symbolCreator, size2);
        }
    }

    public static interface SymbolEncoding
    extends PrimitiveTypeEncoding<Symbol> {
    }
}

