/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class LongElement
extends AtomicElement<Long> {
    private final long _value;

    LongElement(Element parent, Element prev, long l) {
        super(parent, prev);
        this._value = l;
    }

    @Override
    public int size() {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (-128L <= this._value && this._value <= 127L) {
                    return 1;
                }
                parent.setConstructorType(ArrayElement.LARGE);
            }
            return 8;
        }
        return -128L <= this._value && this._value <= 127L ? 2 : 9;
    }

    @Override
    public Long getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.LONG;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (size2 > b.remaining()) {
            return 0;
        }
        switch (size2) {
            case 2: {
                b.put((byte)85);
            }
            case 1: {
                b.put((byte)this._value);
                break;
            }
            case 9: {
                b.put((byte)-127);
            }
            case 8: {
                b.putLong(this._value);
            }
        }
        return size2;
    }
}

