/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine;

import java.util.IllegalFormatException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.TransportResult;

public class TransportResultFactory {
    private static final Logger LOGGER = Logger.getLogger(TransportResultFactory.class.getName());
    private static final TransportResult _okResult = new TransportResultImpl(TransportResult.Status.OK, null, null);

    public static TransportResult ok() {
        return _okResult;
    }

    public static TransportResult error(String format2, Object ... args) {
        String errorDescription;
        try {
            errorDescription = String.format(format2, args);
        }
        catch (IllegalFormatException e) {
            LOGGER.log(Level.SEVERE, "Formating error in string " + format2, e);
            errorDescription = format2;
        }
        return new TransportResultImpl(TransportResult.Status.ERROR, errorDescription, null);
    }

    public static TransportResult error(String errorDescription) {
        return new TransportResultImpl(TransportResult.Status.ERROR, errorDescription, null);
    }

    public static TransportResult error(Exception e) {
        return new TransportResultImpl(TransportResult.Status.ERROR, e == null ? null : e.toString(), e);
    }

    private static final class TransportResultImpl
    implements TransportResult {
        private final String _errorDescription;
        private final TransportResult.Status _status;
        private final Exception _exception;

        private TransportResultImpl(TransportResult.Status status2, String errorDescription, Exception exception) {
            this._status = status2;
            this._errorDescription = errorDescription;
            this._exception = exception;
        }

        @Override
        public boolean isOk() {
            return this._status == TransportResult.Status.OK;
        }

        @Override
        public TransportResult.Status getStatus() {
            return this._status;
        }

        @Override
        public String getErrorDescription() {
            return this._errorDescription;
        }

        @Override
        public Exception getException() {
            return this._exception;
        }

        @Override
        public void checkIsOk() {
            if (!this.isOk()) {
                Exception e = this.getException();
                if (e != null) {
                    throw new TransportException(e);
                }
                throw new TransportException(this.getErrorDescription());
            }
        }
    }
}

