/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.util.LinkedList;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;

public abstract class ServiceBase {
    public static final State CREATED = new State();
    public static final State STARTED = new State(){

        public boolean isStarted() {
            return true;
        }
    };
    public static final State STOPPED = new State();
    protected State _serviceState = CREATED;

    public final void start(Runnable onCompleted2) {
        this.start(new TaskWrapper(onCompleted2));
    }

    public final void start(final Task onCompleted2) {
        this.getDispatchQueue().execute(new Task(){

            public void run() {
                if (ServiceBase.this._serviceState == CREATED || ServiceBase.this._serviceState == STOPPED) {
                    final STARTING state = new STARTING();
                    state.add(onCompleted2);
                    ServiceBase.this._serviceState = state;
                    ServiceBase.this._start(new Task(){

                        public void run() {
                            ServiceBase.this._serviceState = STARTED;
                            state.done();
                        }
                    });
                } else if (ServiceBase.this._serviceState instanceof STARTING) {
                    ((STARTING)ServiceBase.this._serviceState).add(onCompleted2);
                } else if (ServiceBase.this._serviceState == STARTED) {
                    if (onCompleted2 != null) {
                        onCompleted2.run();
                    }
                } else {
                    if (onCompleted2 != null) {
                        onCompleted2.run();
                    }
                    ServiceBase.this.error("start should not be called from state: " + ServiceBase.this._serviceState);
                }
            }
        });
    }

    public final void stop(Runnable onCompleted2) {
        this.stop(new TaskWrapper(onCompleted2));
    }

    public final void stop(final Task onCompleted2) {
        this.getDispatchQueue().execute(new Task(){

            public void run() {
                if (ServiceBase.this._serviceState == STARTED) {
                    final STOPPING state = new STOPPING();
                    state.add(onCompleted2);
                    ServiceBase.this._serviceState = state;
                    ServiceBase.this._stop(new Task(){

                        public void run() {
                            ServiceBase.this._serviceState = STOPPED;
                            state.done();
                        }
                    });
                } else if (ServiceBase.this._serviceState instanceof STOPPING) {
                    ((STOPPING)ServiceBase.this._serviceState).add(onCompleted2);
                } else if (ServiceBase.this._serviceState == STOPPED) {
                    if (onCompleted2 != null) {
                        onCompleted2.run();
                    }
                } else {
                    if (onCompleted2 != null) {
                        onCompleted2.run();
                    }
                    ServiceBase.this.error("stop should not be called from state: " + ServiceBase.this._serviceState);
                }
            }
        });
    }

    private void error(String msg) {
        try {
            throw new AssertionError((Object)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected State getServiceState() {
        return this._serviceState;
    }

    protected abstract DispatchQueue getDispatchQueue();

    protected abstract void _start(Task var1);

    protected abstract void _stop(Task var1);

    public static class STOPPING
    extends CallbackSupport {
    }

    public static class STARTING
    extends CallbackSupport {
        public boolean isStarting() {
            return true;
        }
    }

    static class CallbackSupport
    extends State {
        LinkedList<Task> callbacks = new LinkedList();

        CallbackSupport() {
        }

        void add(Task r) {
            if (r != null) {
                this.callbacks.add(r);
            }
        }

        void done() {
            for (Task callback2 : this.callbacks) {
                callback2.run();
            }
        }
    }

    public static class State {
        public String toString() {
            return this.getClass().getSimpleName();
        }

        public boolean isStarted() {
            return false;
        }

        public boolean isStarting() {
            return false;
        }
    }
}

