/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.DbImpl;
import org.iq80.leveldb.util.FileUtils;

public class Iq80DBFactory
implements DBFactory {
    public static final int CPU_DATA_MODEL = Integer.getInteger("sun.arch.data.model");
    public static final boolean USE_MMAP = Boolean.parseBoolean(System.getProperty("leveldb.mmap", "" + (CPU_DATA_MODEL > 32)));
    public static final String VERSION;
    public static final Iq80DBFactory factory;

    @Override
    public DB open(File path, Options options) throws IOException {
        return new DbImpl(options, path);
    }

    @Override
    public void destroy(File path, Options options) throws IOException {
        FileUtils.deleteRecursively(path);
    }

    @Override
    public void repair(File path, Options options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("iq80 leveldb version %s", VERSION);
    }

    public static byte[] bytes(String value) {
        if (value == null) {
            return null;
        }
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String asString(byte[] value) {
        if (value == null) {
            return null;
        }
        try {
            return new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String v = "unknown";
        InputStream is = Iq80DBFactory.class.getResourceAsStream("version.txt");
        try {
            v = new BufferedReader(new InputStreamReader(is, "UTF-8")).readLine();
        }
        catch (Throwable e) {
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {}
        }
        VERSION = v;
        factory = new Iq80DBFactory();
    }
}

