/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.linkedin.util.annotations.Initializable;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.ClockUtils;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.concurrent.ConcurrentUtils;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.lang.LangUtils;
import org.linkedin.util.lifecycle.Destroyable;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKChildren;
import org.linkedin.zookeeper.client.ZKData;
import org.linkedin.zookeeper.tracker.ErrorListener;
import org.linkedin.zookeeper.tracker.NodeEvent;
import org.linkedin.zookeeper.tracker.NodeEventType;
import org.linkedin.zookeeper.tracker.NodeEventsListener;
import org.linkedin.zookeeper.tracker.TrackedNode;
import org.linkedin.zookeeper.tracker.ZKDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeperTreeTracker<T>
implements Destroyable {
    public static final String MODULE = ZooKeeperTreeTracker.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    @Initializable
    public Clock clock = SystemClock.INSTANCE;
    private final IZKClient _zk;
    private final ZKDataReader<T> _zkDataReader;
    private final String _root;
    private final int _depth;
    private final Set<ErrorListener> _errorListeners = new LinkedHashSet<ErrorListener>();
    private final Set<NodeEventsListener<T>> _eventsListeners = new LinkedHashSet<NodeEventsListener<T>>();
    private volatile Map<String, TrackedNode<T>> _tree = new LinkedHashMap<String, TrackedNode<T>>();
    private volatile boolean _destroyed = false;
    private long _lastZkTxId;
    private final Object _lock = new Object();
    private final int _rootDepth;
    private final Watcher _treeWacher = new TreeWatcher();

    public ZooKeeperTreeTracker(IZKClient zk, ZKDataReader<T> zkDataReader, String root) {
        this(zk, zkDataReader, root, Integer.MAX_VALUE);
    }

    public ZooKeeperTreeTracker(IZKClient zk, ZKDataReader<T> zkDataReader, String root, int depth) {
        this._zk = zk;
        this._zkDataReader = zkDataReader;
        this._root = root;
        this._rootDepth = ZooKeeperTreeTracker.computeAbsoluteDepth(this._root);
        this._depth = depth;
    }

    public static int computeAbsoluteDepth(String path) {
        if (path == null) {
            return 0;
        }
        int depth = 0;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c != '/') continue;
            ++depth;
        }
        return depth;
    }

    public String getRoot() {
        return this._root;
    }

    public IZKClient getZKCient() {
        return this._zk;
    }

    public int getDepth() {
        return this._depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastZkTxId() {
        Object object = this._lock;
        synchronized (object) {
            return this._lastZkTxId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForZkTxId(long zkTxId, Object timeout) throws TimeoutException, InterruptedException {
        long endTime = ClockUtils.toEndTime(this.clock, timeout);
        Object object = this._lock;
        synchronized (object) {
            while (this._lastZkTxId < zkTxId) {
                ConcurrentUtils.awaitUntil(this.clock, this._lock, endTime);
            }
            return this._lastZkTxId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this._lock;
        synchronized (object) {
            this._destroyed = true;
        }
    }

    public Map<String, TrackedNode<T>> getTree() {
        return this._tree;
    }

    public void track(NodeEventsListener<T> eventsListener) throws InterruptedException, KeeperException {
        this.registerListener(eventsListener);
        this.track();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track() throws InterruptedException, KeeperException {
        ArrayList<NodeEvent<T>> events = new ArrayList<NodeEvent<T>>();
        Object object = this._lock;
        synchronized (object) {
            this._tree = this.trackNode(this._root, new LinkedHashMap<String, TrackedNode<T>>(), events, 0);
        }
        this.raiseEvents(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(NodeEventsListener<T> eventsListener) {
        Object object = this._lock;
        synchronized (object) {
            this._eventsListeners.add(eventsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerErrorListener(ErrorListener errorListener) {
        Object object = this._lock;
        synchronized (object) {
            this._errorListeners.add(errorListener);
        }
    }

    private Map<String, TrackedNode<T>> trackNode(String path, Map<String, TrackedNode<T>> tree, Collection<NodeEvent<T>> events, int depth) throws InterruptedException, KeeperException {
        block12: {
            if (depth > this._depth) {
                if (log.isDebugEnabled()) {
                    log.debug(this.logString(path, "max depth reached ${depth}"));
                }
                return tree;
            }
            TrackedNode<T> oldTrackedNode = tree.get(path);
            try {
                ZKData<T> res = this._zkDataReader.readData(this._zk, path, this._treeWacher);
                TrackedNode<T> newTrackedNode = new TrackedNode<T>(path, res.getData(), res.getStat(), depth);
                if (oldTrackedNode != null) {
                    if (!this._zkDataReader.isEqual(oldTrackedNode.getData(), newTrackedNode.getData())) {
                        events.add(new NodeEvent<T>(NodeEventType.UPDATED, newTrackedNode));
                    }
                } else {
                    events.add(new NodeEvent<T>(NodeEventType.ADDED, newTrackedNode));
                }
                tree.put(path, newTrackedNode);
                if (depth < this._depth) {
                    ZKChildren children = this._zk.getZKChildren(path, this._treeWacher);
                    if (!newTrackedNode.getStat().equals((Object)children.getStat())) {
                        newTrackedNode.setStat(children.getStat());
                    }
                    Collections.sort(children.getChildren());
                    for (String child : children.getChildren()) {
                        String childPath = PathUtils.addPaths(path, child);
                        if (tree.containsKey(childPath)) continue;
                        this.trackNode(childPath, tree, events, depth + 1);
                    }
                }
                this._lastZkTxId = Math.max(this._lastZkTxId, newTrackedNode.getZkTxId());
                this._lock.notifyAll();
                if (log.isDebugEnabled()) {
                    log.debug(this.logString(path, "start tracking " + (depth < this._depth ? "" : "leaf ") + "node zkTxId=" + newTrackedNode.getZkTxId()));
                }
            }
            catch (KeeperException.NoNodeException e) {
                if (log.isDebugEnabled()) {
                    log.debug(this.logString(path, "no such node"));
                }
                tree.remove(path);
                if (oldTrackedNode == null) break block12;
                events.add(new NodeEvent<T>(NodeEventType.DELETED, oldTrackedNode));
            }
        }
        return tree;
    }

    private Map<String, TrackedNode<T>> handleNodeDeleted(String path, Collection<NodeEvent<T>> events) throws InterruptedException, KeeperException {
        Map<String, TrackedNode<T>> tree = this._tree;
        if (this._tree.containsKey(path)) {
            tree = new LinkedHashMap<String, TrackedNode<T>>(this._tree);
            TrackedNode<T> trackedNode = tree.remove(path);
            events.add(new NodeEvent<T>(NodeEventType.DELETED, trackedNode));
            if (log.isDebugEnabled()) {
                log.debug(this.logString(path, "stop tracking node"));
            }
            this.trackNode(path, tree, events, trackedNode.getDepth());
        }
        return tree;
    }

    private Map<String, TrackedNode<T>> handleNodeDataChanged(String path, Collection<NodeEvent<T>> events) throws InterruptedException, KeeperException {
        return this.trackNode(path, new LinkedHashMap<String, TrackedNode<T>>(this._tree), events, this.computeDepth(path));
    }

    private Map<String, TrackedNode<T>> handleNodeChildrenChanged(String path, Collection<NodeEvent<T>> events) throws InterruptedException, KeeperException {
        return this.trackNode(path, new LinkedHashMap<String, TrackedNode<T>>(this._tree), events, this.computeDepth(path));
    }

    private int computeDepth(String path) {
        return ZooKeeperTreeTracker.computeAbsoluteDepth(path) - this._rootDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseEvents(Collection<NodeEvent<T>> events) {
        if (!events.isEmpty()) {
            LinkedHashSet<NodeEventsListener<T>> listeners;
            Object object = this._lock;
            synchronized (object) {
                listeners = new LinkedHashSet<NodeEventsListener<T>>(this._eventsListeners);
            }
            for (NodeEventsListener nodeEventsListener : listeners) {
                nodeEventsListener.onEvents(events);
            }
        }
    }

    private boolean handleEvent(WatchedEvent event) {
        if (this._destroyed) {
            return false;
        }
        switch (event.getState()) {
            case SyncConnected: {
                return true;
            }
            case Disconnected: {
                return false;
            }
            case Expired: {
                return false;
            }
        }
        return false;
    }

    private String logString(String path, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(path).append("] ");
        sb.append("[").append(LangUtils.shortIdentityString(this)).append("] ");
        sb.append("[").append(Thread.currentThread()).append("] ");
        sb.append(msg);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseError(WatchedEvent event, Throwable th) {
        LinkedHashSet<ErrorListener> listeners;
        Object object = this._lock;
        synchronized (object) {
            listeners = new LinkedHashSet<ErrorListener>(this._errorListeners);
        }
        if (!listeners.isEmpty()) {
            for (ErrorListener listener : listeners) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug(this.logString(event.getPath(), "Raising error to " + LangUtils.identityString(listener)), th);
                    }
                    listener.onError(event, th);
                }
                catch (Throwable th2) {
                    log.warn(this.logString(event.getPath(), "Error in watcher while executing listener " + LangUtils.identityString(listener) + " (ignored)"), th2);
                }
            }
        }
    }

    private class TreeWatcher
    implements Watcher {
        private TreeWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (log.isDebugEnabled()) {
                log.debug(ZooKeeperTreeTracker.this.logString(event.getPath(), "treeWatcher: type=" + event.getType()) + ", state=" + event.getState());
            }
            ArrayList events = new ArrayList();
            try {
                Object object = ZooKeeperTreeTracker.this._lock;
                synchronized (object) {
                    if (!ZooKeeperTreeTracker.this.handleEvent(event)) {
                        return;
                    }
                    switch (event.getType()) {
                        case NodeDeleted: {
                            ZooKeeperTreeTracker.this._tree = ZooKeeperTreeTracker.this.handleNodeDeleted(event.getPath(), events);
                            break;
                        }
                        case NodeCreated: {
                            throw new RuntimeException("getting node created event ? when ?");
                        }
                        case NodeChildrenChanged: {
                            ZooKeeperTreeTracker.this._tree = ZooKeeperTreeTracker.this.handleNodeChildrenChanged(event.getPath(), events);
                            break;
                        }
                        case NodeDataChanged: {
                            ZooKeeperTreeTracker.this._tree = ZooKeeperTreeTracker.this.handleNodeDataChanged(event.getPath(), events);
                            break;
                        }
                    }
                }
                ZooKeeperTreeTracker.this.raiseEvents(events);
            }
            catch (Throwable th) {
                log.warn(ZooKeeperTreeTracker.this.logString(event.getPath(), "Error in treeWatcher (ignored)"), th);
                ZooKeeperTreeTracker.this.raiseError(event, th);
            }
        }
    }
}

