/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.BeanFactoryAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.util.Assert;

public class LazySingletonAspectInstanceFactoryDecorator
implements MetadataAwareAspectInstanceFactory {
    private final MetadataAwareAspectInstanceFactory maaif;
    private volatile Object materialized;

    public LazySingletonAspectInstanceFactoryDecorator(MetadataAwareAspectInstanceFactory maaif) {
        Assert.notNull((Object)maaif, (String)"AspectInstanceFactory must not be null");
        this.maaif = maaif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAspectInstance() {
        if (this.materialized == null) {
            Object mutex = this;
            if (this.maaif instanceof BeanFactoryAspectInstanceFactory) {
                mutex = ((BeanFactoryAspectInstanceFactory)this.maaif).getAspectCreationMutex();
            }
            if (mutex == null) {
                this.materialized = this.maaif.getAspectInstance();
            } else {
                LazySingletonAspectInstanceFactoryDecorator lazySingletonAspectInstanceFactoryDecorator = mutex;
                synchronized (lazySingletonAspectInstanceFactoryDecorator) {
                    if (this.materialized == null) {
                        this.materialized = this.maaif.getAspectInstance();
                    }
                }
            }
        }
        return this.materialized;
    }

    public boolean isMaterialized() {
        return this.materialized != null;
    }

    public ClassLoader getAspectClassLoader() {
        return this.maaif.getAspectClassLoader();
    }

    public AspectMetadata getAspectMetadata() {
        return this.maaif.getAspectMetadata();
    }

    public int getOrder() {
        return this.maaif.getOrder();
    }

    public String toString() {
        return "LazySingletonAspectInstanceFactoryDecorator: decorating " + this.maaif;
    }
}

