/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;

@Deprecated
public class HtmlResponse {
    public static final String PN_TITLE = "title";
    public static final String PN_STATUS_CODE = "status.code";
    public static final String PN_STATUS_MESSAGE = "status.message";
    public static final String PN_LOCATION = "location";
    public static final String PN_PARENT_LOCATION = "parentLocation";
    public static final String PN_PATH = "path";
    public static final String PN_REFERER = "referer";
    public static final String PN_IS_CREATED = "isCreate";
    public static final String PN_CHANGE_LOG = "changeLog";
    public static final String PN_ERROR = "error";
    private static final String TEMPLATE_NAME = "HtmlResponse.html";
    private final StringBuilder changes = new StringBuilder();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public HtmlResponse() {
        this.setCreateRequest(false);
    }

    public String getReferer() {
        return this.getProperty(PN_REFERER, String.class);
    }

    public void setReferer(String referer) {
        this.setProperty(PN_REFERER, referer);
    }

    public String getPath() {
        return this.getProperty(PN_PATH, String.class);
    }

    public void setPath(String path) {
        this.setProperty(PN_PATH, path);
    }

    public boolean isCreateRequest() {
        return this.getProperty(PN_IS_CREATED, Boolean.class);
    }

    public void setCreateRequest(boolean isCreateRequest) {
        this.setProperty(PN_IS_CREATED, isCreateRequest);
    }

    public String getLocation() {
        return this.getProperty(PN_LOCATION, String.class);
    }

    public void setLocation(String location) {
        this.setProperty(PN_LOCATION, location);
    }

    public String getParentLocation() {
        return this.getProperty(PN_PARENT_LOCATION, String.class);
    }

    public void setParentLocation(String parentLocation) {
        this.setProperty(PN_PARENT_LOCATION, parentLocation);
    }

    public void setTitle(String title) {
        this.setProperty(PN_TITLE, title);
    }

    public void setStatus(int code, String message) {
        this.setProperty(PN_STATUS_CODE, code);
        this.setProperty(PN_STATUS_MESSAGE, message);
    }

    public int getStatusCode() {
        Integer status = this.getProperty(PN_STATUS_CODE, Integer.class);
        if (status == null) {
            status = this.getError() != null ? Integer.valueOf(500) : Integer.valueOf(200);
        }
        return status;
    }

    public String getStatusMessage() {
        return this.getProperty(PN_STATUS_MESSAGE, String.class);
    }

    public Throwable getError() {
        return this.getProperty(PN_ERROR, Throwable.class);
    }

    public void setError(Throwable error) {
        this.setProperty(PN_ERROR, error);
    }

    public boolean isSuccessful() {
        return this.getError() == null && this.getStatusCode() / 100 == 2;
    }

    public void onModified(String path) {
        this.onChange("modified", path);
    }

    public void onCreated(String path) {
        this.onChange("created", path);
    }

    public void onDeleted(String path) {
        if (path != null) {
            this.onChange("deleted", path);
        }
    }

    public void onMoved(String srcPath, String dstPath) {
        this.onChange("moved", srcPath, dstPath);
    }

    public void onCopied(String srcPath, String dstPath) {
        this.onChange("copied", srcPath, dstPath);
    }

    public void onChange(String type, String ... arguments) {
        this.changes.append(type);
        String delim = "(";
        for (String a : arguments) {
            this.changes.append(delim);
            this.changes.append('\"');
            this.changes.append(a);
            this.changes.append('\"');
            delim = ", ";
        }
        this.changes.append(");<br/>");
    }

    private void prepare() {
        String referer;
        String path = this.getPath();
        if (this.getProperty(PN_STATUS_CODE) == null) {
            if (this.getError() != null) {
                this.setStatus(500, this.getError().toString());
                this.setTitle("Error while processing " + path);
            } else if (this.isCreateRequest()) {
                this.setStatus(201, "Created");
                this.setTitle("Content created " + path);
            } else {
                this.setStatus(200, "OK");
                this.setTitle("Content modified " + path);
            }
        }
        if ((referer = this.getReferer()) == null) {
            referer = "";
        }
        this.setReferer(referer);
        this.changes.insert(0, "<pre>");
        this.changes.append("</pre>");
        this.setProperty(PN_CHANGE_LOG, this.changes.toString());
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public <Type> Type getProperty(String name, Class<Type> type) {
        Object value = this.getProperty(name);
        if (type.isInstance(value)) {
            return (Type)value;
        }
        return null;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void send(HttpServletResponse response, boolean setStatus) throws IOException {
        int read;
        Object status;
        this.prepare();
        if (setStatus && (status = this.getProperty(PN_STATUS_CODE)) instanceof Number) {
            int statusCode = ((Number)status).intValue();
            response.setStatus(statusCode);
            if (statusCode == 201) {
                response.setHeader("Location", this.getLocation());
            }
        }
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        InputStream template = this.getClass().getResourceAsStream(TEMPLATE_NAME);
        BufferedReader in = new BufferedReader(new InputStreamReader(template));
        StringBuffer varBuffer = new StringBuffer();
        int state = 0;
        while ((read = ((Reader)in).read()) >= 0) {
            char c = (char)read;
            switch (state) {
                case 0: {
                    if (c == '$') {
                        state = 1;
                        break;
                    }
                    ((Writer)out).write(c);
                    break;
                }
                case 1: {
                    if (c == '{') {
                        state = 2;
                        break;
                    }
                    state = 0;
                    ((Writer)out).write(36);
                    ((Writer)out).write(c);
                    break;
                }
                case 2: {
                    if (c == '}') {
                        state = 0;
                        Object prop = this.properties.get(varBuffer.toString());
                        if (prop != null) {
                            ((Writer)out).write(ResponseUtil.escapeXml(prop.toString()));
                        }
                        varBuffer.setLength(0);
                        break;
                    }
                    varBuffer.append(c);
                }
            }
        }
        ((Reader)in).close();
        ((Writer)out).flush();
    }
}

