/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.wrappers.IteratorWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class ResourceResolverWrapper
implements ResourceResolver {
    private ResourceResolver wrapped;

    public ResourceResolverWrapper(ResourceResolver resolver) {
        this.wrapped = resolver;
    }

    @Override
    @NotNull
    public Resource resolve(@NotNull HttpServletRequest request, @NotNull String absPath) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.resolve(request, absPath));
    }

    @Override
    @Deprecated
    @NotNull
    public Resource resolve(@NotNull javax.servlet.http.HttpServletRequest request, @NotNull String absPath) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.resolve(request, absPath));
    }

    @Override
    @NotNull
    public Resource resolve(@NotNull String absPath) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.resolve(absPath));
    }

    @Override
    @NotNull
    public Resource resolve(@NotNull javax.servlet.http.HttpServletRequest request) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.resolve(request));
    }

    @Override
    @NotNull
    public String map(@NotNull String resourcePath) {
        return this.wrapped.map(resourcePath);
    }

    @Override
    public String map(@NotNull HttpServletRequest request, @NotNull String resourcePath) {
        return this.wrapped.map(request, resourcePath);
    }

    @Override
    @Deprecated
    public String map(@NotNull javax.servlet.http.HttpServletRequest request, @NotNull String resourcePath) {
        return this.wrapped.map(request, resourcePath);
    }

    @Override
    public Resource getResource(@NotNull String path) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.getResource(path));
    }

    @Override
    public Resource getResource(Resource base, @NotNull String path) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.getResource(base, path));
    }

    @Override
    @NotNull
    public String[] getSearchPath() {
        return this.wrapped.getSearchPath();
    }

    @Override
    @NotNull
    public Iterator<Resource> listChildren(@NotNull Resource parent) {
        return new ResourceIteratorWrapper(this, this.wrapped.listChildren(parent));
    }

    @Override
    public Resource getParent(@NotNull Resource child) {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.getParent(child));
    }

    @Override
    @NotNull
    public Iterable<Resource> getChildren(final @NotNull Resource parent) {
        final ResourceResolverWrapper resourceResolverWrapper = this;
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return new ResourceIteratorWrapper(resourceResolverWrapper, ResourceResolverWrapper.this.wrapped.getChildren(parent).iterator());
            }
        };
    }

    @Override
    @NotNull
    public Iterator<Resource> findResources(@NotNull String query, String language) {
        return new ResourceIteratorWrapper(this, this.wrapped.findResources(query, language));
    }

    @Override
    @NotNull
    public Iterator<Map<String, Object>> queryResources(@NotNull String query, String language) {
        return this.wrapped.queryResources(query, language);
    }

    @Override
    public boolean hasChildren(@NotNull Resource resource) {
        return this.wrapped.hasChildren(resource);
    }

    @Override
    @NotNull
    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        ResourceResolver toWrap = this.wrapped.clone(authenticationInfo);
        return new ResourceResolverWrapper(toWrap);
    }

    @Override
    public boolean isLive() {
        return this.wrapped.isLive();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @Override
    public String getUserID() {
        return this.wrapped.getUserID();
    }

    @Override
    @NotNull
    public Iterator<String> getAttributeNames() {
        return this.wrapped.getAttributeNames();
    }

    @Override
    public Object getAttribute(@NotNull String name) {
        return this.wrapped.getAttribute(name);
    }

    @Override
    public void delete(@NotNull Resource resource) throws PersistenceException {
        this.wrapped.delete(resource);
    }

    @Override
    @NotNull
    public Resource create(@NotNull Resource parent, @NotNull String name, Map<String, Object> properties) throws PersistenceException {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.create(parent, name, properties));
    }

    @Override
    public boolean orderBefore(@NotNull Resource parent, @NotNull String name, @Nullable String followingSiblingName) throws UnsupportedOperationException, PersistenceException, IllegalArgumentException {
        return this.wrapped.orderBefore(parent, name, followingSiblingName);
    }

    @Override
    public void revert() {
        this.wrapped.revert();
    }

    @Override
    public void commit() throws PersistenceException {
        this.wrapped.commit();
    }

    @Override
    public boolean hasChanges() {
        return this.wrapped.hasChanges();
    }

    @Override
    public String getParentResourceType(Resource resource) {
        return this.wrapped.getParentResourceType(resource);
    }

    @Override
    public String getParentResourceType(String resourceType) {
        return this.wrapped.getParentResourceType(resourceType);
    }

    @Override
    public boolean isResourceType(Resource resource, String resourceType) {
        return this.wrapped.isResourceType(resource, resourceType);
    }

    @Override
    public void refresh() {
        this.wrapped.refresh();
    }

    @Override
    public Resource copy(String srcAbsPath, String destAbsPath) throws PersistenceException {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.copy(srcAbsPath, destAbsPath));
    }

    @Override
    public Resource move(String srcAbsPath, String destAbsPath) throws PersistenceException {
        return ResourceResolverResourceWrapper.wrap(this, this.wrapped.move(srcAbsPath, destAbsPath));
    }

    @Override
    public Map<String, Object> getPropertyMap() {
        return this.wrapped.getPropertyMap();
    }

    @Override
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        return this.wrapped.adaptTo(type);
    }

    private static class ResourceResolverResourceWrapper
    extends ResourceWrapper {
        private final ResourceResolverWrapper resolver;

        ResourceResolverResourceWrapper(ResourceResolverWrapper resolver, Resource resource) {
            super(resource);
            this.resolver = resolver;
        }

        @Override
        public ResourceResolver getResourceResolver() {
            return this.resolver;
        }

        private static Resource wrap(ResourceResolverWrapper resolver, Resource resource) {
            if (resource != null) {
                return new ResourceResolverResourceWrapper(resolver, resource);
            }
            return null;
        }
    }

    private static class ResourceIteratorWrapper
    extends IteratorWrapper<Resource> {
        private final ResourceResolverWrapper resolver;

        public ResourceIteratorWrapper(ResourceResolverWrapper resolver, Iterator<Resource> wrappedIterator) {
            super(wrappedIterator);
            this.resolver = resolver;
        }

        @Override
        public Resource next() {
            return ResourceResolverResourceWrapper.wrap(this.resolver, (Resource)super.next());
        }
    }
}

