/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.net.URI;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OidcProviderMetadataRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
@Designate(ocd=Config.class, factory=true)
public class OidcConnectionImpl
implements ClientConnection {
    private final Config cfg;
    private final OidcProviderMetadataRegistry metadataRegistry;

    @Activate
    public OidcConnectionImpl(Config cfg, @Reference OidcProviderMetadataRegistry metadataRegistry) {
        this.cfg = cfg;
        this.metadataRegistry = metadataRegistry;
    }

    @Override
    @NotNull
    public String name() {
        return this.cfg.name();
    }

    @NotNull
    public String authorizationEndpoint() {
        return this.metadataRegistry.getAuthorizationEndpoint(this.cfg.baseUrl()).toString();
    }

    @NotNull
    public String tokenEndpoint() {
        return this.metadataRegistry.getTokenEndpoint(this.cfg.baseUrl()).toString();
    }

    @NotNull
    public String clientId() {
        return this.cfg.clientId();
    }

    @Nullable
    public String clientSecret() {
        return this.cfg.clientSecret();
    }

    @NotNull
    public String[] scopes() {
        return this.cfg.scopes();
    }

    @NotNull
    public String[] additionalAuthorizationParameters() {
        return this.cfg.additionalAuthorizationParameters();
    }

    @Nullable
    String baseUrl() {
        return this.cfg.baseUrl();
    }

    @NotNull
    String userInfoUrl() {
        return this.metadataRegistry.getUserInfoEndpoint(this.cfg.baseUrl()).toString();
    }

    @NotNull
    URI jwkSetURL() {
        return this.metadataRegistry.getJWKSetURI(this.cfg.baseUrl());
    }

    @NotNull
    String issuer() {
        return this.metadataRegistry.getIssuer(this.cfg.baseUrl());
    }

    @ObjectClassDefinition(name="OpenID Connect connection details")
    public static @interface Config {
        public String name();

        public String baseUrl();

        public String clientId();

        @AttributeDefinition(type=AttributeType.PASSWORD)
        public String clientSecret();

        public String[] scopes();

        public String[] additionalAuthorizationParameters();

        public String webconsole_configurationFactory_nameHint() default "Name: {name}, base URL: {baseUrl}, clientId: {clientId}";
    }
}

