/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import java.util.List;
import java.util.function.Supplier;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.apache.sling.commons.log.logback.internal.util.SlingContextUtil;
import org.jetbrains.annotations.NotNull;

class LevelChangePropagatorChecker
implements LogbackResetListener {
    private Supplier<Boolean> isBridgeInstalledSupplier;

    LevelChangePropagatorChecker(@NotNull Supplier<Boolean> isBridgeInstalledSupplier) {
        this.isBridgeInstalledSupplier = isBridgeInstalledSupplier;
    }

    @Override
    public void onResetComplete(@NotNull LoggerContext context) {
        List listenerList = context.getCopyOfListenerList();
        boolean levelChangePropagatorInstalled = listenerList.stream().anyMatch(LevelChangePropagator.class::isInstance);
        if (!levelChangePropagatorInstalled && Boolean.TRUE.equals(this.isBridgeInstalledSupplier.get())) {
            LevelChangePropagator levelChangePropagator = new LevelChangePropagator();
            levelChangePropagator.setContext((Context)context);
            levelChangePropagator.start();
            context.addListener((LoggerContextListener)levelChangePropagator);
            SlingContextUtil c = new SlingContextUtil((Context)context, this);
            c.addInfo("Slf4j bridge handler found to be enabled. Installing the LevelChangePropagator");
        }
    }
}

