/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.integration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.sling.commons.testing.integration.NameValuePair;

public class NameValuePairList
implements Iterable<NameValuePair> {
    private final List<NameValuePair> delegate;

    public NameValuePairList() {
        this.delegate = new ArrayList<NameValuePair>();
    }

    public NameValuePairList(List<NameValuePair> init) {
        this.delegate = new ArrayList<NameValuePair>(init);
    }

    public NameValuePairList(NameValuePairList clientNodeProperties) {
        this(clientNodeProperties.delegate);
    }

    public NameValuePairList(Map<String, String> clientNodeProperties) {
        this();
        if (clientNodeProperties != null) {
            for (Map.Entry<String, String> e : clientNodeProperties.entrySet()) {
                this.add(e.getKey(), e.getValue());
            }
        }
    }

    public void add(String name, String value) {
        this.delegate.add(new NameValuePair(name, value));
    }

    public void addIfNew(String name, String value) {
        boolean found = false;
        ListIterator<NameValuePair> li = this.delegate.listIterator();
        while (li.hasNext()) {
            NameValuePair current = li.next();
            if (!current.getName().equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.delegate.add(new NameValuePair(name, value));
        }
    }

    public void addOrReplace(String name, String value) {
        boolean replaced = false;
        ListIterator<NameValuePair> li = this.delegate.listIterator();
        while (li.hasNext()) {
            NameValuePair current = li.next();
            if (!current.getName().equals(name)) continue;
            if (!replaced) {
                current.setValue(value);
                replaced = true;
                continue;
            }
            li.remove();
        }
        if (!replaced) {
            this.delegate.add(new NameValuePair(name, value));
        }
    }

    public void addOrReplaceAll(NameValuePairList other) {
        for (NameValuePair nvp : other) {
            this.addOrReplace(nvp.getName(), nvp.getValue());
        }
    }

    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.delegate.iterator();
    }

    public void prependIfNew(String name, String value) {
        boolean found = false;
        ListIterator<NameValuePair> li = this.delegate.listIterator();
        while (li.hasNext()) {
            NameValuePair current = li.next();
            if (!current.getName().equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.delegate.add(0, new NameValuePair(name, value));
        }
    }

    public int size() {
        return this.delegate.size();
    }
}

