/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.util.HashSet;
import java.util.Set;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.Descriptor;
import org.apache.sling.cta.impl.AgentInfo;
import org.apache.sling.cta.impl.MBeanAwareTimeoutTransformer;

class JdkHttpClientBuilderTimeoutTransformer
extends MBeanAwareTimeoutTransformer {
    static final Set<String> CLASSES_TO_TRANSFORM = new HashSet<String>();
    private final long connectTimeoutMillis;

    public JdkHttpClientBuilderTimeoutTransformer(long connectTimeout, AgentInfo agentInfo) {
        super(agentInfo, CLASSES_TO_TRANSFORM);
        this.connectTimeoutMillis = connectTimeout;
    }

    @Override
    protected byte[] doTransformClass(CtClass cc) throws Exception {
        CtMethod buildMethod = cc.getDeclaredMethod("build");
        buildMethod.insertBefore("if ( this.connectTimeout == null ) { connectTimeout(java.time.Duration.ofMillis(" + this.connectTimeoutMillis + "L)); }");
        byte[] classfileBuffer = buildMethod.getDeclaringClass().toBytecode();
        buildMethod.getDeclaringClass().detach();
        return classfileBuffer;
    }

    static {
        CLASSES_TO_TRANSFORM.add(Descriptor.toJvmName((String)"jdk.internal.net.http.HttpClientBuilderImpl"));
    }
}

