/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;

public class LocalClusterView
extends DefaultClusterView {
    private final String localClusterSyncTokenId;
    private Set<Integer> partiallyStartedClusterNodeIds;

    public LocalClusterView(String id, String localClusterSyncTokenId) {
        super(id);
        this.localClusterSyncTokenId = localClusterSyncTokenId;
    }

    public String getLocalClusterSyncTokenId() {
        return this.localClusterSyncTokenId;
    }

    public Set<Integer> getPartiallyStartedClusterNodeIds() {
        return Collections.unmodifiableSet(this.partiallyStartedClusterNodeIds);
    }

    public void setPartiallyStartedClusterNodeIds(Collection<Integer> clusterNodeIds) {
        this.partiallyStartedClusterNodeIds = new HashSet<Integer>(clusterNodeIds);
    }

    public boolean isPartiallyStarted(Integer clusterNodeId) {
        if (this.partiallyStartedClusterNodeIds == null || clusterNodeId == null) {
            return false;
        }
        return this.partiallyStartedClusterNodeIds.contains(clusterNodeId);
    }

    public boolean hasPartiallyStartedInstances() {
        if (this.partiallyStartedClusterNodeIds == null) {
            return false;
        }
        return !this.partiallyStartedClusterNodeIds.isEmpty();
    }
}

