/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequestState;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgentAuthenticationInfo;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.impl.SimpleDistributionResponse;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageProcessor;
import org.apache.sling.distribution.util.impl.DistributionUtils;

class ImportingDistributionPackageProcessor
implements DistributionPackageProcessor {
    private final DistributionPackageImporter distributionPackageImporter;
    private final SimpleDistributionAgentAuthenticationInfo authenticationInfo;
    private final String callingUser;
    private final String requestId;
    private final DefaultDistributionLog log;
    private final AtomicInteger packagesCount = new AtomicInteger();
    private final AtomicLong packagesSize = new AtomicLong();
    private final List<DistributionResponse> allResponses = new LinkedList<DistributionResponse>();

    public ImportingDistributionPackageProcessor(DistributionPackageImporter distributionPackageImporter, SimpleDistributionAgentAuthenticationInfo authenticationInfo, String callingUser, String requestId, DefaultDistributionLog log) {
        this.distributionPackageImporter = distributionPackageImporter;
        this.authenticationInfo = authenticationInfo;
        this.callingUser = callingUser;
        this.requestId = requestId;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DistributionPackage distributionPackage) {
        long startTime = System.currentTimeMillis();
        ResourceResolver agentResourceResolver = null;
        try {
            agentResourceResolver = DistributionUtils.getResourceResolver(this.callingUser, this.authenticationInfo.getAgentService(), this.authenticationInfo.getSlingRepository(), this.authenticationInfo.getSubServiceName(), this.authenticationInfo.getResourceResolverFactory());
            this.distributionPackageImporter.importPackage(agentResourceResolver, distributionPackage);
            this.packagesSize.addAndGet(distributionPackage.getSize());
            this.packagesCount.incrementAndGet();
            SimpleDistributionResponse response = new SimpleDistributionResponse(DistributionRequestState.ACCEPTED, "package imported");
            this.allResponses.add(response);
            long endTime = System.currentTimeMillis();
            this.log.debug("PACKAGE-IMPORTED {}: packageId={}, paths={}, responses={}", this.requestId, distributionPackage.getId(), distributionPackage.getInfo().getPaths(), endTime - startTime, response);
        }
        catch (DistributionException e) {
            try {
                this.log.error("an error happened during package import", e);
                this.allResponses.add(new SimpleDistributionResponse(DistributionRequestState.DROPPED, e.toString()));
            }
            catch (Throwable throwable) {
                DistributionUtils.ungetResourceResolver(agentResourceResolver);
                throw throwable;
            }
            DistributionUtils.ungetResourceResolver(agentResourceResolver);
        }
        DistributionUtils.ungetResourceResolver(agentResourceResolver);
    }

    @Override
    public List<DistributionResponse> getAllResponses() {
        return this.allResponses;
    }

    @Override
    public int getPackagesCount() {
        return this.packagesCount.get();
    }

    @Override
    public long getPackagesSize() {
        return this.packagesSize.get();
    }
}

