/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.serialization.impl.vlt.VltUtils;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.AbstractJcrEventTrigger;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrEventDistributionTrigger
extends AbstractJcrEventTrigger
implements DistributionTrigger {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean deep;
    private final String[] ignoredPathsPatterns;

    public JcrEventDistributionTrigger(SlingRepository repository, Scheduler scheduler, ResourceResolverFactory resolverFactory, String path, boolean deep, String serviceName, String[] ignoredPathsPatterns) {
        super(repository, scheduler, resolverFactory, path, serviceName);
        this.deep = deep;
        this.ignoredPathsPatterns = ignoredPathsPatterns;
    }

    @Override
    protected DistributionRequest processEvent(Event event) throws RepositoryException {
        SimpleDistributionRequest distributionRequest = null;
        String eventPath = event.getPath();
        String replicatingPath = this.getNodePathFromEvent(event);
        if (!this.isIgnoredPath(replicatingPath)) {
            if (VltUtils.findParent(replicatingPath, "rep:policy") != null) {
                replicatingPath = VltUtils.findParent(replicatingPath, "rep:policy") + "/rep:policy";
                distributionRequest = new SimpleDistributionRequest(DistributionRequestType.ADD, new String[]{replicatingPath});
            } else if (VltUtils.findParent(replicatingPath, "rep:membersList") != null || eventPath.endsWith("/rep:members")) {
                String groupPath = VltUtils.findParent(replicatingPath, "rep:membersList");
                if (groupPath != null) {
                    replicatingPath = groupPath;
                }
                distributionRequest = new SimpleDistributionRequest(DistributionRequestType.ADD, true, new String[]{replicatingPath});
            } else {
                distributionRequest = new SimpleDistributionRequest(2 == event.getType() ? DistributionRequestType.DELETE : DistributionRequestType.ADD, this.deep, new String[]{replicatingPath});
            }
            this.log.info("distributing {}", (Object)distributionRequest);
        }
        return distributionRequest;
    }

    private boolean isIgnoredPath(String path) {
        if (path == null) {
            return true;
        }
        if (this.ignoredPathsPatterns == null || this.ignoredPathsPatterns.length == 0) {
            return false;
        }
        for (String pattern : this.ignoredPathsPatterns) {
            if (!path.matches(pattern)) continue;
            this.log.debug("path {} ignored", (Object)path);
            return true;
        }
        return false;
    }
}

