/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.osgi.framework.ServiceReference;

public class SlingFilterConfig
implements FilterConfig {
    private static final String[] NAME_PROPERTIES = new String[]{"sling.core.servletName", "component.name", "service.pid", "service.id"};
    private ServletContext servletContext;
    private ServiceReference<Filter> reference;
    private String name;

    public SlingFilterConfig(ServletContext servletContext, ServiceReference<Filter> reference, String filterName) {
        this.servletContext = servletContext;
        this.reference = reference;
        this.name = filterName;
    }

    public String getInitParameter(String name) {
        Object prop = this.reference.getProperty(name);
        return prop == null ? null : String.valueOf(prop);
    }

    public Enumeration<String> getInitParameterNames() {
        List<String> keys = Arrays.asList(this.reference.getPropertyKeys());
        return Collections.enumeration(keys);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public static String getName(ServiceReference<Filter> reference) {
        String servletName = null;
        for (int i = 0; i < NAME_PROPERTIES.length && (servletName == null || servletName.length() == 0); ++i) {
            Object prop = reference.getProperty(NAME_PROPERTIES[i]);
            if (prop == null) continue;
            servletName = String.valueOf(prop);
        }
        return servletName;
    }

    public String getFilterName() {
        return this.name;
    }
}

