/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.sling.engine.impl.parameters.AbstractRequestParameter;

public class MultipartRequestParameter
extends AbstractRequestParameter {
    private final DiskFileItem delegatee;
    private String encodedFileName;
    private String cachedValue;

    public MultipartRequestParameter(DiskFileItem delegatee) {
        super(delegatee.getFieldName(), null);
        this.delegatee = delegatee;
    }

    void dispose() throws IOException {
        this.delegatee.delete();
    }

    DiskFileItem getFileItem() {
        return this.delegatee;
    }

    @Override
    void setEncoding(String encoding) {
        super.setEncoding(encoding);
        this.cachedValue = null;
    }

    public byte[] get() {
        return this.delegatee.get();
    }

    public String getContentType() {
        return this.delegatee.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegatee.getInputStream();
    }

    public String getFileName() {
        if (this.encodedFileName == null && this.delegatee.getName() != null) {
            String tmpFileName = this.delegatee.getName();
            if (this.getEncoding() != null) {
                try {
                    byte[] rawName = tmpFileName.getBytes("ISO-8859-1");
                    tmpFileName = new String(rawName, this.getEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.encodedFileName = tmpFileName;
        }
        return this.encodedFileName;
    }

    public long getSize() {
        return this.delegatee.getSize();
    }

    public String getString() {
        if (this.isFormField()) {
            if (this.cachedValue == null) {
                byte[] data = this.get();
                String encoding = this.getEncoding();
                if (encoding != null) {
                    try {
                        this.cachedValue = new String(data, encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (this.cachedValue == null) {
                    this.cachedValue = new String(data);
                }
            }
            return this.cachedValue;
        }
        return this.delegatee.getString();
    }

    public String getString(String enc) throws UnsupportedEncodingException {
        return new String(this.get(), enc);
    }

    public boolean isFormField() {
        return this.delegatee.isFormField();
    }

    public String toString() {
        if (this.isFormField()) {
            return this.getString();
        }
        return "File: " + this.getFileName() + " (" + this.getSize() + " bytes)";
    }
}

