/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.discovery.PropertyProvider;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.support.TopicMatcher;
import org.apache.sling.event.impl.support.TopicMatcherHelper;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobConsumerManager.class}, property={"service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class JobConsumerManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<ConsumerInfo>> topicToConsumerMap = new HashMap<String, List<ConsumerInfo>>();
    private ServiceRegistration<PropertyProvider> propagationService;
    private String topics;
    private TopicMatcher[] allowListMatchers;
    private TopicMatcher[] denyListMatchers;
    private volatile long changeCount;
    private BundleContext bundleContext;
    private final Map<String, Object[]> listenerMap = new HashMap<String, Object[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> getRegistrationProperties() {
        Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
        ((Dictionary)serviceProps).put("instance.properties", "org.apache.sling.event.jobs.consumer.topics");
        JobConsumerManager jobConsumerManager = this;
        synchronized (jobConsumerManager) {
            ((Dictionary)serviceProps).put("changeCount", this.changeCount++);
        }
        return serviceProps;
    }

    @Activate
    protected void activate(BundleContext bc, Config config, DeprecatedConfig deprecatedConfig) {
        this.bundleContext = bc;
        this.modified(bc, config, deprecatedConfig);
    }

    private boolean isDefined(String[] value) {
        return value != null && value.length > 0;
    }

    private String[] getAllowListConfig(Config config, DeprecatedConfig deprecatedConfig) {
        if (this.isDefined(config.job_consumermanager_allowlist()) && this.isDefined(deprecatedConfig.job_consumermanager_whitelist())) {
            this.logger.error("Both properties, job.consumermanager.allowlist and job.consumermanager.whitelist, were defined. Using job.consumermanager.allowlist for configuring job consumers.Please remove the other property from your configuration.");
            return config.job_consumermanager_allowlist();
        }
        if (this.isDefined(config.job_consumermanager_allowlist())) {
            return config.job_consumermanager_allowlist();
        }
        if (this.isDefined(deprecatedConfig.job_consumermanager_whitelist())) {
            this.logger.warn("The property job.consumermanager.allowlist is not set. Using the provided property job.consumermanager.whitelist instead. Please update your configuration to use job.consumermanager.allowlist.");
            return deprecatedConfig.job_consumermanager_whitelist();
        }
        return new String[]{"*"};
    }

    private String[] getDenyListConfig(Config config, DeprecatedConfig deprecatedConfig) {
        if (this.isDefined(config.job_consumermanager_denylist()) && this.isDefined(deprecatedConfig.job_consumermanager_blacklist())) {
            this.logger.error("Both properties, job.consumermanager.denylist and job.consumermanager.blacklist, were defined. Using job.consumermanager.denylist for configuring job consumers.Please remove the other property from your configuration.");
            return config.job_consumermanager_denylist();
        }
        if (this.isDefined(config.job_consumermanager_denylist())) {
            return config.job_consumermanager_denylist();
        }
        if (this.isDefined(deprecatedConfig.job_consumermanager_blacklist())) {
            this.logger.warn("The property job.consumermanager.denylist is not set. Using the provided property job.consumermanager.blacklist instead. Please update your configuration to use job.consumermanager.denylist.");
            return deprecatedConfig.job_consumermanager_blacklist();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected void modified(BundleContext bc, Config config, DeprecatedConfig deprecatedConfig) {
        boolean enable;
        boolean wasEnabled = this.propagationService != null;
        this.allowListMatchers = TopicMatcherHelper.buildMatchers(this.getAllowListConfig(config, deprecatedConfig));
        this.denyListMatchers = TopicMatcherHelper.buildMatchers(this.getDenyListConfig(config, deprecatedConfig));
        boolean bl = enable = this.allowListMatchers != null && this.denyListMatchers != TopicMatcherHelper.MATCH_ALL;
        if (wasEnabled != enable) {
            Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
            synchronized (map) {
                this.calculateTopics(enable);
            }
            if (enable) {
                this.logger.debug("Registering property provider with: {}", (Object)this.topics);
                this.propagationService = bc.registerService(PropertyProvider.class, (Object)new PropertyProvider(){

                    public String getProperty(String name) {
                        if ("org.apache.sling.event.jobs.consumer.topics".equals(name)) {
                            return JobConsumerManager.this.topics;
                        }
                        return null;
                    }
                }, this.getRegistrationProperties());
            } else {
                this.logger.debug("Unregistering property provider with");
                this.propagationService.unregister();
                this.propagationService = null;
            }
        } else if (enable) {
            Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
            synchronized (map) {
                this.calculateTopics(true);
            }
            this.logger.debug("Updating property provider with: {}", (Object)this.topics);
            this.propagationService.setProperties(this.getRegistrationProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        if (this.propagationService != null) {
            this.propagationService.unregister();
            this.propagationService = null;
        }
        this.bundleContext = null;
        Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
        synchronized (map) {
            this.topicToConsumerMap.clear();
            this.listenerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecutor getExecutor(String topic) {
        Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
        synchronized (map) {
            List<ConsumerInfo> consumers = this.topicToConsumerMap.get(topic);
            if (consumers != null) {
                return consumers.get(0).getExecutor(this.bundleContext);
            }
            int pos = topic.lastIndexOf(47);
            if (pos > 0) {
                String category = topic.substring(0, pos + 1).concat("*");
                List<ConsumerInfo> categoryConsumers = this.topicToConsumerMap.get(category);
                if (categoryConsumers != null) {
                    return categoryConsumers.get(0).getExecutor(this.bundleContext);
                }
                do {
                    String subCategory;
                    List<ConsumerInfo> subCategoryConsumers;
                    if ((subCategoryConsumers = this.topicToConsumerMap.get(subCategory = topic.substring(0, pos + 1).concat("**"))) == null) continue;
                    return subCategoryConsumers.get(0).getExecutor(this.bundleContext);
                } while ((pos = topic.lastIndexOf(47, pos - 1)) > 0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(String key, JobExecutor consumer, JobExecutionContext handler) {
        Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
        synchronized (map) {
            this.listenerMap.put(key, new Object[]{consumer, handler});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(String key) {
        Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
        synchronized (map) {
            this.listenerMap.remove(key);
        }
    }

    public String getTopics() {
        return this.topics;
    }

    @Reference(service=JobConsumer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindJobConsumer(ServiceReference<JobConsumer> serviceReference) {
        this.bindService(serviceReference, true);
    }

    protected void unbindJobConsumer(ServiceReference<JobConsumer> serviceReference) {
        this.unbindService(serviceReference, true);
    }

    @Reference(service=JobExecutor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindJobExecutor(ServiceReference<JobExecutor> serviceReference) {
        this.bindService(serviceReference, false);
    }

    protected void unbindJobExecutor(ServiceReference<JobExecutor> serviceReference) {
        this.unbindService(serviceReference, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindService(ServiceReference<?> serviceReference, boolean isConsumer) {
        String[] topics = PropertiesUtil.toStringArray(serviceReference.getProperty("job.topics"));
        if (topics != null && topics.length > 0) {
            ConsumerInfo info = new ConsumerInfo(serviceReference, isConsumer);
            boolean changed = false;
            Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
            synchronized (map) {
                for (String t : topics) {
                    String topic;
                    if (t == null || (topic = t.trim()).length() <= 0) continue;
                    List<ConsumerInfo> consumers = this.topicToConsumerMap.get(topic);
                    if (consumers == null) {
                        consumers = new ArrayList<ConsumerInfo>();
                        this.topicToConsumerMap.put(topic, consumers);
                        changed = true;
                    }
                    consumers.add(info);
                    Collections.sort(consumers);
                }
                if (changed) {
                    this.calculateTopics(this.propagationService != null);
                }
            }
            if (changed && this.propagationService != null) {
                this.logger.debug("Updating property provider with: {}", (Object)this.topics);
                this.propagationService.setProperties(this.getRegistrationProperties());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindService(ServiceReference<?> serviceReference, boolean isConsumer) {
        String[] topics = PropertiesUtil.toStringArray(serviceReference.getProperty("job.topics"));
        if (topics != null && topics.length > 0) {
            ConsumerInfo info = new ConsumerInfo(serviceReference, isConsumer);
            boolean changed = false;
            Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
            synchronized (map) {
                for (String t : topics) {
                    List<ConsumerInfo> consumers;
                    String topic;
                    if (t == null || (topic = t.trim()).length() <= 0 || (consumers = this.topicToConsumerMap.get(topic)) == null) continue;
                    block4: for (ConsumerInfo oldConsumer : consumers) {
                        if (!oldConsumer.equals(info) || oldConsumer.executor == null) continue;
                        for (Object[] listenerObjects : this.listenerMap.values()) {
                            if (listenerObjects[0] != oldConsumer.executor) continue;
                            JobExecutionContext context = (JobExecutionContext)listenerObjects[1];
                            context.asyncProcessingFinished(context.result().failed());
                            continue block4;
                        }
                    }
                    consumers.remove(info);
                    if (consumers.size() != 0) continue;
                    this.topicToConsumerMap.remove(topic);
                    changed = true;
                }
                if (changed) {
                    this.calculateTopics(this.propagationService != null);
                }
            }
            if (changed && this.propagationService != null) {
                this.logger.debug("Updating property provider with: {}", (Object)this.topics);
                this.propagationService.setProperties(this.getRegistrationProperties());
            }
        }
    }

    private boolean match(String topic, TopicMatcher[] matchers) {
        for (TopicMatcher m : matchers) {
            if (m.match(topic) == null) continue;
            return true;
        }
        return false;
    }

    private void calculateTopics(boolean enabled) {
        if (enabled) {
            ArrayList<String> topicList = new ArrayList<String>();
            for (String topic : this.topicToConsumerMap.keySet()) {
                if (!this.match(topic, this.allowListMatchers) || this.denyListMatchers != null && this.match(topic, this.denyListMatchers)) continue;
                topicList.add(topic);
            }
            Collections.sort(topicList);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String topic : topicList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(topic);
            }
            this.topics = sb.toString();
        } else {
            this.topics = null;
        }
    }

    private static final class JobConsumerWrapper
    implements JobExecutor {
        private final JobConsumer consumer;

        public JobConsumerWrapper(JobConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public JobExecutionResult process(Job job, final JobExecutionContext context) {
            JobConsumer.AsyncHandler asyncHandler = new JobConsumer.AsyncHandler(){
                final Object asyncLock = new Object();
                final AtomicBoolean asyncDone = new AtomicBoolean(false);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void check(JobExecutionResult result) {
                    Object object = this.asyncLock;
                    synchronized (object) {
                        if (this.asyncDone.get()) {
                            throw new IllegalStateException("Job is already marked as processed");
                        }
                        this.asyncDone.set(true);
                        context.asyncProcessingFinished(result);
                    }
                }

                @Override
                public void ok() {
                    this.check(context.result().succeeded());
                }

                @Override
                public void failed() {
                    this.check(context.result().failed());
                }

                @Override
                public void cancel() {
                    this.check(context.result().cancelled());
                }
            };
            ((JobImpl)job).setProperty(":sling:jobs:asynchandler", asyncHandler);
            JobConsumer.JobResult result = this.consumer.process(job);
            if (result == JobConsumer.JobResult.ASYNC) {
                return null;
            }
            if (result == JobConsumer.JobResult.FAILED) {
                return context.result().failed();
            }
            if (result == JobConsumer.JobResult.OK) {
                return context.result().succeeded();
            }
            return context.result().cancelled();
        }
    }

    private static final class ConsumerInfo
    implements Comparable<ConsumerInfo> {
        public final ServiceReference<?> serviceReference;
        private final boolean isConsumer;
        public JobExecutor executor;
        public final int ranking;
        public final long serviceId;

        public ConsumerInfo(ServiceReference<?> serviceReference, boolean isConsumer) {
            this.serviceReference = serviceReference;
            this.isConsumer = isConsumer;
            Object sr = serviceReference.getProperty("service.ranking");
            this.ranking = sr == null || !(sr instanceof Integer) ? 0 : (Integer)sr;
            this.serviceId = (Long)serviceReference.getProperty("service.id");
        }

        @Override
        public int compareTo(ConsumerInfo o) {
            if (this.ranking < o.ranking) {
                return 1;
            }
            if (this.ranking > o.ranking) {
                return -1;
            }
            return this.serviceId < o.serviceId ? -1 : 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConsumerInfo) {
                return ((ConsumerInfo)obj).serviceId == this.serviceId;
            }
            return false;
        }

        public int hashCode() {
            return this.serviceReference.hashCode();
        }

        public JobExecutor getExecutor(BundleContext bundleContext) {
            if (this.executor == null) {
                this.executor = this.isConsumer ? new JobConsumerWrapper((JobConsumer)bundleContext.getService(this.serviceReference)) : (JobExecutor)bundleContext.getService(this.serviceReference);
            }
            return this.executor;
        }
    }

    public static @interface DeprecatedConfig {
        public String[] job_consumermanager_whitelist();

        public String[] job_consumermanager_blacklist();
    }

    @ObjectClassDefinition(name="Apache Sling Job Consumer Manager", description="The consumer manager controls the job consumer (= processors). It can be used to temporarily disable job processing on the current instance. Other instances in a cluster are not affected.")
    public static @interface Config {
        @AttributeDefinition(name="Distribute config", description="If this is disabled, the configuration is not persisted on save in the cluster and is only used on the current instance. This option should always be disabled!")
        public boolean org_apache_sling_installer_configuration_persist() default false;

        @AttributeDefinition(name="Topic Allow List", description="This is a list of topics which currently should be processed by this instance. Leaving it empty, all job consumers are disabled. Putting a '*' as one entry, enables all job consumers. Adding separate topics enables job consumers for exactly this topic.")
        public String[] job_consumermanager_allowlist();

        @AttributeDefinition(name="Topic Deny List", description="This is a list of topics which currently shouldn't be processed by this instance. Leaving it empty, all job consumers are enabled. Putting a '*' as one entry, disables all job consumers. Adding separate topics disables job consumers for exactly this topic.")
        public String[] job_consumermanager_denylist();
    }
}

