/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.stats;

import java.util.concurrent.atomic.AtomicLong;

public abstract class BaseStatisticsImpl {
    private final AtomicLong lastActivated = new AtomicLong(-1L);
    private final AtomicLong lastFinished = new AtomicLong(-1L);
    private final AtomicLong waitingTime = new AtomicLong();
    private final AtomicLong processingTime = new AtomicLong();
    private final AtomicLong waitingCount = new AtomicLong();
    private final AtomicLong processingCount = new AtomicLong();
    private final AtomicLong finishedJobs = new AtomicLong();
    private final AtomicLong failedJobs = new AtomicLong();
    private final AtomicLong cancelledJobs = new AtomicLong();

    public long getNumberOfProcessedJobs() {
        return this.finishedJobs.get() + this.failedJobs.get() + this.cancelledJobs.get();
    }

    public long getAverageWaitingTime() {
        long time = this.waitingTime.get();
        long count = this.waitingCount.get();
        if (count > 1L) {
            return time / count;
        }
        return time;
    }

    public long getAverageProcessingTime() {
        long time = this.processingTime.get();
        long count = this.processingCount.get();
        if (count > 1L) {
            return time / count;
        }
        return time;
    }

    public long getNumberOfFinishedJobs() {
        return this.finishedJobs.get();
    }

    public long getNumberOfCancelledJobs() {
        return this.cancelledJobs.get();
    }

    public long getNumberOfFailedJobs() {
        return this.failedJobs.get();
    }

    public long getLastActivatedJobTime() {
        return this.lastActivated.get();
    }

    public long getLastFinishedJobTime() {
        return this.lastFinished.get();
    }

    public synchronized void finishedJob(long jobTime) {
        this.lastFinished.set(System.currentTimeMillis());
        this.processingTime.addAndGet(jobTime);
        this.processingCount.incrementAndGet();
        this.finishedJobs.incrementAndGet();
    }

    public synchronized void addActive(long queueTime) {
        this.waitingCount.incrementAndGet();
        this.waitingTime.addAndGet(queueTime);
        this.lastActivated.set(System.currentTimeMillis());
    }

    public synchronized void failedJob() {
        this.failedJobs.incrementAndGet();
    }

    public synchronized void cancelledJob() {
        this.cancelledJobs.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(BaseStatisticsImpl other) {
        BaseStatisticsImpl baseStatisticsImpl = other;
        synchronized (baseStatisticsImpl) {
            if (other.lastActivated.get() > this.lastActivated.get()) {
                this.lastActivated.set(other.lastActivated.get());
            }
            if (other.lastFinished.get() > this.lastFinished.get()) {
                this.lastFinished.set(other.lastFinished.get());
            }
            this.waitingTime.addAndGet(other.waitingTime.get());
            this.waitingCount.addAndGet(other.waitingCount.get());
            this.processingTime.addAndGet(other.processingTime.get());
            this.processingCount.addAndGet(other.processingCount.get());
            this.finishedJobs.addAndGet(other.finishedJobs.get());
            this.failedJobs.addAndGet(other.failedJobs.get());
            this.cancelledJobs.addAndGet(other.cancelledJobs.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(BaseStatisticsImpl other) {
        long localCancelledJobs;
        long localFailedJobs;
        long localFinishedJobs;
        long localProcessingCount;
        long localWaitingCount;
        long localProcessingTime;
        long localWaitingTime;
        long localLastFinished;
        long localLastActivated;
        BaseStatisticsImpl baseStatisticsImpl = other;
        synchronized (baseStatisticsImpl) {
            localLastActivated = other.lastActivated.get();
            localLastFinished = other.lastFinished.get();
            localWaitingTime = other.waitingTime.get();
            localProcessingTime = other.processingTime.get();
            localWaitingCount = other.waitingCount.get();
            localProcessingCount = other.processingCount.get();
            localFinishedJobs = other.finishedJobs.get();
            localFailedJobs = other.failedJobs.get();
            localCancelledJobs = other.cancelledJobs.get();
        }
        baseStatisticsImpl = this;
        synchronized (baseStatisticsImpl) {
            this.lastActivated.set(localLastActivated);
            this.lastFinished.set(localLastFinished);
            this.waitingTime.set(localWaitingTime);
            this.processingTime.set(localProcessingTime);
            this.waitingCount.set(localWaitingCount);
            this.processingCount.set(localProcessingCount);
            this.finishedJobs.set(localFinishedJobs);
            this.failedJobs.set(localFailedJobs);
            this.cancelledJobs.set(localCancelledJobs);
        }
    }

    public synchronized void reset() {
        this.lastActivated.set(-1L);
        this.lastFinished.set(-1L);
        this.waitingTime.set(0L);
        this.processingTime.set(0L);
        this.waitingCount.set(0L);
        this.processingCount.set(0L);
        this.finishedJobs.set(0L);
        this.failedJobs.set(0L);
        this.cancelledJobs.set(0L);
    }
}

