/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import relocated_for_contentpackage.javax.jcr.NamespaceException;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.Property;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.Name;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NameException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NameParser;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.name.NameConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.util.ISO9075;
import relocated_for_contentpackage.org.apache.jackrabbit.util.Text;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.Aggregate;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.AggregateWalkListener;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.DocViewProperty;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.ItemNameComparator2;

public class DocViewSAXFormatter
implements AggregateWalkListener {
    public static final String CDATA_TYPE = "CDATA";
    protected final Session session;
    protected final NamespaceResolver nsResolver;
    protected final XMLStreamWriter writer;
    protected final String jcrPrimaryType;
    protected final String ntUnstructured;
    protected final String jcrMixinTypes;
    protected final String jcrUUID;
    protected final String jcrRoot;
    private final List<Property> props = new ArrayList<Property>();
    private final Aggregate aggregate;
    private final boolean useBinaryReferences;
    private final Set<String> ignored = new HashSet<String>();
    private ItemNameComparator2 itemNameComparator;

    protected DocViewSAXFormatter(Aggregate aggregate, XMLStreamWriter writer) throws RepositoryException {
        this.aggregate = aggregate;
        this.session = aggregate.getNode().getSession();
        this.nsResolver = new SessionNamespaceResolver(this.session);
        this.itemNameComparator = new ItemNameComparator2(this.nsResolver);
        this.writer = writer;
        DefaultNamePathResolver npResolver = new DefaultNamePathResolver(this.nsResolver);
        try {
            this.jcrPrimaryType = npResolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
            this.jcrMixinTypes = npResolver.getJCRName(NameConstants.JCR_MIXINTYPES);
            this.jcrUUID = npResolver.getJCRName(NameConstants.JCR_UUID);
            this.jcrRoot = npResolver.getJCRName(NameConstants.JCR_ROOT);
            this.ntUnstructured = npResolver.getJCRName(NameConstants.NT_UNSTRUCTURED);
        }
        catch (NamespaceException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, e);
        }
        this.useBinaryReferences = "true".equals(aggregate.getManager().getConfig().getProperty("useBinaryReferences"));
    }

    private void startNamespaceDeclarations() throws RepositoryException, XMLStreamException {
        this.writer.writeNamespace("jcr", "http://www.jcp.org/jcr/1.0");
        for (String prefix : this.aggregate.getNamespacePrefixes()) {
            if ("xml".equals(prefix) || "jcr".equals(prefix)) continue;
            this.writer.writeNamespace(prefix, this.aggregate.getNamespaceURI(prefix));
        }
    }

    private Name getQName(String rawName) throws RepositoryException {
        try {
            return NameParser.parse(rawName, this.nsResolver, NameFactoryImpl.getInstance());
        }
        catch (NameException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, e);
        }
    }

    @Override
    public void onWalkBegin(Node root) throws RepositoryException {
        this.ignored.clear();
        this.ignored.add("jcr:created");
        this.ignored.add("jcr:createdBy");
        this.ignored.add("jcr:baseVersion");
        this.ignored.add("jcr:versionHistory");
        this.ignored.add("jcr:predecessors");
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void onWalkEnd(Node root) throws RepositoryException {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void onNodeBegin(Node node, boolean included, int level) throws RepositoryException {
        this.aggregate.getManager().addNodeTypes(node);
        this.props.clear();
    }

    @Override
    public void onChildren(Node node, int level) throws RepositoryException {
        String label = Text.getName(node.getPath());
        String elemName = level == 0 || node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode(label);
        Collections.sort(this.props, this.itemNameComparator);
        Name qName = this.getQName(elemName);
        try {
            String namespaceUri = qName.getNamespaceURI();
            if (namespaceUri.length() > 0) {
                this.writer.writeStartElement(this.nsResolver.getPrefix(namespaceUri), qName.getLocalName(), namespaceUri);
            } else {
                this.writer.writeStartElement(qName.getLocalName());
            }
            if (elemName == this.jcrRoot) {
                this.startNamespaceDeclarations();
            }
            for (Property prop : this.props) {
                String attrName = ISO9075.encode(prop.getName());
                Name qAttributeName = this.getQName(attrName);
                boolean sort = qName.equals(NameConstants.JCR_MIXINTYPES);
                String attributeNamespaceUri = qAttributeName.getNamespaceURI();
                if (attributeNamespaceUri.length() > 0) {
                    this.writer.writeAttribute(this.nsResolver.getPrefix(attributeNamespaceUri), attributeNamespaceUri, qAttributeName.getLocalName(), DocViewProperty.format(prop, sort, this.useBinaryReferences));
                    continue;
                }
                this.writer.writeAttribute(qAttributeName.getLocalName(), DocViewProperty.format(prop, sort, this.useBinaryReferences));
            }
        }
        catch (XMLStreamException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void onNodeEnd(Node node, boolean included, int level) throws RepositoryException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void onProperty(Property prop, int level) throws RepositoryException {
        if (this.ignored.contains(prop.getName()) && prop.getDefinition().isProtected()) {
            return;
        }
        this.props.add(prop);
    }

    @Override
    public void onNodeIgnored(Node node, int depth) throws RepositoryException {
        String label = Text.getName(node.getPath());
        String elemName = ISO9075.encode(label);
        Name qName = this.getQName(elemName);
        try {
            this.writer.writeStartElement(this.nsResolver.getPrefix(qName.getNamespaceURI()), qName.getLocalName(), qName.getNamespaceURI());
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException(e);
        }
    }
}

