/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.ProgressTracker;

public class AutoSave {
    private static final Logger log = LoggerFactory.getLogger(AutoSave.class);
    private int numModified;
    private int lastSave;
    private int threshold = 1024;
    private final Set<String> missingMandatory = new HashSet<String>();
    private ProgressTracker tracker;
    private boolean dryRun;
    private int debugFailEach;
    private int debugSaveCount;

    public AutoSave() {
    }

    public AutoSave(int threshold) {
        this.threshold = threshold;
    }

    public AutoSave copy() {
        AutoSave ret = new AutoSave();
        ret.threshold = this.threshold;
        ret.numModified = this.numModified;
        ret.lastSave = this.lastSave;
        ret.tracker = this.tracker;
        ret.dryRun = this.dryRun;
        ret.missingMandatory.addAll(this.missingMandatory);
        ret.debugFailEach = this.debugFailEach;
        return ret;
    }

    public void setTracker(@Nullable ProgressTracker tracker) {
        this.tracker = tracker;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setDebugFailEach(int debugFailEach) {
        this.debugFailEach = debugFailEach;
    }

    public boolean needsSave() {
        boolean res;
        boolean bl = res = this.numModified - this.lastSave >= this.threshold;
        if (res && !this.missingMandatory.isEmpty()) {
            log.debug("Threshold of {} reached but still unresolved mandatory items.", (Object)this.threshold);
            res = false;
        }
        return res;
    }

    public void save(@Nullable Session session) throws RepositoryException {
        if (this.threshold == Integer.MAX_VALUE) {
            log.trace("Save disabled.");
            return;
        }
        int diff = this.numModified - this.lastSave;
        log.debug("Threshold of {} reached. {} approx {} transient changes. {} unresolved", new Object[]{this.threshold, this.dryRun ? "dry run, reverting" : "saving", diff, this.missingMandatory.size()});
        if (this.tracker != null) {
            if (this.dryRun) {
                this.tracker.track("reverting approx " + diff + " nodes... (dry run)", "");
            } else {
                this.tracker.track("saving approx " + diff + " nodes...", "");
            }
        }
        if (session != null) {
            if (this.debugFailEach > 0 && this.debugSaveCount > 0 && this.debugSaveCount % this.debugFailEach == 0) {
                String msg = String.format("Debugging provoked failure after %s saves.", this.debugSaveCount);
                log.error(msg);
                throw new RepositoryException(msg);
            }
            if (this.dryRun) {
                session.refresh(false);
            } else {
                try {
                    session.save();
                    ++this.debugSaveCount;
                }
                catch (RepositoryException e) {
                    log.error("error during auto save - retrying after refresh...");
                    session.refresh(true);
                    session.save();
                    ++this.debugSaveCount;
                }
            }
        }
        this.lastSave = this.numModified;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean modified(int num) {
        this.numModified += num;
        return this.needsSave();
    }

    public void markMissing(@NotNull String path) {
        this.missingMandatory.add(path);
    }

    public void markResolved(@NotNull String path) {
        this.missingMandatory.remove(path);
    }

    public String toString() {
        return String.valueOf(this.threshold);
    }
}

