/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.views;

import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.PropertyType;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.apache.sling.ide.eclipse.ui.views.DateTimeSupport;

public class PropertyTypeSupport {
    static final String[] PROPERTY_TYPES = new String[]{"Binary", "Boolean", "Date", "Decimal", "Double", "Long", "Name", "Path", "Reference", "String", "URI", "WeakReference"};
    static Map<String, Integer> propertyTypeIndices = new HashMap<String, Integer>();

    static {
        int i = 0;
        while (i < PROPERTY_TYPES.length) {
            String aPropertyType = PROPERTY_TYPES[i];
            propertyTypeIndices.put(aPropertyType, i);
            ++i;
        }
    }

    static int indexOfPropertyType(int propertyType) {
        String name = PropertyType.nameFromValue((int)propertyType);
        return propertyTypeIndices.get(name);
    }

    static int propertyTypeOfIndex(int index) {
        String name = null;
        try {
            name = PROPERTY_TYPES[index];
            int value = PropertyType.valueFromName((String)name);
            return value;
        }
        catch (Exception e) {
            Activator.getDefault().getPluginLogger().warn("Unsupported index (" + index + ") and/or name (" + name + "): " + String.valueOf(e), (Throwable)e);
            return 1;
        }
    }

    public static int propertyTypeOfString(String rawValue) {
        if (rawValue == null) {
            return 1;
        }
        if (!rawValue.startsWith("{")) {
            return 1;
        }
        int curlyEnd = rawValue.indexOf("}", 1);
        if (curlyEnd == -1) {
            return 1;
        }
        String type = rawValue.substring(1, curlyEnd);
        int index = -2;
        try {
            index = propertyTypeIndices.get(type);
            return PropertyTypeSupport.propertyTypeOfIndex(index);
        }
        catch (Exception e) {
            Activator.getDefault().getPluginLogger().warn("Unsupported type (" + type + ") and/or index (" + index + "): " + String.valueOf(e), (Throwable)e);
            return 1;
        }
    }

    public static String encodeValueAsString(Object value, int propertyType) {
        switch (propertyType) {
            case 6: {
                return Boolean.toString(value.equals(1));
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: {
                return String.valueOf(value);
            }
            case 2: {
                return "";
            }
            case 5: {
                if (value instanceof Date) {
                    Date date = (Date)value;
                    Calendar c = Calendar.getInstance();
                    c.setTime(date);
                    return DateTimeSupport.print(c);
                }
                if (value instanceof GregorianCalendar) {
                    GregorianCalendar date = (GregorianCalendar)value;
                    return DateTimeSupport.print(date);
                }
                return String.valueOf(value);
            }
            case 11: {
                if (value instanceof URI) {
                    URI uri = (URI)value;
                    return uri.toString();
                }
                return String.valueOf(value);
            }
            case 9: 
            case 10: {
                return String.valueOf(value);
            }
        }
        return String.valueOf(value);
    }
}

