/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.ide.eclipse.core.ConfigurationHelper;
import org.apache.sling.ide.eclipse.core.DefaultSlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.progress.ProgressUtils;
import org.apache.sling.ide.eclipse.ui.WhitelabelSupport;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.apache.sling.ide.eclipse.ui.wizards.Projects;
import org.apache.sling.ide.eclipse.ui.wizards.SetupServerWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;

public abstract class AbstractNewSlingApplicationWizard
extends Wizard
implements INewWizard {
    private SetupServerWizardPage setupServerWizardPage = new SetupServerWizardPage(this);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected WizardPage getCurrentWizardPage() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof WizardPage) {
            return (WizardPage)currentPage;
        }
        return null;
    }

    public void reportError(CoreException e) {
        WizardPage currentPage = this.getCurrentWizardPage();
        if (currentPage != null) {
            currentPage.setMessage(e.getMessage(), 3);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unexpected error", (String)e.getMessage());
        }
        Activator.getDefault().getLog().log(e.getStatus());
    }

    public void reportError(Throwable t) {
        if (t instanceof CoreException) {
            this.reportError((CoreException)t);
            return;
        }
        Status status = new Status(4, "org.apache.sling.ide.eclipse-core", t.getMessage(), t);
        this.reportError(new CoreException((IStatus)status));
    }

    protected SetupServerWizardPage getSetupServerWizardPage() {
        return this.setupServerWizardPage;
    }

    public boolean performFinish() {
        try {
            final ArrayList createdProjects = new ArrayList();
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    createdProjects.addAll(AbstractNewSlingApplicationWizard.this.createProjects(monitor));
                }
            });
            final Projects[] projects = new Projects[1];
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    projects[0] = AbstractNewSlingApplicationWizard.this.configureCreatedProjects(createdProjects, monitor);
                }
            });
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    AbstractNewSlingApplicationWizard.this.deployProjectsOnServer(projects[0], monitor);
                }
            });
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AbstractNewSlingApplicationWizard.this.publishModules(createdProjects, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            this.reportError(e.getTargetException());
            return false;
        }
        return true;
    }

    protected abstract List<IProject> createProjects(IProgressMonitor var1) throws CoreException;

    protected abstract Projects configureCreatedProjects(List<IProject> var1, IProgressMonitor var2) throws CoreException;

    protected void deployProjectsOnServer(Projects projects, IProgressMonitor monitor) throws CoreException {
        IModule module;
        IServer server = this.setupServerWizardPage.getOrCreateServer(monitor);
        if (server == null) {
            monitor.done();
            return;
        }
        ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        IServerWorkingCopy wc = server.createWorkingCopy();
        LinkedList<IModule> modules = new LinkedList<IModule>();
        for (IProject project : projects.getBundleProjects()) {
            module = ServerUtil.getModule((IProject)project);
            if (module == null || !this.shouldDeploy(module)) continue;
            modules.add(module);
        }
        for (IProject project : projects.getContentProjects()) {
            module = ServerUtil.getModule((IProject)project);
            if (module == null || !this.shouldDeploy(module)) continue;
            modules.add(module);
        }
        wc.modifyModules(modules.toArray(new IModule[modules.size()]), new IModule[0], monitor);
        wc.save(true, monitor);
        ProgressUtils.advance((IProgressMonitor)monitor, (int)2);
        monitor.done();
    }

    protected boolean shouldDeploy(IModule module) {
        return true;
    }

    protected void publishModules(List<IProject> createdProjects, IProgressMonitor monitor) throws CoreException {
        IServer server = this.setupServerWizardPage.getOrCreateServer(monitor);
        if (server == null) {
            return;
        }
        if (this.setupServerWizardPage.getStartServer()) {
            server.start("run", monitor);
        }
        ArrayList<IModule[]> modules = new ArrayList<IModule[]>();
        for (IProject project : createdProjects) {
            IModule module = ServerUtil.getModule((IProject)project);
            if (module == null || !this.shouldDeploy(module)) continue;
            modules.add(new IModule[]{module});
        }
        if (modules.size() > 0) {
            server.publish(4, modules, null, null);
        }
    }

    protected void configureBundleProject(IProject aBundleProject, List<IProject> projects, IProgressMonitor monitor) throws CoreException {
        ConfigurationHelper.convertToBundleProject((IProject)aBundleProject);
    }

    protected void configureContentProject(IProject aContentProject, List<IProject> projects, IProgressMonitor monitor) throws CoreException {
        ConfigurationHelper.convertToContentPackageProject((IProject)aContentProject, (IProgressMonitor)monitor, (IPath)new Path("src/main/content/jcr_root"));
    }

    protected void configureReactorProject(IProject reactorProject, IProgressMonitor monitor) throws CoreException {
    }

    protected void finishConfiguration(List<IProject> projects, IServer server, IProgressMonitor monitor) throws CoreException {
    }

    public ImageDescriptor getLogo() {
        return WhitelabelSupport.getProjectWizardBanner();
    }

    public abstract String doGetWindowTitle();

    protected ISlingLaunchpadConfiguration getDefaultConfig() {
        return DefaultSlingLaunchpadConfiguration.INSTANCE;
    }
}

