/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.state.AbstractItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.ItemInfoCache;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceItemStateFactory
extends AbstractItemStateFactory {
    private static Logger log = LoggerFactory.getLogger(WorkspaceItemStateFactory.class);
    private final RepositoryService service;
    private final SessionInfo sessionInfo;
    private final ItemDefinitionProvider definitionProvider;
    private final ItemInfoCache cache;

    public WorkspaceItemStateFactory(RepositoryService service, SessionInfo sessionInfo, ItemDefinitionProvider definitionProvider, ItemInfoCache cache) {
        this.service = service;
        this.sessionInfo = sessionInfo;
        this.definitionProvider = definitionProvider;
        this.cache = cache;
    }

    @Override
    public NodeState createRootState(NodeEntry entry) throws ItemNotFoundException, RepositoryException {
        IdFactory idFactory = this.service.getIdFactory();
        PathFactory pf = this.service.getPathFactory();
        return this.createNodeState(idFactory.createNodeId((String)null, pf.getRootPath()), entry);
    }

    @Override
    public NodeState createNodeState(NodeId nodeId, NodeEntry entry) throws ItemNotFoundException, RepositoryException {
        try {
            Object info;
            ItemInfoCache.Entry<NodeInfo> cached = this.cache.getNodeInfo(nodeId);
            if (WorkspaceItemStateFactory.isUpToDate(cached, entry)) {
                info = cached.info;
            } else {
                Iterator<? extends ItemInfo> infos = this.service.getItemInfos(this.sessionInfo, nodeId);
                info = WorkspaceItemStateFactory.first(infos, this.cache, entry.getGeneration());
                if (info == null || !info.denotesNode()) {
                    throw new ItemNotFoundException("NodeId: " + nodeId);
                }
            }
            WorkspaceItemStateFactory.assertMatchingPath(info, entry);
            return this.createNodeState((NodeInfo)info, entry);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e);
        }
    }

    @Override
    public NodeState createDeepNodeState(NodeId nodeId, NodeEntry anyParent) throws ItemNotFoundException, RepositoryException {
        try {
            HierarchyEntry entry;
            Object info;
            Iterator<? extends ItemInfo> infos = null;
            ItemInfoCache.Entry<NodeInfo> cached = this.cache.getNodeInfo(nodeId);
            if (cached == null) {
                infos = this.service.getItemInfos(this.sessionInfo, nodeId);
                info = WorkspaceItemStateFactory.first(infos, null, 0L);
                if (info == null || !info.denotesNode()) {
                    throw new ItemNotFoundException("NodeId: " + nodeId);
                }
            } else {
                info = cached.info;
            }
            if ((entry = this.createHierarchyEntries((ItemInfo)info, anyParent)) == null || !entry.denotesNode()) {
                throw new ItemNotFoundException("HierarchyEntry does not belong to any existing ItemInfo. No ItemState was created.");
            }
            long generation = entry.getGeneration();
            if (WorkspaceItemStateFactory.isOutdated(cached, entry)) {
                infos = this.service.getItemInfos(this.sessionInfo, nodeId);
                info = WorkspaceItemStateFactory.first(infos, this.cache, generation);
            } else if (infos != null) {
                this.cache.put((ItemInfo)info, generation);
                WorkspaceItemStateFactory.first(infos, this.cache, generation);
            }
            WorkspaceItemStateFactory.assertMatchingPath((ItemInfo)info, entry);
            return this.createNodeState((NodeInfo)info, (NodeEntry)entry);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e);
        }
    }

    @Override
    public PropertyState createPropertyState(PropertyId propertyId, PropertyEntry entry) throws ItemNotFoundException, RepositoryException {
        try {
            Object info;
            ItemInfoCache.Entry<PropertyInfo> cached = this.cache.getPropertyInfo(propertyId);
            if (WorkspaceItemStateFactory.isUpToDate(cached, entry)) {
                info = cached.info;
            } else {
                Iterator<? extends ItemInfo> infos = this.service.getItemInfos(this.sessionInfo, propertyId);
                info = WorkspaceItemStateFactory.first(infos, this.cache, entry.getGeneration());
                if (info == null || info.denotesNode()) {
                    throw new ItemNotFoundException("PropertyId: " + propertyId);
                }
            }
            WorkspaceItemStateFactory.assertMatchingPath(info, entry);
            return this.createPropertyState((PropertyInfo)info, entry);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e);
        }
    }

    @Override
    public PropertyState createDeepPropertyState(PropertyId propertyId, NodeEntry anyParent) throws RepositoryException {
        try {
            HierarchyEntry entry;
            Object info;
            Iterator<? extends ItemInfo> infos = null;
            ItemInfoCache.Entry<PropertyInfo> cached = this.cache.getPropertyInfo(propertyId);
            if (cached == null) {
                infos = this.service.getItemInfos(this.sessionInfo, propertyId);
                info = WorkspaceItemStateFactory.first(infos, null, 0L);
                if (info == null || info.denotesNode()) {
                    throw new ItemNotFoundException("PropertyId: " + propertyId);
                }
            } else {
                info = cached.info;
            }
            if ((entry = this.createHierarchyEntries((ItemInfo)info, anyParent)) == null || entry.denotesNode()) {
                throw new ItemNotFoundException("HierarchyEntry does not belong to any existing ItemInfo. No ItemState was created.");
            }
            long generation = entry.getGeneration();
            if (WorkspaceItemStateFactory.isOutdated(cached, entry)) {
                infos = this.service.getItemInfos(this.sessionInfo, propertyId);
                info = WorkspaceItemStateFactory.first(infos, this.cache, generation);
            } else if (infos != null) {
                this.cache.put((ItemInfo)info, generation);
                WorkspaceItemStateFactory.first(infos, this.cache, generation);
            }
            WorkspaceItemStateFactory.assertMatchingPath((ItemInfo)info, entry);
            return this.createPropertyState((PropertyInfo)info, (PropertyEntry)entry);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e);
        }
    }

    @Override
    public Iterator<ChildInfo> getChildNodeInfos(NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        return this.service.getChildInfos(this.sessionInfo, nodeId);
    }

    @Override
    public Iterator<PropertyId> getNodeReferences(NodeState nodeState, Name propertyName, boolean weak) {
        NodeEntry entry = nodeState.getNodeEntry();
        if (entry.getUniqueID() == null || !entry.hasPropertyEntry(NameConstants.JCR_UUID)) {
            Set t = Collections.emptySet();
            return t.iterator();
        }
        try {
            return this.service.getReferences(this.sessionInfo, entry.getWorkspaceId(), propertyName, weak);
        }
        catch (RepositoryException e) {
            log.debug("Unable to determine references to {}", (Object)nodeState);
            Set t = Collections.emptySet();
            return t.iterator();
        }
    }

    private static ItemInfo first(Iterator<? extends ItemInfo> infos, ItemInfoCache cache, long generation) {
        ItemInfo first = null;
        if (infos.hasNext()) {
            first = infos.next();
            if (cache != null) {
                cache.put(first, generation);
            }
        }
        if (cache != null) {
            while (infos.hasNext()) {
                cache.put(infos.next(), generation);
            }
        }
        return first;
    }

    private NodeState createNodeState(NodeInfo info, NodeEntry entry) throws ItemNotFoundException, RepositoryException {
        String uniqueID = info.getId().getUniqueID();
        Path path = info.getId().getPath();
        if (path == null) {
            entry.setUniqueID(uniqueID);
        } else if (uniqueID != null) {
            NodeEntry parent = WorkspaceItemStateFactory.getAncestor(entry, path.getLength());
            parent.setUniqueID(uniqueID);
        }
        int previousStatus = entry.getStatus();
        if (Status.isTransient(previousStatus) || Status.isStale(previousStatus)) {
            log.debug("Node has pending changes; omit resetting the state.");
            return entry.getNodeState();
        }
        ArrayList<Name> propNames = new ArrayList<Name>();
        Iterator<PropertyId> it = info.getPropertyIds();
        while (it.hasNext()) {
            PropertyId pId = it.next();
            Name propertyName = pId.getName();
            propNames.add(propertyName);
        }
        try {
            entry.setPropertyEntries(propNames);
        }
        catch (ItemExistsException e) {
            log.error("Internal error", (Throwable)e);
        }
        Iterator<ChildInfo> childInfos = info.getChildInfos();
        if (childInfos != null) {
            entry.setNodeEntries(childInfos);
        }
        NodeState tmp = new NodeState(entry, info, (ItemStateFactory)this, this.definitionProvider);
        entry.setItemState(tmp);
        NodeState nState = entry.getNodeState();
        if (previousStatus == -1) {
            this.notifyCreated(nState);
        } else {
            this.notifyUpdated(nState, previousStatus);
        }
        return nState;
    }

    private PropertyState createPropertyState(PropertyInfo info, PropertyEntry entry) throws RepositoryException {
        int previousStatus;
        String uniqueID = info.getId().getUniqueID();
        if (uniqueID != null) {
            NodeEntry parent = WorkspaceItemStateFactory.getAncestor(entry, info.getId().getPath().getLength());
            parent.setUniqueID(uniqueID);
        }
        if (Status.isTransient(previousStatus = entry.getStatus()) || Status.isStale(previousStatus)) {
            log.debug("Property has pending changes; omit resetting the state.");
            return entry.getPropertyState();
        }
        PropertyState tmp = new PropertyState(entry, info, (ItemStateFactory)this, this.definitionProvider);
        entry.setItemState(tmp);
        PropertyState pState = entry.getPropertyState();
        if (previousStatus == -1) {
            this.notifyCreated(pState);
        } else {
            this.notifyUpdated(pState, previousStatus);
        }
        return pState;
    }

    private HierarchyEntry createHierarchyEntries(ItemInfo info, NodeEntry anyParent) throws RepositoryException {
        Path anyParentPath = anyParent.getWorkspacePath();
        Path relPath = anyParentPath.computeRelativePath(info.getPath());
        Path.Element[] missingElems = relPath.getElements();
        NodeEntry entry = anyParent;
        int last = missingElems.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (missingElems[i].denotesParent()) {
                entry = entry.getParent();
                continue;
            }
            if (!missingElems[i].denotesName()) continue;
            Name name = missingElems[i].getName();
            int index = missingElems[i].getNormalizedIndex();
            if (i == last && !info.denotesNode()) {
                return entry.getOrAddPropertyEntry(name);
            }
            entry = this.createNodeEntry(entry, name, index);
        }
        return entry;
    }

    private NodeEntry createNodeEntry(NodeEntry parentEntry, Name name, int index) throws RepositoryException {
        Iterator<ChildInfo> childInfos;
        ItemInfoCache.Entry<NodeInfo> cached = this.cache.getNodeInfo(parentEntry.getWorkspaceId());
        if (WorkspaceItemStateFactory.isUpToDate(cached, parentEntry) && (childInfos = ((NodeInfo)cached.info).getChildInfos()) != null) {
            parentEntry.setNodeEntries(childInfos);
        }
        return parentEntry.getOrAddNodeEntry(name, index, null);
    }

    private static boolean isUpToDate(ItemInfoCache.Entry<?> cacheEntry, HierarchyEntry entry) throws RepositoryException {
        return cacheEntry != null && cacheEntry.generation >= entry.getGeneration() && WorkspaceItemStateFactory.isMatchingPath(cacheEntry.info, entry);
    }

    private static boolean isOutdated(ItemInfoCache.Entry<?> cacheEntry, HierarchyEntry entry) throws RepositoryException {
        return cacheEntry != null && (cacheEntry.generation < entry.getGeneration() || !WorkspaceItemStateFactory.isMatchingPath(cacheEntry.info, entry));
    }

    private static boolean isMatchingPath(ItemInfo info, HierarchyEntry entry) throws RepositoryException {
        Path infoPath = info.getPath();
        Path wspPath = entry.getWorkspacePath();
        return infoPath.equals(wspPath);
    }

    private static void assertMatchingPath(ItemInfo info, HierarchyEntry entry) throws RepositoryException {
        if (!WorkspaceItemStateFactory.isMatchingPath(info, entry)) {
            throw new ItemNotFoundException("HierarchyEntry " + entry.getWorkspacePath() + " does not match ItemInfo " + info.getPath());
        }
    }

    private static NodeEntry getAncestor(HierarchyEntry entry, int degree) {
        NodeEntry parent;
        --degree;
        for (parent = entry.getParent(); parent != null && degree > 0; parent = parent.getParent(), --degree) {
        }
        if (degree != 0) {
            log.error("Parent of degree {} does not exist.", (Object)degree);
            throw new IllegalArgumentException();
        }
        return parent;
    }
}

