/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.ExportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface JcrPackage
extends Comparable<JcrPackage>,
AutoCloseable {
    public static final String NT_VLT_PACKAGE = "vlt:Package";
    public static final String NT_VLT_PACKAGE_DEFINITION = "vlt:PackageDefinition";
    public static final String NN_VLT_DEFINITION = "vlt:definition";
    public static final String MIME_TYPE = "application/zip";

    @Nullable
    public JcrPackageDefinition getDefinition() throws RepositoryException;

    public boolean isValid();

    @Nullable
    public Node getNode();

    public boolean isSealed();

    @NotNull
    public VaultPackage getPackage() throws RepositoryException, IOException;

    public void extract(@NotNull ImportOptions var1) throws RepositoryException, PackageException, IOException;

    public void install(@NotNull ImportOptions var1) throws RepositoryException, PackageException, IOException;

    @NotNull
    public PackageId[] extractSubpackages(@NotNull ImportOptions var1) throws RepositoryException, PackageException, IOException;

    @NotNull
    public Dependency[] getUnresolvedDependencies() throws RepositoryException;

    @NotNull
    public PackageId[] getResolvedDependencies() throws RepositoryException;

    @Nullable
    public JcrPackage snapshot(@NotNull ExportOptions var1, boolean var2) throws RepositoryException, PackageException, IOException;

    @Nullable
    public JcrPackage getSnapshot() throws RepositoryException;

    public void uninstall(@NotNull ImportOptions var1) throws RepositoryException, PackageException, IOException;

    @Deprecated
    public boolean verifyId(boolean var1, boolean var2) throws RepositoryException;

    public boolean isInstalled() throws RepositoryException;

    public boolean isEmpty();

    public long getSize();

    @Override
    public void close();

    @Nullable
    public Property getData() throws RepositoryException;

    @Nullable
    public Node getDefNode() throws RepositoryException;
}

