/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging;

import java.util.ArrayList;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version
implements Comparable<Version> {
    public static final Version EMPTY = new Version("", new String[0]);
    private final String str;
    private final String[] segments;

    @NotNull
    public static Version create(@Nullable String str) {
        if (str == null || str.length() == 0) {
            return EMPTY;
        }
        return Version.create(Text.explode(str, 46));
    }

    @NotNull
    public static Version create(@Nullable String[] segments) {
        if (segments == null || segments.length == 0) {
            return EMPTY;
        }
        ArrayList<String> segs = new ArrayList<String>(segments.length + 1);
        StringBuilder str = new StringBuilder();
        boolean hasQualifier = false;
        for (String s : segments) {
            if (str.length() > 0) {
                str.append('.');
            }
            str.append(s);
            if (hasQualifier) {
                segs.add(s);
                continue;
            }
            int dash = s.indexOf(45);
            if (dash < 0) {
                segs.add(s);
                continue;
            }
            if (dash <= 0) continue;
            hasQualifier = true;
            segs.add(s.substring(0, dash));
            if (dash >= s.length() - 1) continue;
            segs.add(s.substring(dash + 1));
        }
        return new Version(str.toString(), segs.toArray(new String[segs.size()]));
    }

    private Version(@NotNull String str, @NotNull String[] segments) {
        this.str = str;
        this.segments = segments;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Version && this.str.equals(((Version)o).str);
    }

    public String toString() {
        return this.str;
    }

    public String[] getNormalizedSegments() {
        return this.segments;
    }

    @Override
    public int compareTo(Version o) {
        String[] oSegs = o.getNormalizedSegments();
        for (int i = 0; i < Math.min(this.segments.length, oSegs.length); ++i) {
            String s1 = this.segments[i];
            String s2 = oSegs[i];
            int strCompare = s1.compareTo(s2);
            if (strCompare == 0) continue;
            try {
                int v1 = Integer.parseInt(this.segments[i]);
                int v2 = Integer.parseInt(oSegs[i]);
                return v1 - v2;
            }
            catch (NumberFormatException e) {
                return strCompare;
            }
        }
        return this.segments.length - oSegs.length;
    }

    @Deprecated
    public int osgiCompareTo(Version o) {
        return this.compareTo(o);
    }
}

