/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PackagePropertiesImpl
implements PackageProperties {
    private static final Logger log = LoggerFactory.getLogger(PackagePropertiesImpl.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER_LEGACY = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private static final DateTimeFormatter DATE_TIME_FORMATTER_ISO_8601 = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private PackageId id;

    @Override
    public PackageId getId() {
        if (this.id == null) {
            String version = this.getProperty("version");
            if (version == null) {
                log.warn("Package does not specify a version. setting to ''");
                version = "";
            }
            String group = this.getProperty("group");
            String name = this.getProperty("name");
            if (group != null && name != null) {
                this.id = new PackageId(group, name, version);
            } else {
                log.warn("Package properties not valid. need group and name property.");
            }
        }
        return this.id;
    }

    @Nullable
    protected PackageId getCachedId() {
        return this.id;
    }

    @Override
    public Calendar getLastModified() {
        return this.getDateProperty("lastModified");
    }

    @Override
    public String getLastModifiedBy() {
        return this.getProperty("lastModifiedBy");
    }

    @Override
    public Calendar getCreated() {
        return this.getDateProperty("created");
    }

    @Override
    public String getCreatedBy() {
        return this.getProperty("createdBy");
    }

    @Override
    public Calendar getLastWrapped() {
        return this.getDateProperty("lastWrapped");
    }

    @Override
    public String getLastWrappedBy() {
        return this.getProperty("lastWrappedBy");
    }

    @Override
    public String getDescription() {
        return this.getProperty("description");
    }

    @Override
    public AccessControlHandling getACHandling() {
        String ac = this.getProperty("acHandling");
        if (ac == null) {
            return AccessControlHandling.IGNORE;
        }
        try {
            return AccessControlHandling.valueOf(ac.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.warn("invalid access control handling configured: {}", (Object)ac);
            return AccessControlHandling.IGNORE;
        }
    }

    @Override
    public SubPackageHandling getSubPackageHandling() {
        return SubPackageHandling.fromString(this.getProperty("subPackageHandling"));
    }

    @Override
    public boolean requiresRoot() {
        return "true".equals(this.getProperty("requiresRoot"));
    }

    @Override
    public boolean requiresRestart() {
        return "true".equals(this.getProperty("requiresRestart"));
    }

    @Override
    public Dependency[] getDependencies() {
        String deps = this.getProperty("dependencies");
        if (deps == null) {
            return Dependency.EMPTY;
        }
        return Dependency.parse(deps);
    }

    @Override
    public Map<PackageId, URI> getDependenciesLocations() {
        String deps = this.getProperty("dependencies-locations");
        if (deps == null || deps.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<PackageId, URI> dependenciesLocations = new HashMap<PackageId, URI>();
        for (String item : deps.split(",")) {
            String[] parts = item.split("=", 2);
            if (parts.length < 2) {
                log.error("Invalid dependencies locations string, item " + item + " does not contain a '='");
                continue;
            }
            PackageId packageId = PackageId.fromString(parts[0]);
            if (packageId == null) {
                log.error("Invalid package id given in item " + item);
                continue;
            }
            try {
                URI uri = new URI(parts[1]);
                dependenciesLocations.put(packageId, uri);
            }
            catch (URISyntaxException e) {
                log.error("Invalid uri given in item " + item);
            }
        }
        return dependenciesLocations;
    }

    @Override
    public Calendar getDateProperty(String name) {
        GregorianCalendar result;
        block4: {
            result = null;
            try {
                ZonedDateTime zonedDateTime;
                String p = this.getProperty(name);
                if (p == null) break block4;
                try {
                    zonedDateTime = ZonedDateTime.parse(p, DATE_TIME_FORMATTER_ISO_8601);
                }
                catch (DateTimeParseException e) {
                    zonedDateTime = ZonedDateTime.parse(p, DATE_TIME_FORMATTER_LEGACY);
                }
                result = GregorianCalendar.from(zonedDateTime);
            }
            catch (Exception e) {
                log.error("Error while converting date property", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getProperty(String name) {
        try {
            Properties props = this.getPropertiesMap();
            return props == null ? null : props.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Nullable
    public PackageType getPackageType() {
        String pt = this.getProperty("packageType");
        if (pt != null) {
            try {
                return PackageType.valueOf(pt.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid package type configured: {}", (Object)pt);
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getExternalHooks() {
        Properties props = this.getPropertiesMap();
        HashMap<String, String> hookClasses = new HashMap<String, String>();
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                if (!name.startsWith("installhook.")) continue;
                String[] segs = Text.explode(name.substring("installhook.".length()), 46);
                if (segs.length == 0 || segs.length > 2 || !"class".equals(segs[1])) {
                    log.warn("Invalid installhook property: {}", (Object)name);
                }
                hookClasses.put(segs[0], props.getProperty(name));
            }
        }
        return hookClasses;
    }

    @Override
    public long getBuildCount() {
        try {
            return Long.parseLong(this.getProperty("buildCount"));
        }
        catch (NumberFormatException e) {
            log.warn("Invalid buildcount property, must be an integer");
            return 0L;
        }
    }

    protected abstract Properties getPropertiesMap();
}

