/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.ide.impl.vlt.JcrCommand;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryPath;

public class GetNodeCommand
extends JcrCommand<byte[]> {
    public GetNodeCommand(Repository repository, Credentials credentials, RepositoryPath path, Logger logger) {
        super(repository, credentials, path, logger, new Repository.CommandExecutionFlag[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] execute0(Session session) throws RepositoryException, IOException {
        Property property;
        Node node = session.getNode(this.getPath().asString());
        if (node.hasProperty("jcr:data")) {
            property = node.getProperty("jcr:data");
        } else {
            if (!node.hasNode("jcr:content")) {
                return null;
            }
            Node contentNode = node.getNode("jcr:content");
            if (!contentNode.hasProperty("jcr:data")) {
                return null;
            }
            property = contentNode.getProperty("jcr:data");
        }
        if (property.getType() == 2) {
            Binary binary = property.getBinary();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int read;
                byte[] buffer = new byte[2048];
                InputStream stream = binary.getStream();
                while ((read = stream.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                binary.dispose();
            }
        }
        return null;
    }
}

