/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.core.impl.EntityResourceList;
import org.apache.sling.installer.core.impl.FileDataStore;
import org.apache.sling.installer.core.impl.InternalResource;
import org.apache.sling.installer.core.impl.RegisteredResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentResourceList {
    private static final int VERSION = 2;
    public static final String RESTART_ACTIVE_BUNDLES_TYPE = "org.apache.sling.installer.core.restart.bundles";
    public static final String RESTART_ACTIVE_BUNDLES_ID = "org.apache.sling.installer.core.restart.bundles";
    public static final String RESTART_ACTIVE_BUNDLES_ENTITY_ID = "org.apache.sling.installer.core.restart.bundles:org.apache.sling.installer.core.restart.bundles";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, EntityResourceList> data;
    private final File dataFile;
    private final List<RegisteredResource> untransformedResources;
    private final InstallationListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentResourceList(File dataFile, InstallationListener listener) {
        this.dataFile = dataFile;
        this.listener = listener;
        Map restoredData = null;
        List unknownList = null;
        if (dataFile.exists()) {
            Object ois = null;
            try {
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(dataFile)));
                int n = ((ObjectInputStream)ois).readInt();
                if (n > 0 && n <= 2) {
                    restoredData = (Map)((ObjectInputStream)ois).readObject();
                    if (n == 2) {
                        unknownList = (List)((ObjectInputStream)ois).readObject();
                    }
                } else {
                    this.logger.warn("Unknown version for persistent resource list: {}", (Object)n);
                }
                this.logger.debug("Restored resource list: {}", restoredData);
                this.logger.debug("Restored unknown resource list: {}", unknownList);
            }
            catch (Exception exception) {
                this.logger.warn("Unable to restore data, starting with empty list (" + exception.getMessage() + ")", (Throwable)exception);
                restoredData = null;
                unknownList = null;
            }
            finally {
                if (ois != null) {
                    try {
                        ((ObjectInputStream)ois).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.data = restoredData != null ? restoredData : new HashMap();
        this.untransformedResources = unknownList != null ? unknownList : new ArrayList();
        this.updateCache();
        for (Map.Entry entry : this.data.entrySet()) {
            EntityResourceList erl = (EntityResourceList)entry.getValue();
            erl.setResourceId((String)entry.getKey());
            erl.setListener(listener);
        }
        if (this.getEntityResourceList(RESTART_ACTIVE_BUNDLES_ENTITY_ID) == null) {
            RegisteredResource rr = this.addOrUpdate(new InternalResource("$sling-installer$", "org.apache.sling.installer.core.restart.bundles", null, new Hashtable<String, Object>(), "properties", "1", null, null, null));
            TransformationResult transformationResult = new TransformationResult();
            transformationResult.setId("org.apache.sling.installer.core.restart.bundles");
            transformationResult.setResourceType("org.apache.sling.installer.core.restart.bundles");
            this.transform(rr, new TransformationResult[]{transformationResult});
        }
    }

    private void updateCache() {
        for (EntityResourceList group : this.data.values()) {
            for (RegisteredResource registeredResource : group.listResources()) {
                if (!((RegisteredResourceImpl)registeredResource).hasDataFile()) continue;
                FileDataStore.SHARED.updateDigestCache(registeredResource.getURL(), ((RegisteredResourceImpl)registeredResource).getDataFile(), registeredResource.getDigest());
            }
        }
        for (RegisteredResource rr : this.untransformedResources) {
            if (!((RegisteredResourceImpl)rr).hasDataFile()) continue;
            FileDataStore.SHARED.updateDigestCache(rr.getURL(), ((RegisteredResourceImpl)rr).getDataFile(), rr.getDigest());
        }
    }

    public void save() {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataFile)));){
            oos.writeInt(2);
            oos.writeObject(this.data);
            oos.writeObject(this.untransformedResources);
            this.logger.debug("Persisted resource list.");
        }
        catch (Exception e) {
            this.logger.warn("Unable to save persistent list: " + e.getMessage(), (Throwable)e);
        }
    }

    public Collection<String> getEntityIds() {
        return this.data.keySet();
    }

    public RegisteredResource addOrUpdate(InternalResource input) {
        for (RegisteredResource rr : this.untransformedResources) {
            if (!rr.getURL().equals(input.getURL()) || !rr.getDigest().equals(input.getDigest())) continue;
            ((RegisteredResourceImpl)rr).update(input);
            return rr;
        }
        for (EntityResourceList group : this.data.values()) {
            for (RegisteredResource registeredResource : group.listResources()) {
                if (!registeredResource.getURL().equals(input.getURL()) || !registeredResource.getDigest().equals(input.getDigest())) continue;
                ((RegisteredResourceImpl)registeredResource).update(input);
                return registeredResource;
            }
        }
        try {
            RegisteredResourceImpl registeredResource = RegisteredResourceImpl.create(input);
            this.checkInstallable(registeredResource);
            return registeredResource;
        }
        catch (IOException ioe) {
            this.logger.warn("Ignoring resource. Error during processing of " + input.getURL(), (Throwable)ioe);
            return null;
        }
    }

    private void checkInstallable(RegisteredResourceImpl input) {
        if (!"file".equals(input.getType()) && !"properties".equals(input.getType())) {
            EntityResourceList t = this.data.get(input.getEntityId());
            if (t == null) {
                t = new EntityResourceList(input.getEntityId(), this.listener);
                this.data.put(input.getEntityId(), t);
            }
            t.addOrUpdate(input);
        } else {
            if (this.untransformedResources.contains(input)) {
                this.untransformedResources.remove(input);
            }
            this.untransformedResources.add(input);
        }
    }

    public List<RegisteredResource> getUntransformedResources() {
        return this.untransformedResources;
    }

    public void remove(String url) {
        for (EntityResourceList group : this.data.values()) {
            group.remove(url);
        }
        Iterator<RegisteredResource> i = this.untransformedResources.iterator();
        while (i.hasNext()) {
            RegisteredResource rr = i.next();
            if (!rr.getURL().equals(url)) continue;
            ((RegisteredResourceImpl)rr).cleanup();
            i.remove();
            break;
        }
    }

    public EntityResourceList getEntityResourceList(String entityId) {
        EntityResourceList erl = this.data.get(entityId);
        if (erl == null) {
            for (EntityResourceList group : this.data.values()) {
                if (!entityId.equals(group.getFullAlias())) continue;
                erl = group;
                break;
            }
        }
        return erl;
    }

    public boolean compact() {
        boolean startNewCycle = false;
        Iterator<Map.Entry<String, EntityResourceList>> i = this.data.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, EntityResourceList> entry = i.next();
            startNewCycle |= entry.getValue().compact();
            if (!entry.getValue().isEmpty()) continue;
            i.remove();
        }
        return startNewCycle;
    }

    public void transform(RegisteredResource resource, TransformationResult[] result) {
        this.untransformedResources.remove(resource);
        try {
            HashSet<String> entityIds = new HashSet<String>();
            for (int i = 0; i < result.length; ++i) {
                TransformationResult tr = result[i];
                if (tr == null) {
                    this.logger.warn("Ignoring null result for {}", (Object)resource);
                    continue;
                }
                if (tr.getResourceType() != null && tr.getId() == null) {
                    this.logger.error("Result for {} contains new resource type {} but no unique id!", (Object)resource, (Object)tr.getResourceType());
                    continue;
                }
                RegisteredResourceImpl clone = (RegisteredResourceImpl)((RegisteredResourceImpl)resource).clone(result[i]);
                this.checkInstallable(clone);
                entityIds.add(clone.getEntityId());
            }
            for (EntityResourceList group : this.data.values()) {
                if (entityIds.contains(group.getResourceId()) || !group.removeInternal(resource.getURL())) continue;
                this.logger.debug("Removed stale resources from group with entityid: {} because after transforming {} the entityids have changed.", (Object)group.getResourceId(), (Object)resource);
            }
        }
        catch (IOException ioe) {
            this.logger.warn("Ignoring resource. Error during processing of " + resource, (Throwable)ioe);
        }
    }

    public boolean isSpecialEntityId(String id) {
        return RESTART_ACTIVE_BUNDLES_ENTITY_ID.equals(id);
    }

    public void update(String oldId, String newAlias, String newId) {
        EntityResourceList list = this.data.remove(oldId);
        if (list != null) {
            list.update(newAlias, newId);
            this.data.put(newId, list);
        }
    }
}

