/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.jsapi;

import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.scripting.sightly.js.impl.JsEnvironment;
import org.apache.sling.scripting.sightly.js.impl.jsapi.SlyBindingsValuesProvider;
import org.apache.sling.scripting.sightly.js.impl.rhino.HybridObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ProxyAsyncScriptableFactory.class})
public class ProxyAsyncScriptableFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyAsyncScriptableFactory.class);
    @Reference
    private SlyBindingsValuesProvider slyBindingsValuesProvider = null;

    public void registerProxies(ResourceResolver resourceResolver, JsEnvironment environment, Bindings bindings) {
        this.slyBindingsValuesProvider.initialise(resourceResolver, environment, bindings);
        LazyBindings bindingsCopy = new LazyBindings();
        for (String factoryName : this.slyBindingsValuesProvider.getScriptPaths().keySet()) {
            ShadowScriptableObject shadowScriptableObject = new ShadowScriptableObject(factoryName, (Bindings)bindingsCopy);
            bindings.put(factoryName, (Object)shadowScriptableObject);
        }
        bindingsCopy.putAll(bindings);
    }

    class ShadowScriptableObject
    extends ScriptableObject {
        private String clazz;
        private Bindings bindings;
        private Set<String> scriptNSUse = new HashSet<String>();

        public ShadowScriptableObject(String clazz, Bindings bindings) {
            this.clazz = clazz;
            this.bindings = bindings;
        }

        public String getClassName() {
            return this.clazz;
        }

        public Object get(String name, Scriptable start) {
            HybridObject hybridObject;
            Object object = this.bindings.get(this.clazz);
            if (!(object instanceof HybridObject)) {
                ProxyAsyncScriptableFactory.this.slyBindingsValuesProvider.processBindings(this.bindings);
            }
            if ((hybridObject = (HybridObject)this.bindings.get(this.clazz)) != null) {
                String script = (String)this.bindings.get("javax.script.filename");
                if (StringUtils.isNotEmpty((CharSequence)script) && this.scriptNSUse.add(this.clazz + ":" + script)) {
                    LOGGER.warn("Script {} uses the deprecated asynchronous API provided by the '{}' namespace. Please refactor the script to use the synchronous API provided by the org.apache.sling.scripting.javascript bundle.", (Object)script, (Object)this.clazz);
                }
                return hybridObject.get(name, start);
            }
            return Undefined.instance;
        }
    }
}

