/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.contentparser.impl;

public final class JsonTicksConverter {
    private JsonTicksConverter() {
    }

    public static String tickToDoubleQuote(String input) {
        int len = input.length();
        StringBuilder output = new StringBuilder(len);
        boolean quoted = false;
        boolean tickQuoted = false;
        boolean escaped = false;
        boolean comment = false;
        char lastChar = ' ';
        for (int i = 0; i < len; ++i) {
            char in = input.charAt(i);
            if (quoted || tickQuoted) {
                if (escaped) {
                    if (in != '\'') {
                        output.append("\\");
                    }
                    if (in == '\\') {
                        output.append("\\");
                    }
                    escaped = false;
                } else if (in == '\"') {
                    if (quoted) {
                        quoted = false;
                    } else if (tickQuoted) {
                        output.append("\\");
                    }
                } else if (in == '\'') {
                    if (tickQuoted) {
                        in = '\"';
                        tickQuoted = false;
                    }
                } else if (in == '\\') {
                    escaped = true;
                }
            } else if (comment) {
                if (lastChar == '*' && in == '/') {
                    comment = false;
                }
            } else if (lastChar == '/' && in == '*') {
                comment = true;
            } else if (in == '\'') {
                in = '\"';
                tickQuoted = true;
            } else if (in == '\"') {
                quoted = true;
            }
            if (in == '\\') continue;
            output.append(in);
            lastChar = in;
        }
        return output.toString();
    }
}

