/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.json;

import org.apache.jackrabbit.oak.commons.json.JsopReader;

public class JsopTokenizer
implements JsopReader {
    private static final String[] TYPE = new String[]{"end", "string", "number", "true", "false", "null", "error"};
    private final String jsop;
    private final int length;
    private int lastPos;
    private int pos;
    private int currentType;
    private boolean currentEscaped;
    private String currentToken;
    private int lastType;
    private String lastToken;
    private boolean lastEscaped;

    public JsopTokenizer(String json, int pos) {
        this.jsop = json;
        this.length = json.length();
        this.pos = pos;
        this.read();
    }

    public JsopTokenizer(String json) {
        this(json, 0);
    }

    @Override
    public void resetReader() {
        this.pos = 0;
        this.read();
    }

    public String toString() {
        return this.jsop;
    }

    @Override
    public int getTokenType() {
        return this.lastType;
    }

    @Override
    public String getToken() {
        if (this.lastType > 8) {
            return String.valueOf((char)this.lastType);
        }
        return this.lastEscaped ? JsopTokenizer.decode(this.lastToken) : this.lastToken;
    }

    public String getEscapedToken() {
        return this.lastToken;
    }

    @Override
    public String read(int type) {
        if (this.matches(type)) {
            return this.getToken();
        }
        throw JsopTokenizer.getFormatException(this.jsop, this.pos, JsopTokenizer.getTokenType(type));
    }

    private void skip(int type) {
        if (!this.matches(type)) {
            throw JsopTokenizer.getFormatException(this.jsop, this.pos, JsopTokenizer.getTokenType(type));
        }
    }

    @Override
    public String readString() {
        return this.read(1);
    }

    @Override
    public boolean matches(int type) {
        if (this.currentType == type) {
            this.read();
            return true;
        }
        return false;
    }

    @Override
    public int read() {
        this.lastPos = this.pos;
        this.lastType = this.currentType;
        this.lastToken = this.currentToken;
        this.lastEscaped = this.currentEscaped;
        try {
            this.currentType = this.readToken();
        }
        catch (IllegalArgumentException e) {
            this.currentType = 6;
            this.currentToken = e.getMessage();
        }
        catch (StringIndexOutOfBoundsException e) {
            this.currentType = 6;
            this.currentToken = JsopTokenizer.addAsterisk(this.jsop, this.pos);
        }
        return this.lastType;
    }

    private int readToken() {
        char ch;
        this.currentEscaped = false;
        while (true) {
            if (this.pos >= this.length) {
                return 0;
            }
            ch = this.jsop.charAt(this.pos);
            if (ch > ' ') break;
            ++this.pos;
        }
        int start = this.pos++;
        switch (ch) {
            case '\"': {
                while ((ch = this.jsop.charAt(this.pos++)) != '\"') {
                    if (ch != '\\') continue;
                    this.currentEscaped = true;
                    ++this.pos;
                }
                this.currentToken = this.jsop.substring(start + 1, this.pos - 1);
                return 1;
            }
            case '*': 
            case '+': 
            case ',': 
            case ':': 
            case ';': 
            case '=': 
            case '>': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '}': {
                return ch;
            }
            case '/': {
                ch = this.jsop.charAt(this.pos);
                if (ch != '*') {
                    return 47;
                }
                ++this.pos;
                while ((ch = this.jsop.charAt(this.pos++)) != '*' || this.jsop.charAt(this.pos) != '/') {
                }
                this.currentToken = this.jsop.substring(start + 2, this.pos - 1);
                this.pos += 2;
                return 8;
            }
            case '-': {
                ch = this.jsop.charAt(this.pos);
                if (ch >= '0' && ch <= '9') break;
                return 45;
            }
        }
        if (ch >= '0' && ch <= '9') {
            while (this.pos < this.length && (ch = this.jsop.charAt(this.pos)) >= '0' && ch <= '9') {
                ++this.pos;
            }
            if (ch == '.') {
                ++this.pos;
                while (this.pos < this.length && (ch = this.jsop.charAt(this.pos)) >= '0' && ch <= '9') {
                    ++this.pos;
                }
            }
            if (ch == 'e' || ch == 'E') {
                if ((ch = this.jsop.charAt(++this.pos)) == '+' || ch == '-') {
                    ch = this.jsop.charAt(++this.pos);
                }
                while (this.pos < this.length && (ch = this.jsop.charAt(this.pos)) >= '0' && ch <= '9') {
                    ++this.pos;
                }
            }
            this.currentToken = this.jsop.substring(start, this.pos);
            return 2;
        }
        if (ch >= 'a' && ch <= 'z') {
            while (this.pos < this.length && ((ch = this.jsop.charAt(this.pos)) >= 'a' && ch <= 'z' || ch == '_' || ch >= '0' && ch <= '9')) {
                ++this.pos;
            }
            String s = this.jsop.substring(start, this.pos);
            if ("null".equals(s)) {
                this.currentToken = null;
                return 5;
            }
            if ("true".equals(s)) {
                this.currentToken = s;
                return 3;
            }
            if ("false".equals(s)) {
                this.currentToken = s;
                return 4;
            }
            this.currentToken = s;
            return 7;
        }
        throw JsopTokenizer.getFormatException(this.jsop, this.pos);
    }

    public static String decodeQuoted(String s) {
        if (s.length() < 2 || s.charAt(0) != '\"' || s.charAt(s.length() - 1) != '\"') {
            throw JsopTokenizer.getFormatException(s, 0);
        }
        s = s.substring(1, s.length() - 1);
        return JsopTokenizer.decode(s);
    }

    public static String decode(String s) {
        if (s.indexOf(92) < 0) {
            return s;
        }
        int length = s.length();
        StringBuilder buff = new StringBuilder(length);
        block13: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (i + 1 >= length) {
                    throw JsopTokenizer.getFormatException(s, i);
                }
                c = s.charAt(++i);
                switch (c) {
                    case '\"': {
                        buff.append('\"');
                        continue block13;
                    }
                    case '\\': {
                        buff.append('\\');
                        continue block13;
                    }
                    case '/': {
                        buff.append('/');
                        continue block13;
                    }
                    case 'b': {
                        buff.append('\b');
                        continue block13;
                    }
                    case 'f': {
                        buff.append('\f');
                        continue block13;
                    }
                    case 'n': {
                        buff.append('\n');
                        continue block13;
                    }
                    case 'r': {
                        buff.append('\r');
                        continue block13;
                    }
                    case 't': {
                        buff.append('\t');
                        continue block13;
                    }
                    case 'u': {
                        try {
                            c = (char)Integer.parseInt(s.substring(i + 1, i + 5), 16);
                        }
                        catch (NumberFormatException e) {
                            throw JsopTokenizer.getFormatException(s, i);
                        }
                        i += 4;
                        buff.append(c);
                        continue block13;
                    }
                    default: {
                        throw JsopTokenizer.getFormatException(s, i);
                    }
                }
            }
            buff.append(c);
        }
        return buff.toString();
    }

    private static String getTokenType(int type) {
        return type <= 8 ? TYPE[type] : "'" + (char)type + "'";
    }

    private static IllegalArgumentException getFormatException(String s, int i, String expected) {
        return new IllegalArgumentException(JsopTokenizer.addAsterisk(s, i) + " expected: " + expected);
    }

    private static IllegalArgumentException getFormatException(String s, int i) {
        return new IllegalArgumentException(JsopTokenizer.addAsterisk(s, i));
    }

    private static String addAsterisk(String s, int index) {
        if (s != null) {
            index = Math.min(index, ((String)s).length());
            s = ((String)s).substring(0, index) + "[*]" + ((String)s).substring(index);
        }
        return s;
    }

    @Override
    public String readRawValue() {
        int start;
        for (start = this.lastPos; start < this.length && this.jsop.charAt(start) <= ' '; ++start) {
        }
        this.skipRawValue();
        return this.jsop.substring(start, this.lastPos);
    }

    private void skipRawValue() {
        block0 : switch (this.currentType) {
            case 91: {
                int level = 0;
                while (true) {
                    if (this.matches(93)) {
                        if (--level != 0) continue;
                        break block0;
                    }
                    if (this.matches(91)) {
                        ++level;
                        continue;
                    }
                    if (this.matches(0)) {
                        throw JsopTokenizer.getFormatException(this.jsop, this.pos, "value");
                    }
                    this.read();
                }
            }
            case 123: {
                this.read();
                if (this.matches(125)) break;
                do {
                    this.skip(1);
                    this.read(58);
                    this.skipRawValue();
                } while (this.matches(44));
                this.read(125);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                this.read();
                break;
            }
            default: {
                throw JsopTokenizer.getFormatException(this.jsop, this.pos, "value");
            }
        }
    }

    public int getPos() {
        return this.pos;
    }

    public int getLastPos() {
        return this.lastPos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }
}

