/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query.qom;

import javax.jcr.query.qom.Column;
import org.apache.jackrabbit.oak.jcr.query.qom.QOMNode;

public class ColumnImpl
extends QOMNode
implements Column {
    private final String selectorName;
    private final String propertyName;
    private final String columnName;

    public ColumnImpl(String selectorName, String propertyName, String columnName) {
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getSelectorName() {
        return this.selectorName;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.selectorName != null) {
            buff.append(this.quoteSelectorName(this.selectorName));
            buff.append('.');
        }
        if (this.propertyName != null) {
            buff.append(this.quotePropertyName(this.propertyName));
        } else {
            buff.append('*');
        }
        if (this.columnName != null) {
            buff.append(" AS ").append(this.quoteColumnName(this.columnName));
        }
        return buff.toString();
    }
}

