/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import java.util.ArrayList;
import java.util.Arrays;

public interface RefreshStrategy {
    public boolean needsRefresh(long var1);

    public void refreshed();

    public static class Timed
    implements RefreshStrategy {
        protected final long interval;

        public Timed(long interval) {
            this.interval = interval;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            return secondsSinceLastAccess > this.interval;
        }

        @Override
        public void refreshed() {
        }

        public String toString() {
            return "Refresh every " + this.interval + " seconds";
        }
    }

    public static class Composite
    implements RefreshStrategy {
        private final RefreshStrategy[] refreshStrategies;

        public static RefreshStrategy create(RefreshStrategy ... refreshStrategies) {
            ArrayList<RefreshStrategy> strategies = new ArrayList<RefreshStrategy>();
            for (RefreshStrategy strategy : refreshStrategies) {
                if (strategy instanceof Composite) {
                    strategies.addAll(Arrays.asList(((Composite)strategy).refreshStrategies));
                    continue;
                }
                strategies.add(strategy);
            }
            return new Composite(strategies.toArray(new RefreshStrategy[strategies.size()]));
        }

        private Composite(RefreshStrategy ... refreshStrategies) {
            this.refreshStrategies = refreshStrategies;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            for (RefreshStrategy r : this.refreshStrategies) {
                if (!r.needsRefresh(secondsSinceLastAccess)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void refreshed() {
            for (RefreshStrategy refreshStrategy : this.refreshStrategies) {
                refreshStrategy.refreshed();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (RefreshStrategy strategy : this.refreshStrategies) {
                sb.append(sep).append(strategy.toString());
                sep = ", ";
            }
            return sb.toString();
        }
    }
}

